/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.masterstore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.cornerstone.blocks.masterstore.RepositoryManager;
import org.apache.avalon.cornerstone.services.store.Repository;
import org.apache.avalon.excalibur.io.ExtensionFileFilter;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.Block;
import org.apache.avalon.phoenix.BlockContext;

public abstract class AbstractFileRepository
extends AbstractLogEnabled
implements Block,
Repository,
Contextualizable,
Composable,
Configurable,
Initializable {
    protected static final boolean DEBUG = false;
    protected static final String HANDLED_URL = "file://";
    protected static final int BYTE_MASK = 15;
    protected static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected String m_path;
    protected String m_destination;
    protected String m_extension;
    protected String m_name;
    protected FilenameFilter m_filter;
    protected File m_baseDirectory;
    protected ComponentManager m_componentManager;
    protected BlockContext m_context;

    protected abstract String getExtensionDecorator();

    public void contextualize(Context context) {
        BlockContext blockContext = (BlockContext)context;
        this.m_baseDirectory = blockContext.getBaseDirectory();
    }

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_componentManager = componentManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (this.m_destination == null) {
            String destination = configuration.getAttribute("destinationURL");
            this.setDestination(destination);
        }
    }

    public void initialize() throws Exception {
        this.getLogger().info("Init " + this.getClass().getName() + " Store");
        this.m_name = RepositoryManager.getName();
        this.m_extension = "." + this.m_name + this.getExtensionDecorator();
        this.m_filter = new ExtensionFileFilter(this.m_extension);
        File directory = new File(this.m_path);
        directory.mkdirs();
        this.getLogger().info(this.getClass().getName() + " opened in " + this.m_path);
    }

    protected void setDestination(String destination) throws ConfigurationException {
        if (!destination.startsWith(HANDLED_URL)) {
            throw new ConfigurationException("cannot handle destination " + destination);
        }
        this.m_path = destination.substring(HANDLED_URL.length());
        File directory = new File(this.m_baseDirectory, this.m_path);
        try {
            directory = directory.getCanonicalFile();
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Unable to form canonical representation of " + directory);
        }
        this.m_path = directory.toString();
        this.m_destination = destination;
    }

    protected AbstractFileRepository createChildRepository() throws Exception {
        return (AbstractFileRepository)this.getClass().newInstance();
    }

    public Repository getChildRepository(String childName) {
        AbstractFileRepository child = null;
        try {
            child = this.createChildRepository();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create child repository " + childName + " : " + e);
        }
        try {
            child.compose(this.m_componentManager);
        }
        catch (ComponentException cme) {
            throw new RuntimeException("Cannot compose child repository " + childName + " : " + (Object)((Object)cme));
        }
        try {
            child.setDestination(this.m_destination + File.pathSeparatorChar + childName + File.pathSeparator);
        }
        catch (ConfigurationException ce) {
            throw new RuntimeException("Cannot set destination for child child repository " + childName + " : " + (Object)((Object)ce));
        }
        try {
            child.initialize();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize child repository " + childName + " : " + e);
        }
        return child;
    }

    protected File getFile(String key) throws IOException {
        return new File(this.encode(key));
    }

    protected InputStream getInputStream(String key) throws IOException {
        return new FileInputStream(this.getFile(key));
    }

    protected OutputStream getOutputStream(String key) throws IOException {
        return new FileOutputStream(this.getFile(key));
    }

    public synchronized void remove(String key) {
        try {
            File file = this.getFile(key);
            file.delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught while removing an object: " + e);
        }
    }

    public synchronized boolean containsKey(String key) {
        try {
            File file = this.getFile(key);
            return file.exists();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught while searching an object: " + e);
        }
    }

    public Iterator list() {
        File storeDir = new File(this.m_path);
        String[] names = storeDir.list(this.m_filter);
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < names.length) {
            list.add(this.decode(names[i]));
            ++i;
        }
        return ((AbstractList)list).iterator();
    }

    protected String encode(String key) {
        byte[] bytes = key.getBytes();
        char[] buffer = new char[bytes.length << 1];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            byte k = bytes[i];
            buffer[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buffer[j++] = HEX_DIGITS[k & 0xF];
            ++i;
        }
        StringBuffer result = new StringBuffer();
        result.append(this.m_path);
        result.append(File.separator);
        result.append(buffer);
        result.append(this.m_extension);
        return result.toString();
    }

    protected String decode(String filename) {
        filename = filename.substring(0, filename.length() - this.m_extension.length());
        int size = filename.length();
        byte[] bytes = new byte[size >>> 1];
        int i = 0;
        int j = 0;
        while (i < size) {
            bytes[j] = Byte.parseByte(filename.substring(i, i + 2), 16);
            i += 2;
            ++j;
        }
        return new String(bytes);
    }
}

