/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.masterstore;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.avalon.cornerstone.blocks.masterstore.AbstractFileRepository;
import org.apache.avalon.cornerstone.blocks.masterstore.ResettableFileInputStream;
import org.apache.avalon.cornerstone.services.store.StreamRepository;
import org.apache.avalon.excalibur.io.IOUtil;

public class File_Persistent_Stream_Repository
extends AbstractFileRepository
implements StreamRepository {
    protected final HashMap m_inputs = new HashMap();
    protected final HashMap m_outputs = new HashMap();

    protected String getExtensionDecorator() {
        return ".FileStreamStore";
    }

    /*
     * WARNING - void declaration
     */
    public synchronized InputStream get(String key) {
        try {
            void ioe;
            ResettableFileInputStream stream = new ResettableFileInputStream(this.getFile(key));
            Object o = this.m_inputs.get(key);
            if (o == null) {
                this.m_inputs.put(key, stream);
            } else if (o instanceof ArrayList) {
                ((ArrayList)o).add(stream);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(o);
                list.add(stream);
                this.m_inputs.put(key, stream);
            }
            return ioe;
        }
        catch (IOException ioe) {
            String message = "Exception caught while retrieving a stream ";
            this.getLogger().warn("Exception caught while retrieving a stream ", (Throwable)ioe);
            throw new RuntimeException("Exception caught while retrieving a stream " + ": " + ioe);
        }
    }

    public synchronized OutputStream put(String key) {
        try {
            OutputStream outputStream = this.getOutputStream(key);
            BufferedOutputStream stream = new BufferedOutputStream(outputStream);
            Object o = this.m_outputs.get(key);
            if (o == null) {
                this.m_outputs.put(key, stream);
            } else if (o instanceof ArrayList) {
                ((ArrayList)o).add(stream);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(o);
                list.add(stream);
                this.m_outputs.put(key, stream);
            }
            return stream;
        }
        catch (IOException ioe) {
            String message = "Exception caught while storing a stream ";
            this.getLogger().warn("Exception caught while storing a stream ", (Throwable)ioe);
            throw new RuntimeException("Exception caught while storing a stream " + ": " + ioe);
        }
    }

    public void remove(String key) {
        int i;
        int size;
        ArrayList list;
        Object o = this.m_inputs.remove(key);
        if (o != null) {
            if (o instanceof InputStream) {
                IOUtil.shutdownStream((InputStream)((InputStream)o));
            } else {
                list = (ArrayList)o;
                size = list.size();
                i = 0;
                while (i < size) {
                    IOUtil.shutdownStream((InputStream)((InputStream)list.get(i)));
                    ++i;
                }
            }
        }
        if ((o = this.m_outputs.remove(key)) != null) {
            if (o instanceof OutputStream) {
                IOUtil.shutdownStream((OutputStream)((OutputStream)o));
            } else {
                list = (ArrayList)o;
                size = list.size();
                i = 0;
                while (i < size) {
                    IOUtil.shutdownStream((OutputStream)((OutputStream)list.get(0)));
                    ++i;
                }
            }
        }
        super.remove(key);
    }
}

