/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.masterstore;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.avalon.cornerstone.services.store.Repository;
import org.apache.avalon.cornerstone.services.store.Store;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.Block;

public class RepositoryManager
extends AbstractLogEnabled
implements Block,
Store,
Contextualizable,
Composable,
Configurable {
    private static final String REPOSITORY_NAME = "Repository";
    private static long id = 0L;
    protected HashMap m_repositories = new HashMap();
    protected HashMap m_models = new HashMap();
    protected HashMap m_classes = new HashMap();
    protected ComponentManager m_componentManager;
    protected Context m_context;

    public void contextualize(Context context) {
        this.m_context = context;
    }

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_componentManager = componentManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] registeredClasses = configuration.getChild("repositories").getChildren("repository");
        int i = 0;
        while (i < registeredClasses.length) {
            this.registerRepository(registeredClasses[i]);
            ++i;
        }
    }

    public void registerRepository(Configuration repConf) throws ConfigurationException {
        String className = repConf.getAttribute("class");
        this.getLogger().info("Registering Repository " + className);
        Configuration[] protocols = repConf.getChild("protocols").getChildren("protocol");
        Configuration[] types = repConf.getChild("types").getChildren("type");
        Configuration[] modelIterator = repConf.getChild("models").getChildren("model");
        int i = 0;
        while (i < protocols.length) {
            String protocol = protocols[i].getValue();
            int j = 0;
            while (j < types.length) {
                String type = types[j].getValue();
                int k = 0;
                while (k < modelIterator.length) {
                    String model = modelIterator[k].getValue();
                    this.m_classes.put(protocol + type + model, className);
                    this.getLogger().info("   for " + protocol + "," + type + "," + model);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void release(Component component) {
    }

    public boolean hasComponent(Object hint) {
        return hint instanceof Configuration;
    }

    public Component select(Object hint) throws ComponentException {
        Configuration repConf = null;
        try {
            repConf = (Configuration)hint;
        }
        catch (ClassCastException cce) {
            throw new ComponentException("Hint is of the wrong type. Must be a Configuration", (Throwable)cce);
        }
        URL destination = null;
        try {
            destination = new URL(repConf.getAttribute("destinationURL"));
        }
        catch (ConfigurationException ce) {
            throw new ComponentException("Malformed configuration has no destinationURL attribute", (Throwable)ce);
        }
        catch (MalformedURLException mue) {
            throw new ComponentException("destination is malformed. Must be a valid URL", (Throwable)mue);
        }
        try {
            String type = repConf.getAttribute("type");
            String repID = destination + type;
            Repository reply = (Repository)this.m_repositories.get(repID);
            String model = repConf.getAttribute("model");
            if (reply != null) {
                if (this.m_models.get(repID).equals(model)) {
                    return reply;
                }
                String message = "There is already another repository with the same destination and type but with different model";
                throw new ComponentException("There is already another repository with the same destination and type but with different model");
            }
            String protocol = destination.getProtocol();
            String repClass = (String)this.m_classes.get(protocol + type + model);
            this.getLogger().debug("Need instance of " + repClass + " to handle: " + protocol + type + model);
            try {
                reply = (Repository)Class.forName(repClass).newInstance();
                this.setupLogger(reply, "repository");
                if (reply instanceof Contextualizable) {
                    ((Contextualizable)reply).contextualize(this.m_context);
                }
                if (reply instanceof Composable) {
                    ((Composable)reply).compose(this.m_componentManager);
                }
                if (reply instanceof Configurable) {
                    ((Configurable)reply).configure(repConf);
                }
                if (reply instanceof Initializable) {
                    ((Initializable)reply).initialize();
                }
                this.m_repositories.put(repID, reply);
                this.m_models.put(repID, model);
                this.getLogger().info("New instance of " + repClass + " created for " + destination);
                return reply;
            }
            catch (Exception e) {
                String message = "Cannot find or init repository: " + e.getMessage();
                this.getLogger().warn(message, (Throwable)e);
                throw new ComponentException(message, (Throwable)e);
            }
        }
        catch (ConfigurationException ce) {
            throw new ComponentException("Malformed configuration", (Throwable)ce);
        }
    }

    public static final String getName() {
        return REPOSITORY_NAME + id++;
    }
}

