/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.packet;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.cornerstone.blocks.packet.PacketHandlerRunner;
import org.apache.avalon.cornerstone.services.packet.PacketHandler;
import org.apache.avalon.cornerstone.services.packet.PacketHandlerFactory;
import org.apache.avalon.excalibur.thread.ThreadPool;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

class Acceptor
extends AbstractLogEnabled
implements Component,
Runnable {
    private final DatagramSocket m_datagramSocket;
    private final PacketHandlerFactory m_handlerFactory;
    private final ThreadPool m_threadPool;
    private final ArrayList m_runners = new ArrayList();
    private Thread m_thread;

    public void dispose() throws Exception {
        Acceptor acceptor = this;
        synchronized (acceptor) {
            if (this.m_thread != null) {
                Thread thread = this.m_thread;
                this.m_thread = null;
                thread.interrupt();
                this.wait();
            }
        }
        Iterator runners = ((AbstractList)this.m_runners).iterator();
        while (runners.hasNext()) {
            PacketHandlerRunner runner = (PacketHandlerRunner)runners.next();
            runner.dispose();
        }
        this.m_runners.clear();
    }

    public void run() {
        this.m_thread = Thread.currentThread();
        while (this.m_thread != null && !Thread.interrupted()) {
            try {
                DatagramPacket packet = null;
                try {
                    int size = this.m_datagramSocket.getReceiveBufferSize();
                    byte[] buffer = new byte[size];
                    packet = new DatagramPacket(buffer, size);
                }
                catch (IOException ioe) {
                    this.getLogger().error("Failed to get receive buffer size for datagram socket", (Throwable)ioe);
                }
                this.m_datagramSocket.receive(packet);
                PacketHandler handler = this.m_handlerFactory.createPacketHandler();
                PacketHandlerRunner runner = new PacketHandlerRunner(packet, this.m_runners, handler);
                this.setupLogger(runner);
                this.m_threadPool.execute((Runnable)runner);
            }
            catch (InterruptedIOException iioe) {
            }
            catch (IOException ioe) {
                this.getLogger().error("Exception accepting connection", (Throwable)ioe);
            }
            catch (Exception e) {
                this.getLogger().error("Exception executing runner", (Throwable)e);
            }
        }
        Acceptor acceptor = this;
        synchronized (acceptor) {
            this.notifyAll();
            this.m_thread = null;
        }
    }

    public Acceptor(DatagramSocket datagramSocket, PacketHandlerFactory handlerFactory, ThreadPool threadPool) {
        this.m_datagramSocket = datagramSocket;
        this.m_handlerFactory = handlerFactory;
        this.m_threadPool = threadPool;
    }
}

