/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.packet;

import java.net.DatagramSocket;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.cornerstone.blocks.packet.Acceptor;
import org.apache.avalon.cornerstone.services.packet.PacketHandlerFactory;
import org.apache.avalon.cornerstone.services.packet.PacketManager;
import org.apache.avalon.cornerstone.services.threads.ThreadManager;
import org.apache.avalon.excalibur.thread.ThreadPool;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.Block;

public class DefaultPacketManager
extends AbstractLogEnabled
implements Block,
PacketManager,
Composable,
Disposable {
    private HashMap m_acceptors = new HashMap();
    private ThreadManager m_threadManager;

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_threadManager = (ThreadManager)componentManager.lookup("org.apache.avalon.cornerstone.services.threads.ThreadManager");
    }

    public void dispose() {
        Iterator names = ((HashMap)this.m_acceptors.clone()).keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            try {
                this.disconnect(name);
            }
            catch (Exception e) {
                this.getLogger().warn("Error disconnecting " + name, (Throwable)e);
            }
        }
    }

    public synchronized void connect(String name, DatagramSocket socket, PacketHandlerFactory handlerFactory, ThreadPool threadPool) throws Exception {
        if (this.m_acceptors.get(name) != null) {
            throw new IllegalArgumentException("Acceptor already exists with name " + name);
        }
        if (socket.getSoTimeout() == 0) {
            socket.setSoTimeout(500);
        }
        Acceptor acceptor = new Acceptor(socket, handlerFactory, threadPool);
        this.setupLogger(acceptor);
        this.m_acceptors.put(name, acceptor);
        threadPool.execute((Runnable)acceptor);
    }

    public synchronized void connect(String name, DatagramSocket socket, PacketHandlerFactory handlerFactory) throws Exception {
        this.connect(name, socket, handlerFactory, this.m_threadManager.getDefaultThreadPool());
    }

    public synchronized void disconnect(String name) throws Exception {
        this.disconnect(name, false);
    }

    public synchronized void disconnect(String name, boolean tearDown) throws Exception {
        Acceptor acceptor = (Acceptor)this.m_acceptors.remove(name);
        if (acceptor == null) {
            throw new IllegalArgumentException("No such acceptor with name " + name);
        }
        acceptor.dispose();
    }
}

