/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.packet;

import java.net.DatagramPacket;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.apache.avalon.cornerstone.services.packet.PacketHandler;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

class PacketHandlerRunner
extends AbstractLogEnabled
implements Runnable,
Component {
    private DatagramPacket m_packet;
    private Thread m_thread;
    private ArrayList m_runners;
    private PacketHandler m_handler;

    public void dispose() throws Exception {
        if (this.m_thread != null) {
            this.m_thread.interrupt();
            this.m_thread.join();
            this.m_thread = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.m_thread = Thread.currentThread();
                this.m_runners.add(this);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Starting connection on " + this.m_packet);
                }
                this.m_handler.handlePacket(this.m_packet);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Ending connection on " + this.m_packet);
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Error handling packet", (Throwable)e);
                return;
            }
            Object var2_1 = null;
            ((AbstractCollection)this.m_runners).remove(this);
            return;
        }
        finally {
            Object var2_2 = null;
            ((AbstractCollection)this.m_runners).remove(this);
        }
    }

    PacketHandlerRunner(DatagramPacket packet, ArrayList runners, PacketHandler handler) {
        this.m_packet = packet;
        this.m_runners = runners;
        this.m_handler = handler;
    }
}

