/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.scheduler;

import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.apache.avalon.cornerstone.blocks.scheduler.TimeScheduledEntry;
import org.apache.avalon.cornerstone.services.scheduler.Target;
import org.apache.avalon.cornerstone.services.scheduler.TimeScheduler;
import org.apache.avalon.cornerstone.services.scheduler.TimeTrigger;
import org.apache.avalon.cornerstone.services.threads.ThreadManager;
import org.apache.avalon.excalibur.collections.BinaryHeap;
import org.apache.avalon.excalibur.collections.PriorityQueue;
import org.apache.avalon.excalibur.collections.SynchronizedPriorityQueue;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.Block;

public class DefaultTimeScheduler
extends AbstractLogEnabled
implements Block,
TimeScheduler,
Composable,
Initializable,
Startable,
Disposable,
Runnable {
    private boolean m_running;
    private Hashtable m_entries;
    private PriorityQueue m_priorityQueue;
    private ThreadManager m_threadManager;

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_threadManager = (ThreadManager)componentManager.lookup("org.apache.avalon.cornerstone.services.threads.ThreadManager");
    }

    public void initialize() {
        this.m_entries = new Hashtable();
        this.m_priorityQueue = new SynchronizedPriorityQueue((PriorityQueue)new BinaryHeap());
    }

    public void dispose() {
        this.m_entries = null;
        this.m_priorityQueue = null;
    }

    public synchronized void addTrigger(String name, TimeTrigger trigger, Target target) {
        try {
            this.removeTrigger(name);
        }
        catch (NoSuchElementException nse) {
            // empty catch block
        }
        TimeScheduledEntry entry = new TimeScheduledEntry(name, trigger, target);
        this.m_entries.put(name, entry);
        boolean added = this.rescheduleEntry(entry, false);
        if (!added) {
            return;
        }
        try {
            if (entry == this.m_priorityQueue.peek()) {
                this.notifyAll();
            }
        }
        catch (NoSuchElementException nse) {
            this.getLogger().warn("Unexpected exception when peek() on priority queue for " + entry.getName(), (Throwable)nse);
        }
    }

    public synchronized void removeTrigger(String name) throws NoSuchElementException {
        TimeScheduledEntry entry = this.getEntry(name);
        entry.invalidate();
        this.m_entries.remove(name);
    }

    public synchronized void resetTrigger(String name) throws NoSuchElementException {
        TimeScheduledEntry entry = this.getEntry(name);
        entry.getTimeTrigger().reset();
        this.rescheduleEntry(entry, true);
    }

    private synchronized boolean rescheduleEntry(TimeScheduledEntry timeEntry, boolean clone) {
        long next;
        TimeScheduledEntry entry = timeEntry;
        if (clone) {
            entry = new TimeScheduledEntry(timeEntry.getName(), timeEntry.getTimeTrigger(), timeEntry.getTarget());
            timeEntry.invalidate();
            this.m_entries.remove(timeEntry.getName());
            this.m_entries.put(timeEntry.getName(), entry);
        }
        if (0L < (next = entry.getTimeTrigger().getTimeAfter(System.currentTimeMillis()))) {
            entry.setNextTime(next);
            this.m_priorityQueue.insert((Object)entry);
            if (entry == this.m_priorityQueue.peek()) {
                this.notify();
            }
            return true;
        }
        return false;
    }

    private TimeScheduledEntry getEntry(String name) throws NoSuchElementException {
        TimeScheduledEntry entry = (TimeScheduledEntry)this.m_entries.get(name);
        if (entry != null) {
            return entry;
        }
        throw new NoSuchElementException();
    }

    private void runEntry(TimeScheduledEntry entry) {
        Logger logger = this.getLogger();
        DefaultTimeScheduler defaultTimeScheduler = this;
        if (defaultTimeScheduler == null) {
            throw null;
        }
        Runnable runnable = new Runnable(defaultTimeScheduler, entry, logger){
            private final /* synthetic */ DefaultTimeScheduler this$0;
            private final /* synthetic */ TimeScheduledEntry val$entry;
            private final /* synthetic */ Logger val$logger;

            public void run() {
                try {
                    this.val$entry.getTarget().targetTriggered(this.val$entry.getName());
                }
                catch (Throwable t) {
                    this.val$logger.warn("Error occured executin trigger " + this.val$entry.getName(), t);
                }
            }
            {
                this.val$entry = val$entry;
                this.val$logger = val$logger;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(DefaultTimeScheduler defaultTimeScheduler) {
            }
        };
        try {
            this.m_threadManager.getDefaultThreadPool().execute(runnable);
        }
        catch (Exception e) {
            this.getLogger().warn("Error executing trigger " + entry.getName(), (Throwable)e);
        }
    }

    public void start() throws Exception {
        this.m_threadManager.getDefaultThreadPool().execute((Runnable)this);
    }

    public void stop() {
        this.m_running = false;
        DefaultTimeScheduler defaultTimeScheduler = this;
        synchronized (defaultTimeScheduler) {
            this.notifyAll();
        }
    }

    public void run() {
        this.m_running = true;
        while (this.m_running) {
            Object entry;
            long duration = 0L;
            if (!this.m_priorityQueue.isEmpty()) {
                entry = null;
                DefaultTimeScheduler defaultTimeScheduler = this;
                synchronized (defaultTimeScheduler) {
                    entry = this.getNextEntry();
                    if (entry == null) {
                        Object var5_5 = null;
                        continue;
                    }
                    duration = ((TimeScheduledEntry)entry).getNextTime() - System.currentTimeMillis();
                    if (duration < 0L) {
                        this.m_priorityQueue.pop();
                    }
                }
                if (duration < 0L) {
                    this.runEntry((TimeScheduledEntry)entry);
                    this.rescheduleEntry((TimeScheduledEntry)entry, false);
                    continue;
                }
                if (0L == duration) {
                    duration = 1L;
                }
            }
            try {
                entry = this;
                synchronized (entry) {
                    this.wait(duration);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized TimeScheduledEntry getNextEntry() {
        TimeScheduledEntry entry = (TimeScheduledEntry)this.m_priorityQueue.peek();
        while (!entry.isValid()) {
            this.m_priorityQueue.pop();
            if (this.m_priorityQueue.isEmpty()) {
                return null;
            }
            entry = (TimeScheduledEntry)this.m_priorityQueue.peek();
        }
        return entry;
    }
}

