/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.sockets;

import java.util.HashMap;
import org.apache.avalon.cornerstone.services.sockets.ServerSocketFactory;
import org.apache.avalon.cornerstone.services.sockets.SocketFactory;
import org.apache.avalon.cornerstone.services.sockets.SocketManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.Block;

public class DefaultSocketManager
extends AbstractLogEnabled
implements SocketManager,
Block,
Contextualizable,
Configurable,
Initializable {
    protected final HashMap m_serverSockets = new HashMap();
    protected final HashMap m_sockets = new HashMap();
    protected Context m_context;
    protected Configuration m_configuration;

    public void contextualize(Context context) {
        this.m_context = context;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_configuration = configuration;
    }

    public void initialize() throws Exception {
        Configuration[] serverSockets = this.m_configuration.getChild("server-sockets").getChildren("factory");
        int i = 0;
        while (i < serverSockets.length) {
            Configuration element = serverSockets[i];
            String name = element.getAttribute("name");
            String className = element.getAttribute("class");
            this.setupServerSocketFactory(name, className, element);
            ++i;
        }
        Configuration[] clientSockets = this.m_configuration.getChild("client-sockets").getChildren("factory");
        int i2 = 0;
        while (i2 < clientSockets.length) {
            Configuration element = clientSockets[i2];
            String name = element.getAttribute("name");
            String className = element.getAttribute("class");
            this.setupClientSocketFactory(name, className, element);
            ++i2;
        }
    }

    protected void setupServerSocketFactory(String name, String className, Configuration configuration) throws Exception {
        Component object = this.createFactory(name, className, configuration);
        if (!(object instanceof ServerSocketFactory)) {
            throw new ComponentException("Error creating factory " + name + " with class " + className + " as " + "it does not implement the correct " + "interface (ServerSocketFactory)");
        }
        this.m_serverSockets.put(name, object);
    }

    protected void setupClientSocketFactory(String name, String className, Configuration configuration) throws Exception {
        Component object = this.createFactory(name, className, configuration);
        if (!(object instanceof SocketFactory)) {
            throw new ComponentException("Error creating factory " + name + " with class " + className + " as " + "it does not implement the correct " + "interface (SocketFactory)");
        }
        this.m_sockets.put(name, object);
    }

    protected Component createFactory(String name, String className, Configuration configuration) throws Exception {
        Component factory = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            factory = (Component)classLoader.loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new ComponentException("Error creating factory with class " + className, (Throwable)e);
        }
        this.setupLogger(factory);
        if (factory instanceof Contextualizable) {
            ((Contextualizable)factory).contextualize(this.m_context);
        }
        if (factory instanceof Configurable) {
            ((Configurable)factory).configure(configuration);
        }
        if (factory instanceof Initializable) {
            ((Initializable)factory).initialize();
        }
        return factory;
    }

    public ServerSocketFactory getServerSocketFactory(String name) throws ComponentException {
        ServerSocketFactory factory = (ServerSocketFactory)this.m_serverSockets.get(name);
        if (factory != null) {
            return factory;
        }
        throw new ComponentException("Unable to locate server socket factory named " + name);
    }

    public SocketFactory getSocketFactory(String name) throws ComponentException {
        SocketFactory factory = (SocketFactory)this.m_sockets.get(name);
        if (factory != null) {
            return factory;
        }
        throw new ComponentException("Unable to locate client socket factory named " + name);
    }
}

