/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.threads;

import java.util.HashMap;
import org.apache.avalon.cornerstone.services.threads.ThreadManager;
import org.apache.avalon.excalibur.lang.ThreadContext;
import org.apache.avalon.excalibur.thread.ThreadPool;
import org.apache.avalon.excalibur.thread.impl.DefaultThreadPool;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.Block;

public class DefaultThreadManager
extends AbstractLogEnabled
implements Block,
ThreadManager,
Configurable {
    private HashMap m_threadPools = new HashMap();

    public void configure(Configuration configuration) throws ConfigurationException {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        Configuration[] groups = configuration.getChildren("thread-group");
        int i = 0;
        while (i < groups.length) {
            this.configureThreadPool(groups[i], threadContext);
            ++i;
        }
    }

    private void configureThreadPool(Configuration configuration, ThreadContext threadContext) throws ConfigurationException {
        String name = configuration.getChild("name").getValue();
        int priority = configuration.getChild("priority").getValueAsInteger(5);
        boolean isDaemon = configuration.getChild("is-daemon").getValueAsBoolean(false);
        int minThreads = configuration.getChild("min-threads").getValueAsInteger(5);
        int maxThreads = configuration.getChild("max-threads").getValueAsInteger(10);
        int minSpareThreads = configuration.getChild("min-spare-threads").getValueAsInteger(maxThreads - minThreads);
        try {
            DefaultThreadPool threadPool = new DefaultThreadPool(name, maxThreads, threadContext);
            threadPool.setDaemon(isDaemon);
            threadPool.enableLogging(this.getLogger());
            this.m_threadPools.put(name, threadPool);
        }
        catch (Exception e) {
            String message = "Error creating ThreadPool named " + name;
            throw new ConfigurationException(message, (Throwable)e);
        }
    }

    public ThreadPool getThreadPool(String name) throws IllegalArgumentException {
        ThreadPool threadPool = (ThreadPool)this.m_threadPools.get(name);
        if (threadPool == null) {
            String message = "Unable to locate ThreadPool named " + name;
            throw new IllegalArgumentException(message);
        }
        return threadPool;
    }

    public ThreadPool getDefaultThreadPool() {
        return this.getThreadPool("default");
    }
}

