/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.services.connection;

import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandlerFactory;
import org.apache.avalon.cornerstone.services.connection.ConnectionManager;
import org.apache.avalon.cornerstone.services.sockets.ServerSocketFactory;
import org.apache.avalon.cornerstone.services.sockets.SocketManager;
import org.apache.avalon.excalibur.thread.ThreadPool;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.Block;
import org.apache.avalon.phoenix.BlockContext;

public abstract class AbstractService
extends AbstractLogEnabled
implements Block,
Contextualizable,
Composable,
Configurable,
Initializable,
Disposable {
    protected ConnectionManager m_connectionManager;
    protected SocketManager m_socketManager;
    protected ConnectionHandlerFactory m_factory = this.createFactory();
    protected ThreadPool m_threadPool;
    protected String m_serverSocketType = "plain";
    protected int m_port;
    protected InetAddress m_bindTo;
    protected String m_connectionName;

    protected String getThreadPoolName() {
        return null;
    }

    protected abstract ConnectionHandlerFactory createFactory();

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.setupLogger(this.m_factory);
    }

    public void contextualize(Context context) throws ContextException {
        String name = this.getThreadPoolName();
        if (name != null) {
            BlockContext blockContext = (BlockContext)context;
            this.m_threadPool = blockContext.getThreadPool(name);
        }
        if (this.m_factory instanceof Contextualizable) {
            ((Contextualizable)this.m_factory).contextualize(context);
        }
    }

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_connectionManager = (ConnectionManager)componentManager.lookup("org.apache.avalon.cornerstone.services.connection.ConnectionManager");
        this.m_socketManager = (SocketManager)componentManager.lookup("org.apache.avalon.cornerstone.services.sockets.SocketManager");
        if (this.m_factory instanceof Composable) {
            ((Composable)this.m_factory).compose(componentManager);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (this.m_factory instanceof Configurable) {
            ((Configurable)this.m_factory).configure(configuration);
        }
    }

    public void initialize() throws Exception {
        if (this.m_factory instanceof Initializable) {
            ((Initializable)this.m_factory).initialize();
        }
        if (this.m_connectionName == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_serverSocketType);
            sb.append(':');
            sb.append(this.m_port);
            if (this.m_bindTo != null) {
                sb.append('/');
                sb.append(this.m_bindTo);
            }
            this.m_connectionName = sb.toString();
        }
        ServerSocketFactory factory = this.m_socketManager.getServerSocketFactory(this.m_serverSocketType);
        ServerSocket serverSocket = null;
        serverSocket = this.m_bindTo == null ? factory.createServerSocket(this.m_port) : factory.createServerSocket(this.m_port, 5, this.m_bindTo);
        if (this.m_threadPool == null) {
            this.m_connectionManager.connect(this.m_connectionName, serverSocket, this.m_factory);
        } else {
            this.m_connectionManager.connect(this.m_connectionName, serverSocket, this.m_factory, this.m_threadPool);
        }
    }

    public void dispose() {
        try {
            this.m_connectionManager.disconnect(this.m_connectionName);
        }
        catch (Exception e) {
            this.getLogger().warn("Error disconnecting", (Throwable)e);
        }
    }
}

