/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.services.scheduler.test;

import java.util.Calendar;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avalon.cornerstone.services.scheduler.CronTimeTrigger;

public final class CronTimeTriggerTestCase
extends TestCase {
    protected static final long MINUTE = 60000L;
    protected static final long HOUR = 3600000L;
    protected static final long DAY = 86400000L;
    protected static final long WEEK = 604800000L;

    public void testMinutes() {
        CronTimeTrigger trigger = new CronTimeTrigger(-1, -1, -1, -1, -1, true);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        long time = now.getTime().getTime();
        long next = trigger.getTimeAfter(time);
        int i = 0;
        while (i < 5) {
            long delta = next - time;
            Assert.assertEquals((String)"Time increments of 1 minute", (long)60000L, (long)delta);
            time = next;
            next = trigger.getTimeAfter(time);
            ++i;
        }
    }

    public void testHours() {
        CronTimeTrigger trigger = new CronTimeTrigger(51, -1, -1, -1, -1, true);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        now.set(12, 2);
        long time = now.getTime().getTime();
        long next = trigger.getTimeAfter(time);
        long delta = next - time;
        long expected = 2940000L;
        Assert.assertEquals((String)"Collect time at start", (long)2940000L, (long)delta);
        time = next;
        next = trigger.getTimeAfter(time);
        int i = 0;
        while (i < 5) {
            delta = next - time;
            Assert.assertEquals((String)"Time increments of 1 hour", (long)3600000L, (long)delta);
            time = next;
            next = trigger.getTimeAfter(time);
            ++i;
        }
    }

    public void testDays() {
        CronTimeTrigger trigger = new CronTimeTrigger(51, 5, -1, -1, -1, true);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        now.set(12, 2);
        now.set(11, 3);
        long time = now.getTime().getTime();
        long next = trigger.getTimeAfter(time);
        long delta = next - time;
        long expected = 10140000L;
        Assert.assertEquals((String)"Collect time at start", (long)10140000L, (long)delta);
        time = next;
        next = trigger.getTimeAfter(time);
        int i = 0;
        while (i < 5) {
            delta = next - time;
            Assert.assertEquals((String)"Time increments of 1 day", (long)86400000L, (long)delta);
            time = next;
            next = trigger.getTimeAfter(time);
            ++i;
        }
    }

    public void testMinutelessDays() {
        CronTimeTrigger trigger = new CronTimeTrigger(-1, 5, -1, -1, -1, true);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        now.set(12, 2);
        now.set(11, 3);
        long time = now.getTime().getTime();
        long next = trigger.getTimeAfter(time);
        long delta = next - time;
        long expected = 7080000L;
        Assert.assertEquals((String)"Collect time at start", (long)7080000L, (long)delta);
        time = next;
        next = trigger.getTimeAfter(time);
        int i = 0;
        while (i < 5) {
            delta = next - time;
            Assert.assertEquals((String)"Time increments of 1 day", (long)86400000L, (long)delta);
            time = next;
            next = trigger.getTimeAfter(time);
            ++i;
        }
    }

    public void testWeekly() {
        CronTimeTrigger trigger = new CronTimeTrigger(-1, 5, 2, -1, -1, true);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        now.set(12, 2);
        now.set(11, 3);
        now.set(7, 3);
        now.set(2, 0);
        long time = now.getTime().getTime();
        long next = trigger.getTimeAfter(time);
        long delta = next - time;
        long expected = 525480000L;
        Assert.assertEquals((String)"Collect time at start", (long)525480000L, (long)delta);
        time = next;
        next = trigger.getTimeAfter(time);
        int i = 0;
        while (i < 5) {
            delta = next - time;
            Assert.assertEquals((String)"Time increments of 1 hour", (long)604800000L, (long)delta);
            time = next;
            next = trigger.getTimeAfter(time);
            ++i;
        }
    }

    public void testWeekly2() {
        CronTimeTrigger trigger = new CronTimeTrigger(3, 5, 2, -1, -1, true);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        now.set(12, 2);
        now.set(11, 3);
        now.set(7, 3);
        now.set(2, 0);
        long time = now.getTime().getTime();
        long next = trigger.getTimeAfter(time);
        long delta = next - time;
        long expected = 525660000L;
        Assert.assertEquals((String)"Collect time at start", (long)525660000L, (long)delta);
        time = next;
        next = trigger.getTimeAfter(time);
        int i = 0;
        while (i < 5) {
            delta = next - time;
            Assert.assertEquals((String)"Time increments of 1 hour", (long)604800000L, (long)delta);
            time = next;
            next = trigger.getTimeAfter(time);
            ++i;
        }
    }

    public void testDayAMonth() {
        CronTimeTrigger trigger = new CronTimeTrigger(3, 5, 2, -1, -1, false);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        now.set(12, 2);
        now.set(11, 3);
        now.set(5, 1);
        long time = now.getTime().getTime();
        long next = trigger.getTimeAfter(time);
        long delta = next - time;
        long expected = 93660000L;
        Assert.assertEquals((String)"Collect time at start", (long)expected, (long)delta);
        int month = now.get(2);
        time = next;
        next = trigger.getTimeAfter(time);
        int i = 0;
        while (i < 5) {
            month = (month + 1) % 12;
            now.setTime(new Date(next));
            Assert.assertEquals((String)"Minute", (int)now.get(12), (int)3);
            Assert.assertEquals((String)"Hour of Day", (int)now.get(11), (int)5);
            Assert.assertEquals((String)"Day of month", (int)now.get(5), (int)2);
            Assert.assertEquals((String)"Month", (int)now.get(2), (int)month);
            time = next;
            next = trigger.getTimeAfter(time);
            ++i;
        }
    }

    public void testYearly() {
        CronTimeTrigger trigger = new CronTimeTrigger(-1, -1, -1, 4, -1, true);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        now.set(12, 2);
        now.set(11, 3);
        now.set(5, 1);
        now.set(2, 3);
        long time = now.getTime().getTime();
        long next = trigger.getTimeAfter(time);
        long delta = next - time;
        now.setTime(new Date(next));
        Assert.assertEquals((String)"Minute", (int)now.get(12), (int)0);
        Assert.assertEquals((String)"Hour of Day", (int)now.get(11), (int)0);
        Assert.assertEquals((String)"Day of month", (int)now.get(5), (int)1);
        Assert.assertEquals((String)"Month", (int)now.get(2), (int)4);
        time = next;
        next = trigger.getTimeAfter(time);
        int i = 0;
        while (i < 5) {
            now.setTime(new Date(next));
            Assert.assertEquals((String)"Minute", (int)now.get(12), (int)0);
            Assert.assertEquals((String)"Hour of Day", (int)now.get(11), (int)0);
            Assert.assertEquals((String)"Day of month", (int)now.get(5), (int)1);
            Assert.assertEquals((String)"Month", (int)now.get(2), (int)4);
            time = next;
            next = trigger.getTimeAfter(time);
            ++i;
        }
    }

    public void testOneYear() {
        CronTimeTrigger trigger = new CronTimeTrigger(-1, -1, -1, -1, 2020, true);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        now.set(12, 2);
        now.set(11, 3);
        now.set(5, 1);
        now.set(2, 3);
        now.set(1, 2000);
        long time = now.getTime().getTime();
        long next = trigger.getTimeAfter(time);
        long delta = next - time;
        now.setTime(new Date(next));
        Assert.assertEquals((String)"Minute", (int)now.get(12), (int)0);
        Assert.assertEquals((String)"Hour of Day", (int)now.get(11), (int)0);
        Assert.assertEquals((String)"Day of month", (int)now.get(5), (int)1);
        Assert.assertEquals((String)"Month", (int)now.get(2), (int)0);
        Assert.assertEquals((String)"year", (int)now.get(1), (int)2020);
        time = next;
        next = trigger.getTimeAfter(time);
        Assert.assertEquals((String)"year", (long)-1L, (long)next);
    }

    public void testRolledMonthDay() {
        CronTimeTrigger trigger = new CronTimeTrigger(-1, -1, 5, 2, -1, false);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        now.set(12, 0);
        now.set(11, 0);
        now.set(5, 29);
        now.set(2, 7);
        long time = now.getTime().getTime();
        long next = trigger.getTimeAfter(time);
        long delta = next - time;
        now.setTime(new Date(next));
        Assert.assertEquals((String)"Second", (int)now.get(13), (int)0);
        Assert.assertEquals((String)"Minute", (int)now.get(12), (int)0);
        Assert.assertEquals((String)"Hour of Day", (int)now.get(11), (int)0);
        Assert.assertEquals((String)"Day of month", (int)now.get(5), (int)5);
        Assert.assertEquals((String)"Month", (int)now.get(2), (int)2);
    }

    public void testMaxDayBoundaries() {
        CronTimeTrigger trigger = new CronTimeTrigger(-1, -1, 30, 1, -1, false);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        now.set(12, 0);
        now.set(11, 0);
        now.set(5, 0);
        now.set(2, 7);
        now.set(1, 2001);
        long time = now.getTime().getTime();
        long next = trigger.getTimeAfter(time);
        long delta = next - time;
        now.setTime(new Date(next));
        Assert.assertEquals((String)"Second", (int)now.get(13), (int)0);
        Assert.assertEquals((String)"Minute", (int)now.get(12), (int)0);
        Assert.assertEquals((String)"Hour of Day", (int)now.get(11), (int)0);
        Assert.assertEquals((String)"Month", (int)now.get(2), (int)1);
        Assert.assertEquals((String)"Day of month", (int)now.get(5), (int)28);
    }

    public CronTimeTriggerTestCase(String name) {
        super(name);
    }
}

