/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.core;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Message;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BEEPError
extends BEEPException {
    private static final String ERR_MALFORMED_XML_MSG = "Malformed XML";
    private static final String ERR_UNKNOWN_OPERATION_ELEMENT_MSG = "Unknown operation element";
    private static final String ERR_PCDATA_TOO_BIG_MSG = "Element's PCDATA exceeds the maximum size";
    private static final String FRAGMENT_ANGLE_SUFFIX = ">";
    private static final String FRAGMENT_CODE_PREFIX = "code='";
    private static final String FRAGMENT_ERROR_PREFIX = "<error ";
    private static final String FRAGMENT_ERROR_SUFFIX = "</error>";
    private static final String FRAGMENT_QUOTE_SLASH_ANGLE_SUFFIX = "' />";
    private static final String FRAGMENT_QUOTE_SUFFIX = "' ";
    private static final String FRAGMENT_XML_LANG_PREFIX = "xml:lang='";
    private static final String TAG_CODE = "code";
    private static final String TAG_ERROR = "error";
    private static final String TAG_XML_LANG = "xml:lang";
    private int code;
    private String xmlLang = null;
    public static final int CODE_SUCCESS = 200;
    public static final int CODE_SERVICE_NOT_AVAILABLE = 421;
    public static final int CODE_REQUESTED_ACTION_NOT_TAKEN = 450;
    public static final int CODE_REQUESTED_ACTION_ABORTED = 451;
    public static final int CODE_TEMPORARY_AUTHENTICATION_FAILURE = 454;
    public static final int CODE_GENERAL_SYNTAX_ERROR = 500;
    public static final int CODE_PARAMETER_ERROR = 501;
    public static final int CODE_PARAMETER_NOT_IMPLEMENTED = 504;
    public static final int CODE_AUTHENTICATION_REQUIRED = 530;
    public static final int CODE_AUTHENTICATION_INSUFFICIENT = 534;
    public static final int CODE_AUTHENTICATION_FAILURE = 535;
    public static final int CODE_ACTION_NOT_AUTHORIZED = 537;
    public static final int CODE_AUTHENTICATION_REQUIRES_ENCRYPTION = 538;
    public static final int CODE_REQUESTED_ACTION_NOT_TAKEN2 = 550;
    public static final int CODE_PARAMETER_INVALID = 553;
    public static final int CODE_TRANSACTION_FAILED = 554;

    public BEEPError(int n, String string, String string2) {
        super(string);
        this.xmlLang = string2;
        this.code = n;
    }

    public BEEPError(int n, String string) {
        super(string);
        this.code = n;
    }

    public BEEPError(int n) {
        super("");
        this.code = n;
    }

    public int getCode() {
        return this.code;
    }

    public String getXMLLang() {
        return this.xmlLang;
    }

    public String getDiagnostic() {
        return this.getMessage();
    }

    public String createErrorMessage() {
        return BEEPError.createErrorMessage(this.code, this.getMessage(), this.xmlLang);
    }

    public static String createErrorMessage(int n, String string) {
        return BEEPError.createErrorMessage(n, string, null);
    }

    public static String createErrorMessage(int n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(FRAGMENT_ERROR_PREFIX);
        stringBuffer.append(FRAGMENT_CODE_PREFIX);
        stringBuffer.append(n);
        if (string2 != null) {
            stringBuffer.append(FRAGMENT_QUOTE_SUFFIX);
            stringBuffer.append(FRAGMENT_XML_LANG_PREFIX);
            stringBuffer.append(string2);
        }
        if (string != null) {
            stringBuffer.append(FRAGMENT_QUOTE_SUFFIX);
            stringBuffer.append(FRAGMENT_ANGLE_SUFFIX);
            stringBuffer.append(string);
            stringBuffer.append(FRAGMENT_ERROR_SUFFIX);
        } else {
            stringBuffer.append(FRAGMENT_QUOTE_SLASH_ANGLE_SUFFIX);
        }
        return stringBuffer.toString();
    }

    protected static BEEPError convertMessageERRToException(Message message) throws BEEPException {
        Object object;
        if (message.getMessageType() != 3) {
            throw new IllegalArgumentException("messageType != ERR");
        }
        Document document = null;
        try {
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(message.getDataStream().getInputStream());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BEEPException("Invalid parser configuration");
        }
        catch (SAXException sAXException) {
            throw new BEEPException(ERR_MALFORMED_XML_MSG);
        }
        catch (IOException iOException) {
            throw new BEEPException(ERR_MALFORMED_XML_MSG);
        }
        if (document == null) {
            throw new BEEPException(ERR_MALFORMED_XML_MSG);
        }
        object = document.getDocumentElement();
        if (object == null) {
            throw new BEEPException(ERR_MALFORMED_XML_MSG);
        }
        String string = object.getTagName();
        if (string == null) {
            throw new BEEPException(ERR_MALFORMED_XML_MSG);
        }
        if (!string.equals(TAG_ERROR)) {
            throw new BEEPException(ERR_UNKNOWN_OPERATION_ELEMENT_MSG);
        }
        String string2 = object.getAttribute(TAG_CODE);
        if (string2 == null) {
            throw new BEEPException(ERR_MALFORMED_XML_MSG);
        }
        String string3 = object.getAttribute(TAG_XML_LANG);
        Node node = object.getFirstChild();
        String string4 = null;
        if (node != null) {
            string4 = node.getNodeValue();
        }
        return new BEEPError(Integer.parseInt(string2), string4, string3);
    }
}

