/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.core;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.beepcore.beep.core.BEEPError;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.DataListener;
import org.beepcore.beep.core.DataStream;
import org.beepcore.beep.core.Frame;
import org.beepcore.beep.core.FrameDataStream;
import org.beepcore.beep.core.FrameListener;
import org.beepcore.beep.core.Message;
import org.beepcore.beep.core.MessageListener;
import org.beepcore.beep.core.MessageMSG;
import org.beepcore.beep.core.MessageStatus;
import org.beepcore.beep.core.ReplyListener;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.util.Log;

public class Channel {
    static final int STATE_UNINITIALISED = 1;
    static final int STATE_OK = 2;
    static final int STATE_CLOSING = 3;
    static final int STATE_CLOSED = 4;
    static final int STATE_ERROR = 5;
    private static final String ERR_CHANNEL_MESSAGE_NUMBER_PREFIX = "Incorrect message number: was ";
    private static final String ERR_CHANNEL_MIDDLE = "; expecting ";
    private static final String ERR_CHANNEL_SEQUENCE_NUMBER_PREFIX = "Incorrect sequence number: was ";
    private static final String ERR_CHANNEL_ERROR_STATE = "Channel in currently experiencing technical difficulties.";
    private static final String ERR_CHANNEL_UNINITIALISED_STATE = "Channel is uninitialised.";
    private static final String ERR_CHANNEL_UNKNOWN_STATE = "Channel is in an unknown state.";
    private static final String ERR_CHANNEL_INCONSISTENT_FRAME_TYPE_PREFIX = "Incorrect message type: was ";
    private static final String ERR_REPLY_RECEIVED_FOR_NO_MESSAGE = "Reply received for a message never sent.";
    private static final int MAX_PAYLOAD_SIZE = 4096;
    static final int DEFAULT_WINDOW_SIZE = 4096;
    private String profile;
    private String encoding;
    private String number;
    private String startData;
    private DataListener listener;
    private int lastMessageSent;
    private long sentSequence;
    private long recvSequence;
    private List sentMSGQueue;
    private LinkedList recvMSGQueue;
    private int frameSize;
    private Session session;
    private LinkedList recvReplyQueue;
    private int state = 1;
    private BEEPError errMessage;
    private Frame previousFrame;
    private int peerWindowSize;
    private int recvWindowSize;
    private int recvWindowUsed;
    private long prevAckno;
    private int prevWindowUsed;
    private int waitTimeForPeer;
    private int msgsPending;
    private boolean notifyOnFirstFrame;
    private Object applicationData = null;
    private MessageMSG currentMSG;

    protected Channel(String string, String string2, DataListener dataListener, Session session) {
        this.profile = string;
        this.encoding = "none";
        this.number = string2;
        this.listener = dataListener;
        this.session = session;
        this.frameSize = 4096;
        this.sentSequence = 0L;
        this.recvSequence = 0L;
        this.lastMessageSent = 1;
        this.sentMSGQueue = Collections.synchronizedList(new LinkedList());
        this.recvMSGQueue = new LinkedList();
        this.recvReplyQueue = new LinkedList();
        this.state = 1;
        this.recvWindowUsed = 0;
        this.recvWindowSize = 4096;
        this.prevAckno = 0L;
        this.prevWindowUsed = 0;
        this.msgsPending = 0;
        this.peerWindowSize = 4096;
        this.waitTimeForPeer = 0;
        this.notifyOnFirstFrame = false;
    }

    Channel(Session session, String string, ReplyListener replyListener) {
        this(null, string, null, session);
        Message message = new Message(this, 0, null, 1);
        this.sentMSGQueue.add(new MessageStatus(message, replyListener));
        this.state = 2;
    }

    public void close() throws BEEPException {
        this.session.closeChannel(this, 200, null);
    }

    public Object getAppData() {
        return this.applicationData;
    }

    public void setAppData(Object object) {
        this.applicationData = object;
    }

    public synchronized int getBufferSize() {
        return this.recvWindowSize;
    }

    public synchronized int getBufferUsed() {
        return this.recvWindowUsed;
    }

    String getEncoding() {
        return this.encoding;
    }

    void setEncoding(String string) {
        this.encoding = string;
    }

    public int getNumber() {
        return Integer.parseInt(this.number);
    }

    public void setReceiveBufferSize(int n) throws BEEPException {
        Channel channel = this;
        synchronized (channel) {
            if (this.state != 2 && this.state != 1) {
                throw new BEEPException("Channel in a bad state.");
            }
            if (n < this.recvWindowUsed) {
                throw new BEEPException("Size must be less than what is currently in use.");
            }
            this.recvWindowSize = n;
            Log.logEntry(8, "Buffer size for channel " + this.number + " set to " + this.recvWindowSize);
            if (this.session.updateMyReceiveBufferSize(this, this.prevAckno, this.recvSequence, this.prevWindowUsed, this.recvWindowUsed, this.recvWindowSize)) {
                this.prevAckno = this.recvSequence;
                this.prevWindowUsed = this.recvWindowUsed;
            }
        }
    }

    public void setNotifyMessageListenerOnFirstFrame(boolean bl) {
        this.notifyOnFirstFrame = bl;
    }

    public boolean getNotifyMessageListenerOnFirstFrame() {
        return this.notifyOnFirstFrame;
    }

    public void setDataListener(DataListener dataListener) {
        this.listener = dataListener;
    }

    public DataListener getDataListener() {
        return this.listener;
    }

    public Session getSession() {
        return this.session;
    }

    public MessageStatus sendANS(DataStream dataStream) throws BEEPException {
        return this.currentMSG.sendANS(dataStream);
    }

    public MessageStatus sendMSG(DataStream dataStream, ReplyListener replyListener) throws BEEPException {
        MessageStatus messageStatus;
        if (this.state != 2) {
            switch (this.state) {
                case 5: {
                    throw new BEEPException(ERR_CHANNEL_ERROR_STATE);
                }
                case 1: {
                    throw new BEEPException(ERR_CHANNEL_UNINITIALISED_STATE);
                }
            }
            throw new BEEPException(ERR_CHANNEL_UNKNOWN_STATE);
        }
        Channel channel = this;
        synchronized (channel) {
            messageStatus = new MessageStatus(new Message(this, this.lastMessageSent, dataStream, 1), replyListener);
            ++this.lastMessageSent;
        }
        List list = this.sentMSGQueue;
        synchronized (list) {
            this.sentMSGQueue.add(messageStatus);
        }
        this.sendToPeer(messageStatus);
        return messageStatus;
    }

    MessageStatus sendMSG(DataStream dataStream, FrameListener frameListener) throws BEEPException {
        MessageStatus messageStatus;
        if (this.state != 2) {
            switch (this.state) {
                case 5: {
                    throw new BEEPException(ERR_CHANNEL_ERROR_STATE);
                }
                case 1: {
                    throw new BEEPException(ERR_CHANNEL_UNINITIALISED_STATE);
                }
            }
            throw new BEEPException(ERR_CHANNEL_UNKNOWN_STATE);
        }
        Channel channel = this;
        synchronized (channel) {
            messageStatus = new MessageStatus(new Message(this, this.lastMessageSent, dataStream, 1), frameListener);
            ++this.lastMessageSent;
        }
        List list = this.sentMSGQueue;
        synchronized (list) {
            this.sentMSGQueue.add(messageStatus);
        }
        this.sendToPeer(messageStatus);
        return messageStatus;
    }

    public MessageStatus sendNUL() throws BEEPException {
        MessageMSG messageMSG = this.currentMSG;
        this.currentMSG = null;
        return ((Message)messageMSG).sendNUL();
    }

    public MessageStatus sendRPY(DataStream dataStream) throws BEEPException {
        MessageMSG messageMSG = this.currentMSG;
        this.currentMSG = null;
        return ((Message)messageMSG).sendRPY(dataStream);
    }

    public MessageStatus sendERR(BEEPError bEEPError) throws BEEPException {
        MessageMSG messageMSG = this.currentMSG;
        this.currentMSG = null;
        return ((Message)messageMSG).sendERR(bEEPError);
    }

    public MessageStatus sendERR(int n, String string) throws BEEPException {
        MessageMSG messageMSG = this.currentMSG;
        this.currentMSG = null;
        return ((Message)messageMSG).sendERR(n, string);
    }

    public MessageStatus sendERR(int n, String string, String string2) throws BEEPException {
        MessageMSG messageMSG = this.currentMSG;
        this.currentMSG = null;
        return ((Message)messageMSG).sendERR(n, string, string2);
    }

    String getNumberAsString() {
        return this.number;
    }

    int getState() {
        return this.state;
    }

    private void receiveFrame(Frame frame) throws BEEPException {
        Object object;
        MessageStatus messageStatus;
        Object object2;
        if (frame.getMessageType() == 1) {
            MessageMSG messageMSG = null;
            LinkedList linkedList = this.recvMSGQueue;
            synchronized (linkedList) {
                if (this.recvMSGQueue.size() != 0 && (messageMSG = (MessageMSG)this.recvMSGQueue.getLast()).getMsgno() != frame.getMsgno()) {
                    messageMSG = null;
                }
                if (messageMSG == null) {
                    messageMSG = new MessageMSG(this, frame.getMsgno(), new FrameDataStream(true));
                    this.recvMSGQueue.addLast(messageMSG);
                }
            }
            ((FrameDataStream)messageMSG.getDataStream()).add(frame);
            LinkedList linkedList2 = this.recvMSGQueue;
            synchronized (linkedList2) {
                if (messageMSG != this.recvMSGQueue.getFirst()) {
                    return;
                }
                if (frame.isLast()) {
                    this.recvMSGQueue.remove(messageMSG);
                }
            }
            MessageMSG messageMSG2 = messageMSG;
            synchronized (messageMSG2) {
                if (messageMSG.isNotified() || !this.notifyOnFirstFrame && this.recvSequence - this.prevAckno != (long)(this.recvWindowSize - this.prevWindowUsed) && !frame.isLast()) {
                    return;
                }
                messageMSG.setNotified();
            }
            this.currentMSG = messageMSG;
            ((MessageListener)this.listener).receiveMSG(messageMSG);
            return;
        }
        Message message = null;
        List list = this.sentMSGQueue;
        synchronized (list) {
            if (this.sentMSGQueue.size() == 0) {
                // empty if block
            }
            if (((Message)(object2 = (messageStatus = (MessageStatus)this.sentMSGQueue.get(0)).getMessage())).getMsgno() != frame.getMsgno()) {
                // empty if block
            }
            if (frame.isLast() && frame.getMessageType() != 4) {
                this.sentMSGQueue.remove(0);
            }
        }
        object2 = messageStatus.getReplyListener();
        if (object2 == null) {
            // empty if block
        }
        if (frame.getMessageType() == 5) {
            LinkedList linkedList = this.recvReplyQueue;
            synchronized (linkedList) {
                if (this.recvReplyQueue.size() != 0) {
                    Log.logEntry(7, "Received NUL before last ANS");
                    this.session.terminate("Received NUL before last ANS");
                }
            }
            message = new Message(this, frame.getMsgno(), null, 5);
            messageStatus.setMessageStatus(3);
            Log.logEntry(8, "Notifying reply listener =>" + object2 + "for NUL message");
            object2.receiveNUL(message);
            return;
        }
        if (frame.getMessageType() == 4) {
            object = this.recvReplyQueue;
            synchronized (object) {
                Iterator iterator = this.recvReplyQueue.iterator();
                message = null;
                while (iterator.hasNext()) {
                    Message message2 = (Message)iterator.next();
                    if (message2.getAnsno() != frame.getAnsno()) continue;
                    message = message2;
                    break;
                }
                if (message == null) {
                    message = new Message(this, frame.getMsgno(), frame.getAnsno(), new FrameDataStream(true));
                    if (!frame.isLast()) {
                        this.recvReplyQueue.add(message);
                    }
                } else if (frame.isLast()) {
                    iterator.remove();
                }
            }
        }
        object = this.recvReplyQueue;
        synchronized (object) {
            if (this.recvReplyQueue.size() == 0) {
                message = new Message(this, frame.getMsgno(), new FrameDataStream(true), frame.getMessageType());
                if (!frame.isLast()) {
                    this.recvReplyQueue.add(message);
                }
            } else {
                message = (Message)this.recvReplyQueue.getFirst();
                if (frame.isLast()) {
                    this.recvReplyQueue.removeFirst();
                }
            }
            if (frame.isLast()) {
                if (frame.getMessageType() == 3) {
                    messageStatus.setMessageStatus(4);
                } else {
                    messageStatus.setMessageStatus(3);
                }
            }
        }
        ((FrameDataStream)message.getDataStream()).add(frame);
        object = message;
        synchronized (object) {
            if (message.isNotified() || !this.notifyOnFirstFrame && this.recvSequence - this.prevAckno != (long)(this.recvWindowSize - this.prevWindowUsed) && !frame.isLast()) {
                Log.logEntry(8, "recvWindowUsed = " + this.recvWindowUsed + " recvWindowSize = " + this.recvWindowSize + "\t\r\nNot notifying frame listener.");
                return;
            }
            message.setNotified();
        }
        Log.logEntry(8, "Notifying reply listener.=>" + object2);
        if (message.messageType == 2) {
            object2.receiveRPY(message);
        } else if (message.messageType == 3) {
            object2.receiveERR(message);
        } else if (message.messageType == 4) {
            object2.receiveANS(message);
        }
    }

    /*
     * Unable to fully structure code
     */
    void postFrame(Frame var1_1) throws BEEPException {
        Log.logEntry(8, "Channel::postFrame");
        var2_2 = false;
        var3_3 = false;
        var4_4 = null;
        var5_5 = var1_1.getMsgno();
        var6_6 = null;
        var7_7 = null;
        if (this.state != 2) {
            throw new BEEPException("State is " + this.state);
        }
        var8_8 = this;
        synchronized (var8_8) {
            if (var1_1.getMessageType() == 1) {
                if (this.previousFrame != null) {
                    if (var1_1.getMsgno() != this.previousFrame.getMsgno()) {
                        throw new BEEPException("Incorrect message number: was " + var1_1.getMsgno() + "; expecting " + this.previousFrame.getMsgno());
                    }
                } else {
                    var9_9 = this.recvMSGQueue;
                    synchronized (var9_9) {
                        var10_14 = this.recvMSGQueue.listIterator(this.recvMSGQueue.size());
                        while (var10_14.hasPrevious()) {
                            if (((Message)var10_14.previous()).getMsgno() != var1_1.getMsgno()) continue;
                            throw new BEEPException("Received a frame with a duplicate msgno (" + var1_1.getMsgno() + ")");
                        }
                    }
                }
            } else {
                var10_14 = this.sentMSGQueue;
                synchronized (var10_14) {
                    if (this.sentMSGQueue.size() == 0) {
                        throw new BEEPException("Received unsolicited reply");
                    }
                    var11_16 = (MessageStatus)this.sentMSGQueue.get(0);
                    var9_10 = var11_16.getMessage().getMsgno();
                }
                if (var1_1.getMsgno() != var9_10) {
                    throw new BEEPException("Incorrect message number: was " + var1_1.getMsgno() + "; expecting " + var9_10);
                }
            }
            if (var1_1.getSeqno() != this.recvSequence) {
                throw new BEEPException("Incorrect sequence number: was " + var1_1.getSeqno() + "; expecting " + this.recvSequence);
            }
            if (this.previousFrame != null && this.previousFrame.getMessageType() != var1_1.getMessageType()) {
                throw new BEEPException("Incorrect message type: was " + var1_1.getMessageTypeString() + "; expecting " + this.previousFrame.getMessageTypeString());
            }
        }
        this.recvSequence += (long)var1_1.getSize();
        this.recvWindowUsed += var1_1.getSize();
        if (this.recvWindowUsed > this.recvWindowSize) {
            throw new BEEPException("Channel window overflow");
        }
        if (this.listener instanceof FrameListener) {
            var7_7 = (FrameListener)this.listener;
        }
        if (var1_1.getMessageType() != 1) {
            var10_14 = this.sentMSGQueue;
            synchronized (var10_14) {
                if (this.sentMSGQueue.size() == 0) {
                    throw new BEEPException("Received unsolicited reply");
                }
                var9_11 = (MessageStatus)this.sentMSGQueue.get(0);
                if (var9_11.getMessage().getMsgno() != var1_1.getMsgno()) {
                    throw new BEEPException("Received reply out of order");
                }
                var11_16 = var9_11.getFrameListener();
                if (var11_16 != null) {
                    var7_7 = var11_16;
                    if (var1_1.isLast() && var1_1.getMessageType() != 4) {
                        this.sentMSGQueue.remove(0);
                    }
                }
            }
        }
        if (var7_7 != null) {
            try {
                var7_7.receiveFrame(var1_1);
                this.recvWindowUsed -= var1_1.getSize();
                if (!this.session.updateMyReceiveBufferSize(this, this.prevAckno, this.recvSequence, this.prevWindowUsed, this.recvWindowUsed, this.recvWindowSize)) ** GOTO lbl86
                this.prevAckno = this.recvSequence;
                this.prevWindowUsed = this.recvWindowUsed;
            }
            catch (BEEPException var9_12) {
                throw new BEEPException(var9_12.getMessage());
            }
        } else {
            try {
                this.receiveFrame(var1_1);
            }
            catch (BEEPException var9_13) {
                throw new BEEPException(var9_13.getMessage());
            }
        }
lbl86:
        // 3 sources

        if (var1_1.isLast()) {
            Log.logEntry(8, "Got the last frame");
        }
        this.previousFrame = var1_1.isLast() != false ? null : var1_1;
    }

    MessageStatus sendMessage(Message message) throws BEEPException {
        if (this.state != 2) {
            switch (this.state) {
                case 5: {
                    throw new BEEPException(ERR_CHANNEL_ERROR_STATE);
                }
                case 1: {
                    throw new BEEPException(ERR_CHANNEL_UNINITIALISED_STATE);
                }
            }
            throw new BEEPException(ERR_CHANNEL_UNKNOWN_STATE);
        }
        MessageStatus messageStatus = new MessageStatus(message);
        this.sendToPeer(messageStatus);
        return messageStatus;
    }

    synchronized void sendToPeer(MessageStatus messageStatus) throws BEEPException {
        Channel channel;
        Message message = messageStatus.getMessage();
        Frame frame = null;
        int n = 0;
        int n2 = this.session.getMaxFrameSize();
        byte[] byArray = new byte[n2];
        DataStream dataStream = message.getDataStream();
        if (dataStream == null || dataStream.availableHeadersAndData() == 0 && dataStream.isComplete()) {
            Log.logEntry(7, "Sending NUL or size 0 frame");
            frame = new Frame(message.getMessageType(), message.getChannel(), message.getMsgno(), true, this.sentSequence, 0, message.getAnsno());
            try {
                this.session.sendFrame(frame);
            }
            catch (BEEPException bEEPException) {
                Log.logEntry(3, bEEPException);
                messageStatus.setMessageStatus(1);
                throw bEEPException;
            }
            messageStatus.setMessageStatus(2);
            return;
        }
        n = dataStream.availableHeadersAndData();
        Channel channel2 = this;
        synchronized (channel2) {
            ++this.msgsPending;
        }
        boolean bl = false;
        while (!bl) {
            try {
                channel = this;
                synchronized (channel) {
                    if (this.peerWindowSize == 0) {
                        this.wait(this.waitTimeForPeer);
                        if (this.peerWindowSize == 0) {
                            throw new BEEPException("Time expired waiting for peer.");
                        }
                    }
                    int n3 = 0;
                    n3 = n2;
                    if (n3 > this.peerWindowSize) {
                        n3 = this.peerWindowSize;
                    }
                    int n4 = dataStream.readHeadersAndData(byArray, 0, n3);
                    if (dataStream.available() == 0 && dataStream.isComplete()) {
                        bl = true;
                    } else if (n4 == -1) {
                        bl = true;
                        byArray = new byte[]{};
                        n4 = 0;
                    }
                    frame = new Frame(message.getMessageType(), message.getChannel(), message.getMsgno(), bl, this.sentSequence, message.getAnsno(), new Frame.BufferSegment(byArray, 0, n4));
                    this.sentSequence += (long)n4;
                    this.peerWindowSize -= n4;
                }
                if (bl) {
                    Log.logEntry(8, "Channel.sendToPeer sending last frame on channel " + this.number);
                } else {
                    Log.logEntry(8, "Channel.sendToPeer sending a frame on channel " + this.number);
                }
            }
            catch (Exception exception) {
                Log.logEntry(3, exception);
                messageStatus.setMessageStatus(1);
                throw new BEEPException(exception.getMessage());
            }
            try {
                this.session.sendFrame(frame);
            }
            catch (BEEPException bEEPException) {
                Log.logEntry(3, bEEPException);
                messageStatus.setMessageStatus(1);
                Channel channel3 = this;
                synchronized (channel3) {
                    --this.msgsPending;
                    if (this.msgsPending == 0) {
                        this.notify();
                    }
                }
                return;
            }
        }
        messageStatus.setMessageStatus(2);
        channel = this;
        synchronized (channel) {
            --this.msgsPending;
            if (this.msgsPending == 0) {
                this.notify();
            }
        }
    }

    void setFrameSize(int n) {
        this.frameSize = n;
    }

    synchronized void setState(int n) {
        Log.logEntry(8, "CH" + this.number + " state=" + n);
        this.state = n;
    }

    void setProfile(String string) {
        this.profile = string;
    }

    public String getProfile() {
        return this.profile;
    }

    BEEPError getErrorMessage() {
        return this.errMessage;
    }

    void setErrorMessage(BEEPError bEEPError) {
        this.errMessage = bEEPError;
    }

    synchronized void updatePeerReceiveBufferSize(long l, int n) {
        int n2 = this.peerWindowSize;
        Log.logEntry(7, "Channel.updatePeerReceiveBufferSize: size = " + n + " lastSeq = " + l + " sentSequence = " + this.sentSequence + " peerWindowSize = " + this.peerWindowSize);
        this.peerWindowSize = n - (int)(this.sentSequence - l);
        Log.logEntry(7, "Channel.updatePeerReceiveBufferSize: New window size = " + this.peerWindowSize);
        if (n2 == 0 && this.peerWindowSize > 0) {
            this.notify();
        }
    }

    synchronized void freeReceiveBufferBytes(int n) {
        try {
            Log.logEntry(8, "Freed up " + n + " bytes on channel " + this.number);
            this.recvWindowUsed -= n;
            Log.logEntry(8, "recvWindowUsed = " + this.recvWindowUsed);
            if (this.session.updateMyReceiveBufferSize(this, this.prevAckno, this.recvSequence, this.prevWindowUsed, this.recvWindowUsed, this.recvWindowSize)) {
                this.prevAckno = this.recvSequence;
                this.prevWindowUsed = this.recvWindowUsed;
            }
        }
        catch (BEEPException bEEPException) {
            Log.logEntry(1, bEEPException);
        }
    }

    synchronized int getAvailableWindow() {
        return this.recvWindowSize - this.recvWindowUsed;
    }

    void setStartData(String string) {
        this.startData = string;
    }

    public String getStartData() {
        return this.startData;
    }
}

