/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.beepcore.beep.core.BEEPException;

public abstract class DataStream {
    static final String CONTENT_TYPE = "Content-Type";
    static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    private static final String COLON_SPACE = ": ";
    private static final String HEADER_SUFFIX = "\r\n";
    private static final int LEN_PADDING = ": ".length() + "\r\n".length();
    private static final int DEFAULT_HEADER_TABLE_SIZE = 3;
    private int lenHeaders = 0;
    private int bytesRead = 0;
    private int headersBytesRead = 0;
    private byte[] headersBytes;
    private boolean headersCached = true;
    private boolean headersRead = false;
    private Hashtable mimeHeadersTable = new Hashtable(3);
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String DEFAULT_CONTENT_TRANSFER_ENCODING = "binary";
    public static final String BEEP_XML_CONTENT_TYPE = "application/beep+xml";
    private final int MAX_BUFFER_SIZE = 128;
    private InputStream stream = null;

    protected DataStream() {
        this.mimeHeadersTable.put(CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
        this.mimeHeadersTable.put(CONTENT_TRANSFER_ENCODING, DEFAULT_CONTENT_TRANSFER_ENCODING);
        this.lenHeaders = HEADER_SUFFIX.length();
        this.headersCached = false;
    }

    protected DataStream(String string) {
        this(string, DEFAULT_CONTENT_TRANSFER_ENCODING);
    }

    protected DataStream(String string, String string2) {
        this.mimeHeadersTable.put(CONTENT_TYPE, string);
        this.mimeHeadersTable.put(CONTENT_TRANSFER_ENCODING, string2);
        this.lenHeaders = HEADER_SUFFIX.length();
        if (!string.equals(DEFAULT_CONTENT_TYPE)) {
            this.lenHeaders += string.length() + CONTENT_TYPE.length() + LEN_PADDING;
        }
        if (!string2.equals(DEFAULT_CONTENT_TRANSFER_ENCODING)) {
            this.lenHeaders += string2.length() + CONTENT_TRANSFER_ENCODING.length() + LEN_PADDING;
        }
        this.headersCached = false;
    }

    public void setContentType(String string) {
        if (this.mimeHeadersTable.containsKey(CONTENT_TYPE)) {
            this.removeHeader(CONTENT_TYPE);
        }
        this.mimeHeadersTable.put(CONTENT_TYPE, string);
        if (!string.equals(DEFAULT_CONTENT_TYPE)) {
            this.lenHeaders += CONTENT_TYPE.length() + string.length() + LEN_PADDING;
        }
        this.headersCached = false;
    }

    public String getContentType() throws BEEPException {
        return (String)this.mimeHeadersTable.get(CONTENT_TYPE);
    }

    public void setTransferEncoding(String string) {
        if (this.mimeHeadersTable.containsKey(CONTENT_TRANSFER_ENCODING)) {
            this.removeHeader(CONTENT_TRANSFER_ENCODING);
        }
        this.mimeHeadersTable.put(CONTENT_TRANSFER_ENCODING, string);
        if (!string.equals(DEFAULT_CONTENT_TRANSFER_ENCODING)) {
            this.lenHeaders += CONTENT_TRANSFER_ENCODING.length() + string.length() + LEN_PADDING;
        }
        this.headersCached = false;
    }

    public String getTransferEncoding() throws BEEPException {
        return (String)this.mimeHeadersTable.get(CONTENT_TRANSFER_ENCODING);
    }

    public void setHeader(String string, String string2) {
        if (this.mimeHeadersTable.containsKey(string)) {
            this.removeHeader(string);
        }
        this.mimeHeadersTable.put(string, string2);
        if (!(string.equals(CONTENT_TYPE) && string2.equals(DEFAULT_CONTENT_TYPE) || string.equals(CONTENT_TRANSFER_ENCODING) && string2.equals(DEFAULT_CONTENT_TRANSFER_ENCODING))) {
            this.lenHeaders += string.length() + string2.length() + LEN_PADDING;
        }
        this.headersCached = false;
    }

    public String getHeaderValue(String string) throws BEEPException {
        return (String)this.mimeHeadersTable.get(string);
    }

    public Enumeration getHeaderNames() throws BEEPException {
        return this.mimeHeadersTable.keys();
    }

    public boolean removeHeader(String string) {
        String string2 = (String)this.mimeHeadersTable.get(string);
        if (string2 != null && this.mimeHeadersTable.remove(string) != null) {
            if (!(string.equals(CONTENT_TYPE) && string2.equals(DEFAULT_CONTENT_TYPE) || string.equals(CONTENT_TRANSFER_ENCODING) && string2.equals(DEFAULT_CONTENT_TRANSFER_ENCODING))) {
                this.lenHeaders -= string.length() + string2.length() + LEN_PADDING;
            }
            this.headersCached = false;
            return true;
        }
        return false;
    }

    abstract int available() throws BEEPException;

    abstract int read() throws BEEPException;

    abstract int read(byte[] var1) throws BEEPException;

    abstract int read(byte[] var1, int var2, int var3) throws BEEPException;

    abstract long skip(long var1) throws BEEPException;

    abstract void close() throws BEEPException;

    protected int availableHeadersAndData() throws BEEPException {
        return this.lenHeaders + this.available() - this.headersBytesRead;
    }

    protected int readHeadersAndData(byte[] byArray, int n, int n2) throws BEEPException {
        int n3 = 0;
        int n4 = 0;
        if (!this.headersRead) {
            n3 = this.readHeaders(byArray, n, n2);
            if (this.headersBytesRead == this.lenHeaders) {
                this.headersRead = true;
            } else {
                return n3;
            }
        }
        if (n3 < n2 && (n4 = this.read(byArray, n + n3, n2 - n3)) == -1) {
            return -1;
        }
        return n4 + n3;
    }

    private int readHeaders(byte[] byArray, int n, int n2) {
        if (!this.headersCached) {
            this.headersBytes = new byte[this.lenHeaders];
            int n3 = 0;
            Enumeration enumeration = this.mimeHeadersTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.mimeHeadersTable.get(string);
                if (string.equals(CONTENT_TYPE) && string2.equals(DEFAULT_CONTENT_TYPE) || string.equals(CONTENT_TRANSFER_ENCODING) && string2.equals(DEFAULT_CONTENT_TRANSFER_ENCODING)) continue;
                System.arraycopy(string.getBytes(), 0, this.headersBytes, n3, string.length());
                System.arraycopy(COLON_SPACE.getBytes(), 0, this.headersBytes, n3 += string.length(), COLON_SPACE.length());
                System.arraycopy(string2.getBytes(), 0, this.headersBytes, n3 += COLON_SPACE.length(), string2.length());
                System.arraycopy(HEADER_SUFFIX.getBytes(), 0, this.headersBytes, n3 += string2.length(), HEADER_SUFFIX.length());
                n3 += HEADER_SUFFIX.length();
            }
            System.arraycopy(HEADER_SUFFIX.getBytes(), 0, this.headersBytes, n3, HEADER_SUFFIX.length());
            n3 += HEADER_SUFFIX.length();
            this.headersCached = true;
        }
        n2 = Math.min(n2, this.headersBytes.length - this.headersBytesRead);
        System.arraycopy(this.headersBytes, this.headersBytesRead, byArray, n, n2);
        this.headersBytesRead += n2;
        this.bytesRead += n2;
        return n2;
    }

    public abstract boolean isComplete();

    public InputStream getInputStream() {
        if (this.stream == null) {
            this.stream = new BufferedInputStream(new InnerInputStream(), 128);
        }
        return this.stream;
    }

    private class InnerInputStream
    extends InputStream {
        private InnerInputStream() {
        }

        public int available() throws IOException {
            try {
                return DataStream.this.available();
            }
            catch (BEEPException bEEPException) {
                throw new IOException(bEEPException.getMessage());
            }
        }

        public int read() throws IOException {
            try {
                return DataStream.this.read();
            }
            catch (BEEPException bEEPException) {
                throw new IOException(bEEPException.getMessage());
            }
        }

        public int read(byte[] byArray) throws IOException {
            try {
                return DataStream.this.read(byArray);
            }
            catch (BEEPException bEEPException) {
                throw new IOException(bEEPException.getMessage());
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                return DataStream.this.read(byArray, n, n2);
            }
            catch (BEEPException bEEPException) {
                throw new IOException(bEEPException.getMessage());
            }
        }

        public void close() throws IOException {
            try {
                DataStream.this.close();
            }
            catch (BEEPException bEEPException) {
                throw new IOException(bEEPException.getMessage());
            }
        }

        public long skip(long l) throws IOException {
            try {
                return DataStream.this.skip(l);
            }
            catch (BEEPException bEEPException) {
                throw new IOException(bEEPException.getMessage());
            }
        }
    }
}

