/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.core;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.util.Log;

public class Frame {
    public static final String TRAILER = "END\r\n";
    public static final int MAX_HEADER_SIZE = 62;
    public static final int MAX_ANS_NUMBER = Integer.MAX_VALUE;
    public static final int MAX_CHANNEL_NUMBER = Integer.MAX_VALUE;
    public static final int MAX_MESSAGE_NUMBER = Integer.MAX_VALUE;
    public static final long MAX_SEQUENCE_NUMBER = 0xFFFFFFFFL;
    public static final int MAX_SIZE = Integer.MAX_VALUE;
    private static final String CRLF = "\r\n";
    private int messageType;
    private Channel channel;
    private int msgno;
    private int ansno;
    private long seqno;
    private int size;
    private boolean last;
    private BufferSegment payload;

    Frame(int n, Channel channel, int n2, boolean bl, long l, int n3, BufferSegment bufferSegment) {
        this.messageType = n;
        this.channel = channel;
        this.msgno = n2;
        this.seqno = l;
        this.ansno = n3;
        this.payload = bufferSegment;
        this.size = bufferSegment.length - bufferSegment.offset;
        this.last = bl;
    }

    Frame(int n, Channel channel, int n2, boolean bl, long l, int n3, int n4) {
        this.messageType = n;
        this.channel = channel;
        this.msgno = n2;
        this.last = bl;
        this.seqno = l;
        this.size = n3;
        this.ansno = n4;
        this.payload = null;
    }

    public void addPayload(BufferSegment bufferSegment) {
        this.payload = bufferSegment;
    }

    public Iterator getBytes() {
        LinkedList<BufferSegment> linkedList = new LinkedList<BufferSegment>();
        linkedList.add(new BufferSegment(this.buildHeader()));
        if (this.payload != null) {
            linkedList.add(this.payload);
        }
        linkedList.add(new BufferSegment(TRAILER.getBytes()));
        return linkedList.iterator();
    }

    public BufferSegment getPayload() {
        return this.payload;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public String getMessageTypeString() {
        return MessageType.getMessageType(this.messageType);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getMsgno() {
        return this.msgno;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public int getSize() {
        return this.size;
    }

    public int getAnsno() {
        return this.ansno;
    }

    public boolean isLast() {
        return this.last;
    }

    byte[] buildHeader() {
        StringBuffer stringBuffer = new StringBuffer(62);
        stringBuffer.append(MessageType.getMessageType(this.messageType));
        stringBuffer.append(' ');
        stringBuffer.append(this.channel.getNumberAsString());
        stringBuffer.append(' ');
        stringBuffer.append(this.msgno);
        stringBuffer.append(' ');
        stringBuffer.append(this.last ? (char)'.' : '*');
        stringBuffer.append(' ');
        stringBuffer.append(this.seqno);
        stringBuffer.append(' ');
        stringBuffer.append(this.size);
        if (this.messageType == 4) {
            stringBuffer.append(' ');
            stringBuffer.append(this.ansno);
        }
        stringBuffer.append(CRLF);
        Log.logEntry(7, stringBuffer.toString());
        try {
            return stringBuffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UnsupportedEncodingException" + unsupportedEncodingException.getMessage());
        }
    }

    static Frame parseHeader(Session session, byte[] byArray, int n) throws BEEPException {
        boolean bl;
        StringTokenizer stringTokenizer;
        Log.logEntry(8, "Processing normal BEEP frame");
        int n2 = n;
        try {
            stringTokenizer = new StringTokenizer(new String(byArray, 0, n, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UnsupportedEncodingException" + unsupportedEncodingException.getMessage());
        }
        int n3 = stringTokenizer.countTokens();
        if (n3 != 6 && n3 != 7) {
            Log.logEntry(7, "Illegal header tokens=" + n3 + "\n" + new String(byArray));
            throw new BEEPException("Malformed BEEP Header");
        }
        int n4 = MessageType.getMessageType(stringTokenizer.nextToken());
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        int n6 = Integer.parseInt(stringTokenizer.nextToken());
        char c = stringTokenizer.nextToken().charAt(0);
        if (c == '*') {
            bl = false;
        } else if (c == '.') {
            bl = true;
        } else {
            Log.logEntry(7, "lastFrame=" + c);
            throw new BEEPException("Malformed BEEP Header");
        }
        long l = Long.parseLong(stringTokenizer.nextToken());
        int n7 = Integer.parseInt(stringTokenizer.nextToken());
        if (n7 < 0) {
            throw new BEEPException("Malformed BEEP Header");
        }
        int n8 = -1;
        if (n3 == 7) {
            n8 = Integer.parseInt(stringTokenizer.nextToken());
        }
        return new Frame(n4, session.getValidChannel(n5), n6, bl, l, n7, n8);
    }

    private static class MessageType {
        public static final String MESSAGE_TYPE_UNK = "UNK";
        public static final String MESSAGE_TYPE_MSG = "MSG";
        public static final String MESSAGE_TYPE_RPY = "RPY";
        public static final String MESSAGE_TYPE_ERR = "ERR";
        public static final String MESSAGE_TYPE_ANS = "ANS";
        public static final String MESSAGE_TYPE_NUL = "NUL";
        private static final int MESSAGE_TYPE_MAX = 6;
        public static String[] types = new String[6];

        private MessageType() {
        }

        static int getMessageType(String string) throws IndexOutOfBoundsException {
            int n = 0;
            int n2 = 0;
            n2 = 0;
            while (n2 < 6) {
                if (string.equals(types[n2])) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            Log.logEntry(8, "getMessageType=" + types[n] + " (" + n + ")");
            return n;
        }

        static String getMessageType(int n) throws IndexOutOfBoundsException {
            return types[n];
        }

        static {
            MessageType.types[0] = MESSAGE_TYPE_UNK;
            MessageType.types[4] = MESSAGE_TYPE_ANS;
            MessageType.types[1] = MESSAGE_TYPE_MSG;
            MessageType.types[3] = MESSAGE_TYPE_ERR;
            MessageType.types[2] = MESSAGE_TYPE_RPY;
            MessageType.types[5] = MESSAGE_TYPE_NUL;
        }
    }

    public static class BufferSegment {
        public byte[] data;
        public int offset;
        public int length;

        public BufferSegment(byte[] byArray) {
            this.data = byArray;
            this.offset = 0;
            this.length = byArray.length;
        }

        public BufferSegment(byte[] byArray, int n, int n2) {
            this.data = byArray;
            this.offset = n;
            this.length = n2;
        }
    }
}

