/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.core;

import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.BEEPInterruptedException;
import org.beepcore.beep.core.DataStream;
import org.beepcore.beep.core.Frame;

public class FrameDataStream
extends DataStream {
    private static final String ERR_HEADERS_NOT_FOUND = "Unable to distinguish MIME entity headers from the rest of the payload's data (two CRLF pairs not found).";
    private LinkedList frames;
    private int bytesRead = 0;
    private int length = 0;
    private int offset = 0;
    private boolean haveLast = false;
    private boolean headersParsed = false;
    private boolean parsingHeaders = false;
    private int lastFreedIndex = 0;
    private boolean streamOpen = true;
    private boolean release = false;
    private final int LF = 10;
    private final int CR = 13;
    private final int COLON = 58;

    FrameDataStream(boolean bl) {
        this.release = bl;
        this.frames = new LinkedList();
    }

    public FrameDataStream() {
        this.frames = new LinkedList();
    }

    public FrameDataStream(Frame frame) {
        this.frames = new LinkedList();
        this.frames.add(frame);
        this.length = frame.getPayload().length;
        if (frame.isLast()) {
            this.haveLast = true;
        }
    }

    public String getContentType() throws BEEPException {
        if (!this.headersParsed) {
            this.parseHeaders();
        }
        return super.getContentType();
    }

    public String getTransferEncoding() throws BEEPException {
        if (!this.headersParsed) {
            this.parseHeaders();
        }
        return super.getTransferEncoding();
    }

    public String getHeaderValue(String string) throws BEEPException {
        if (!this.headersParsed) {
            this.parseHeaders();
        }
        return super.getHeaderValue(string);
    }

    public Enumeration getHeaderNames() throws BEEPException {
        if (!this.headersParsed) {
            this.parseHeaders();
        }
        return super.getHeaderNames();
    }

    private String getName() throws BEEPException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32);
        int n = this.read();
        if (n == 13) {
            this.read();
            return null;
        }
        int n2 = 0;
        while (n != -1 && n != 58) {
            byteArrayOutputStream.write((byte)n);
            ++n2;
            n = this.read();
        }
        this.read();
        return new String(byteArrayOutputStream.toByteArray(), 0, n2);
    }

    private String getValue() throws BEEPException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32);
        int n = this.read();
        int n2 = 0;
        while (n != -1 && n != 13) {
            byteArrayOutputStream.write((byte)n);
            ++n2;
            n = this.read();
        }
        this.read();
        return new String(byteArrayOutputStream.toByteArray(), 0, n2);
    }

    private void parseHeaders() throws BEEPException {
        if (this.parsingHeaders) {
            return;
        }
        this.parsingHeaders = true;
        String string = this.getName();
        if (string == null) {
            super.setContentType("application/octet-stream");
            super.setTransferEncoding("binary");
            this.headersParsed = true;
            this.parsingHeaders = false;
            return;
        }
        String string2 = this.getValue();
        super.setHeader(string, string2);
        while ((string = this.getName()) != null) {
            string2 = this.getValue();
            super.setHeader(string, string2);
        }
        this.headersParsed = true;
        this.parsingHeaders = false;
    }

    public void add(Frame frame) {
        if (!this.streamOpen && this.release) {
            frame.getChannel().freeReceiveBufferBytes(frame.getPayload().length);
            return;
        }
        FrameDataStream frameDataStream = this;
        synchronized (frameDataStream) {
            if (frame.getPayload().length > 0) {
                this.frames.add(frame);
                this.length += frame.getPayload().length;
            }
            if (frame.isLast()) {
                this.haveLast = true;
            }
            this.notify();
        }
    }

    int available() throws BEEPException {
        if (!this.headersParsed) {
            if (!this.doHeadersExist()) {
                return 0;
            }
            this.parseHeaders();
        }
        return this.length - this.bytesRead;
    }

    private void waitForFrame(int n) throws BEEPException {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            BEEPInterruptedException bEEPInterruptedException = new BEEPInterruptedException(interruptedException.getMessage());
            bEEPInterruptedException.bytesTransferred = n;
            throw bEEPInterruptedException;
        }
    }

    int read() throws BEEPException {
        Object object;
        Frame frame;
        if (!this.headersParsed) {
            this.parseHeaders();
        }
        FrameDataStream frameDataStream = this;
        synchronized (frameDataStream) {
            do {
                if (this.available() != 0) continue;
                if (this.haveLast && this.frames.size() == 0) {
                    int n = -1;
                    return n;
                }
                this.waitForFrame(0);
            } while ((frame = (Frame)this.frames.getFirst()) == null);
        }
        int n = this.offset++;
        ++this.bytesRead;
        if (this.offset >= frame.getPayload().length) {
            this.offset = 0;
            object = this;
            synchronized (object) {
                this.frames.removeFirst();
            }
            if (this.release) {
                frame.getChannel().freeReceiveBufferBytes(frame.getPayload().length);
            }
        }
        object = frame.getPayload().data;
        return object[frame.getPayload().offset + n] & 0xFF;
    }

    int read(byte[] byArray) throws BEEPException {
        return this.read(byArray, 0, byArray.length);
    }

    int read(byte[] byArray, int n, int n2) throws BEEPException {
        if (!this.headersParsed) {
            this.parseHeaders();
        }
        return this.privateRead(byArray, n, n2);
    }

    private int privateRead(byte[] byArray, int n, int n2) throws BEEPException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.haveLast && this.frames.size() == 0) {
            return -1;
        }
        int n3 = 0;
        while (n3 < n2) {
            Frame frame;
            FrameDataStream frameDataStream = this;
            synchronized (frameDataStream) {
                if (this.length - this.bytesRead == 0) {
                    if (this.haveLast && this.frames.size() == 0) {
                        int n4 = n3;
                        return n4;
                    }
                    this.waitForFrame(n3);
                }
                if ((frame = (Frame)this.frames.getFirst()) == null) {
                    continue;
                }
            }
            int n5 = frame.getPayload().length - this.offset;
            if (n2 - n3 >= n5) {
                System.arraycopy(frame.getPayload().data, frame.getPayload().offset + this.offset, byArray, n + n3, n5);
                this.offset = 0;
                n3 += n5;
                this.bytesRead += n5;
                if (this.release) {
                    frame.getChannel().freeReceiveBufferBytes(frame.getPayload().length);
                }
                FrameDataStream frameDataStream2 = this;
                synchronized (frameDataStream2) {
                    this.frames.removeFirst();
                    continue;
                }
            }
            System.arraycopy(frame.getPayload().data, frame.getPayload().offset + this.offset, byArray, n + n3, n2 - n3);
            this.bytesRead += n2 - n3;
            this.offset += n2 - n3;
            return n2;
        }
        return n3;
    }

    private boolean doHeadersExist() {
        FrameIterator frameIterator = new FrameIterator(this.frames);
        int n = frameIterator.read();
        int n2 = frameIterator.read();
        if (n == 13 && n2 == 10) {
            return true;
        }
        n = n2;
        while (n2 != -1) {
            if (n == 13 && n2 == 10) {
                n = frameIterator.read();
                n2 = frameIterator.read();
                if (n == 13 && n2 == 10) {
                    return true;
                }
            }
            n = n2;
            n2 = frameIterator.read();
        }
        return false;
    }

    protected int availableHeadersAndData() {
        return this.length - this.bytesRead;
    }

    protected int readHeadersAndData(byte[] byArray, int n, int n2) throws BEEPException {
        if (this.headersParsed) {
            return -1;
        }
        return this.privateRead(byArray, n, n2);
    }

    long skip(long l) throws BEEPException {
        int n = 0;
        if (this.available() == 0) {
            return 0L;
        }
        try {
            Frame frame = (Frame)this.frames.getFirst();
            while ((long)n < l) {
                ++this.offset;
                ++this.bytesRead;
                if (this.offset == frame.getPayload().length) {
                    this.offset = 0;
                    FrameDataStream frameDataStream = this;
                    synchronized (frameDataStream) {
                        this.frames.removeFirst();
                    }
                    if (this.release) {
                        frame.getChannel().freeReceiveBufferBytes(frame.getPayload().length);
                    }
                    frame = (Frame)this.frames.getFirst();
                }
                ++n;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return n;
    }

    public void close() {
        this.streamOpen = false;
        if (this.release) {
            int n = 0;
            while (n < this.frames.size()) {
                Frame frame = (Frame)this.frames.get(n);
                frame.getChannel().freeReceiveBufferBytes(frame.getPayload().length);
                ++n;
            }
        }
        this.frames.clear();
    }

    public boolean isComplete() {
        return this.haveLast;
    }

    private class FrameIterator {
        private Iterator i;
        private int pos = 0;
        private byte[] curBytes = new byte[0];

        FrameIterator(Collection collection) {
            this.i = collection.iterator();
        }

        int read() {
            int n = -1;
            if (this.pos == this.curBytes.length) {
                if (!this.i.hasNext()) {
                    return -1;
                }
                this.curBytes = ((Frame)this.i.next()).getPayload().data;
                this.pos = 0;
            }
            n = this.curBytes[this.pos];
            ++this.pos;
            return n & 0xFF;
        }
    }
}

