/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.core;

import java.io.IOException;
import java.io.InputStream;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.DataStream;

public class InputStreamDataStream
extends DataStream {
    protected InputStream data = null;
    private boolean complete = false;
    private long length = -1L;
    private long bytesRead = 0L;
    private long markBytesRead = 0L;

    public InputStreamDataStream(InputStream inputStream, long l) {
        this.data = inputStream;
        if (l <= 0L) {
            throw new IllegalArgumentException("Length must be greater than zero");
        }
        this.length = l;
    }

    public InputStreamDataStream(String string, InputStream inputStream, long l) {
        super(string, "binary");
        this.data = inputStream;
        if (l <= 0L) {
            throw new IllegalArgumentException("Length must be greater than zero");
        }
        this.length = l;
    }

    public InputStreamDataStream(String string, String string2, InputStream inputStream, long l) {
        super(string, string2);
        this.data = inputStream;
        if (l <= 0L) {
            throw new IllegalArgumentException("Length must be greater than zero");
        }
        this.length = l;
    }

    protected InputStreamDataStream(InputStream inputStream) {
        this.data = inputStream;
    }

    protected InputStreamDataStream(String string, InputStream inputStream) {
        super(string, "binary");
        this.data = inputStream;
    }

    protected InputStreamDataStream(String string, String string2, InputStream inputStream) {
        super(string, string2);
        this.data = inputStream;
    }

    public InputStream getInputStream() {
        return this.data;
    }

    public boolean isComplete() {
        return this.complete;
    }

    int available() throws BEEPException {
        try {
            return this.data.available();
        }
        catch (IOException iOException) {
            throw new BEEPException(iOException.getMessage());
        }
    }

    int read() throws BEEPException {
        try {
            if (this.length != -1L && this.bytesRead >= this.length) {
                return -1;
            }
            int n = this.data.read();
            ++this.bytesRead;
            if (this.length != -1L && this.bytesRead >= this.length) {
                this.complete = true;
            }
            return n;
        }
        catch (IOException iOException) {
            throw new BEEPException(iOException.getMessage());
        }
    }

    int read(byte[] byArray) throws BEEPException {
        return this.read(byArray, 0, byArray.length);
    }

    int read(byte[] byArray, int n, int n2) throws BEEPException {
        try {
            if (this.length != -1L && this.bytesRead >= this.length) {
                return -1;
            }
            int n3 = this.data.read(byArray, n, n2);
            if (n3 != -1) {
                this.bytesRead += (long)n3;
                if (this.length != -1L && this.bytesRead >= this.length) {
                    this.complete = true;
                }
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new BEEPException(iOException.getMessage());
        }
    }

    long skip(long l) throws BEEPException {
        try {
            if (this.length != -1L && l + this.bytesRead > this.length) {
                return 0L;
            }
            this.bytesRead += l;
            return this.data.skip(l);
        }
        catch (IOException iOException) {
            throw new BEEPException(iOException.getMessage());
        }
    }

    void reset() throws BEEPException {
        try {
            this.data.reset();
        }
        catch (IOException iOException) {
            throw new BEEPException(iOException.getMessage());
        }
        this.bytesRead = this.markBytesRead;
    }

    boolean markSupported() {
        return this.data.markSupported();
    }

    void mark(int n) {
        this.markBytesRead = this.bytesRead;
        this.data.mark(n);
    }

    void close() throws BEEPException {
        try {
            this.data.close();
        }
        catch (IOException iOException) {
            throw new BEEPException(iOException.getMessage());
        }
    }
}

