/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.core;

import java.util.Enumeration;
import java.util.Hashtable;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.SessionTuningProperties;
import org.beepcore.beep.core.StartChannelListener;
import org.beepcore.beep.util.Log;

public class ProfileRegistry
implements Cloneable {
    private static final String SPACE = " ";
    private static final String FRAGMENT_ANGLE_SUFFIX = ">";
    private static final String FRAGMENT_FEATURES_PREFIX = "features='";
    private static final String FRAGMENT_GREETING_PREFIX = "<greeting";
    private static final String FRAGMENT_GREETING_SUFFIX = "</greeting>";
    private static final String FRAGMENT_LOCALIZE_PREFIX = "localize='";
    private static final String FRAGMENT_PROFILE_PREFIX = "<profile ";
    private static final String FRAGMENT_QUOTE_ANGLE_SUFFIX = "'>";
    private static final String FRAGMENT_QUOTE_SLASH_ANGLE_SUFFIX = "' />";
    private static final String FRAGMENT_QUOTE_SUFFIX = "' ";
    private static final String FRAGMENT_URI_PREFIX = "uri='";
    private static final int FRAGMENT_GREETING_LENGTH = "<greeting".length() + "'>".length() + "</greeting>".length();
    private static final int FRAGMENT_PROFILE_LENGTH = "<profile ".length() + "'>".length();
    private Hashtable profileListeners;
    String greeting;
    String localize;
    String features;

    public ProfileRegistry() {
        this.greeting = null;
        this.features = null;
        this.localize = "i-default";
        this.profileListeners = new Hashtable();
    }

    private ProfileRegistry(String string, String string2, String string3, Hashtable hashtable) {
        this.greeting = string;
        this.features = string3;
        this.localize = string2;
        this.profileListeners = hashtable;
    }

    public Object clone() {
        return new ProfileRegistry(this.greeting, this.localize, this.features, (Hashtable)this.profileListeners.clone());
    }

    public Enumeration getProfiles() {
        return this.profileListeners.keys();
    }

    public StartChannelListener getStartChannelListener(SessionTuningProperties sessionTuningProperties, String string) {
        InternalProfile internalProfile = (InternalProfile)this.profileListeners.get(string);
        if (internalProfile == null) {
            return null;
        }
        if (internalProfile.tuning == null || internalProfile.tuning.isEmpty()) {
            return ((InternalProfile)this.profileListeners.get((Object)string)).listener;
        }
        if (sessionTuningProperties == null) {
            Log.logEntry(7, "Session does not have any tuning properties");
            return null;
        }
        int n = 0;
        n = 0;
        while (n < SessionTuningProperties.STANDARD_PROPERTIES.length) {
            if (internalProfile.tuning.getProperty(SessionTuningProperties.STANDARD_PROPERTIES[n]) != null && sessionTuningProperties.getProperty(SessionTuningProperties.STANDARD_PROPERTIES[n]) == null) {
                Log.logEntry(7, "Session does not have tuning property " + SessionTuningProperties.STANDARD_PROPERTIES[n]);
                return null;
            }
            ++n;
        }
        return ((InternalProfile)this.profileListeners.get((Object)string)).listener;
    }

    public SessionTuningProperties getSessionProperties(String string) {
        return ((InternalProfile)this.profileListeners.get((Object)string)).tuning;
    }

    public synchronized StartChannelListener addStartChannelListener(String string, StartChannelListener startChannelListener, SessionTuningProperties sessionTuningProperties) {
        StartChannelListener startChannelListener2 = null;
        if (this.profileListeners.get(string) != null) {
            startChannelListener2 = ((InternalProfile)this.profileListeners.get((Object)string)).listener;
        }
        InternalProfile internalProfile = new InternalProfile();
        internalProfile.listener = startChannelListener;
        internalProfile.tuning = sessionTuningProperties;
        this.profileListeners.put(string, internalProfile);
        return startChannelListener2;
    }

    public synchronized StartChannelListener removeStartChannelListener(String string) {
        InternalProfile internalProfile = (InternalProfile)this.profileListeners.remove(string);
        return internalProfile.listener;
    }

    public void setLocalization(String string) {
        this.localize = string;
    }

    public String getLocalization() {
        return this.localize;
    }

    public byte[] getGreeting(Session session) {
        int n = FRAGMENT_GREETING_LENGTH;
        int n2 = 0;
        n2 = this.profileListeners.size();
        Enumeration enumeration = this.profileListeners.keys();
        while (enumeration.hasMoreElements()) {
            n += ((String)enumeration.nextElement()).length() + FRAGMENT_PROFILE_LENGTH;
        }
        StringBuffer stringBuffer = new StringBuffer(++n);
        Enumeration enumeration2 = this.profileListeners.keys();
        stringBuffer.append(FRAGMENT_GREETING_PREFIX);
        if (this.localize != null && !this.localize.equals("i-default")) {
            stringBuffer.append(SPACE);
            stringBuffer.append(FRAGMENT_LOCALIZE_PREFIX);
            stringBuffer.append(this.localize);
            stringBuffer.append(FRAGMENT_QUOTE_SUFFIX);
        }
        if (this.features != null) {
            stringBuffer.append(FRAGMENT_FEATURES_PREFIX);
            stringBuffer.append(this.features);
            stringBuffer.append(FRAGMENT_QUOTE_SUFFIX);
        }
        stringBuffer.append(FRAGMENT_ANGLE_SUFFIX);
        while (enumeration2.hasMoreElements()) {
            try {
                String string = (String)enumeration2.nextElement();
                InternalProfile internalProfile = (InternalProfile)this.profileListeners.get(string);
                boolean bl = false;
                SessionTuningProperties sessionTuningProperties = session.getTuningProperties();
                int n3 = 0;
                while (n3 < SessionTuningProperties.STANDARD_PROPERTIES.length) {
                    if (internalProfile.tuning != null && sessionTuningProperties != null && internalProfile.tuning.getProperty(SessionTuningProperties.STANDARD_PROPERTIES[n3]) != null && sessionTuningProperties.getProperty(SessionTuningProperties.STANDARD_PROPERTIES[n3]) != null) {
                        bl = true;
                    }
                    ++n3;
                }
                if (internalProfile.tuning != null && (!bl || !internalProfile.listener.advertiseProfile(session))) continue;
                stringBuffer.append(FRAGMENT_PROFILE_PREFIX);
                stringBuffer.append(FRAGMENT_URI_PREFIX);
                stringBuffer.append(string);
                stringBuffer.append(FRAGMENT_QUOTE_SLASH_ANGLE_SUFFIX);
            }
            catch (BEEPException bEEPException) {
                bEEPException.printStackTrace();
            }
        }
        stringBuffer.append(FRAGMENT_GREETING_SUFFIX);
        this.greeting = stringBuffer.toString();
        return this.greeting.getBytes();
    }

    private class InternalProfile {
        StartChannelListener listener;
        SessionTuningProperties tuning;

        private InternalProfile() {
        }
    }
}

