/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.beepcore.beep.core.AbortChannelException;
import org.beepcore.beep.core.BEEPError;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.ByteDataStream;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.CloseChannelException;
import org.beepcore.beep.core.DataListener;
import org.beepcore.beep.core.DataStream;
import org.beepcore.beep.core.Frame;
import org.beepcore.beep.core.Message;
import org.beepcore.beep.core.MessageListener;
import org.beepcore.beep.core.MessageMSG;
import org.beepcore.beep.core.ProfileRegistry;
import org.beepcore.beep.core.ReplyListener;
import org.beepcore.beep.core.SessionCredential;
import org.beepcore.beep.core.SessionEvent;
import org.beepcore.beep.core.SessionEventListener;
import org.beepcore.beep.core.SessionTuningProperties;
import org.beepcore.beep.core.StartChannelException;
import org.beepcore.beep.core.StartChannelListener;
import org.beepcore.beep.core.StartChannelProfile;
import org.beepcore.beep.core.StringDataStream;
import org.beepcore.beep.core.TuningProfile;
import org.beepcore.beep.core.TuningResetException;
import org.beepcore.beep.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class Session {
    public static final int SESSION_STATE_UNINITIALIZED = 0;
    public static final int SESSION_STATE_INITIALIZED = 1;
    public static final int SESSION_STATE_GREETING_SENT = 2;
    public static final int SESSION_STATE_GREETING_RECEIVED = 4;
    public static final int SESSION_STATE_ACTIVE = 7;
    public static final int SESSION_STATE_TUNING = 7;
    public static final int SESSION_STATE_CLOSING = 15;
    public static final int SESSION_STATE_TERMINATING = 16;
    public static final int SESSION_STATE_CLOSED = 8;
    private static final String CORE = "core";
    private static final int DEFAULT_CHANNELS_SIZE = 4;
    private static final int DEFAULT_PROPERTIES_SIZE = 4;
    private static final int DEFAULT_POLL_INTERVAL = 500;
    private static final int MAX_PAYLOAD_SIZE = 4096;
    private static final int MAX_PCDATA_SIZE = 4096;
    private static final int MAX_START_CHANNEL_WAIT = 60000;
    private static final int MAX_START_CHANNEL_INTERVAL = 100;
    private static final String CHANNEL_ZERO = "0";
    private static final String ERR_BEEP_START_CHANNEL_TIMEOUT = "Channel start timed out.";
    private static final String ERR_GREETING_FAILED = "Greeting exchange failed";
    private static final String ERR_ILLEGAL_SHUTDOWN = "Illegal state for shutdown";
    private static final String ERR_PROFILES_UNAVAILABLE = "all requested profiles are unsupported";
    private static final String ERR_NONEXISTENT_CHANNEL = "Session call on nonexistent channel.";
    private static final String ERR_STATE_CHANGE = "Illegal session state transition";
    private static final String ERR_MALFORMED_XML_MSG = "Malformed XML";
    private static final String ERR_PCDATA_TOO_BIG_MSG = "Element's PCDATA exceeds the maximum size";
    private static final String ERR_UNKNOWN_OPERATION_ELEMENT_MSG = "Unknown operation element";
    private static final String ERR_MALFORMED_PROFILE_MSG = "Malformed profile";
    private static final String FRAGMENT_ANGLE_SUFFIX = ">";
    private static final String FRAGMENT_CDATA_PREFIX = "<![CDATA[";
    private static final String FRAGMENT_CDATA_SUFFIX = "]]>";
    private static final String FRAGMENT_CLOSE_PREFIX = "<close ";
    private static final String FRAGMENT_CODE_PREFIX = "code='";
    private static final String FRAGMENT_ENCODING_PREFIX = "encoding='";
    private static final String FRAGMENT_NUMBER_PREFIX = "number='";
    private static final String FRAGMENT_OK = "<ok />";
    private static final String FRAGMENT_PROFILE_PREFIX = "<profile ";
    private static final String FRAGMENT_PROFILE_SUFFIX = "</profile>";
    private static final String FRAGMENT_QUOTE_ANGLE_SUFFIX = "'>";
    private static final String FRAGMENT_QUOTE_SLASH_ANGLE_SUFFIX = "' />";
    private static final String FRAGMENT_QUOTE_SUFFIX = "' ";
    private static final String FRAGMENT_SERVERNAME_PREFIX = "serverName='";
    private static final String FRAGMENT_SLASH_ANGLE_SUFFIX = " />";
    private static final String FRAGMENT_START_PREFIX = "<start ";
    private static final String FRAGMENT_START_SUFFIX = "</start>";
    private static final String FRAGMENT_URI_PREFIX = "uri='";
    private static final String FRAGMENT_XML_LANG_PREFIX = "xml:lang='";
    private static final String TAG_CLOSE = "close";
    private static final String TAG_CODE = "code";
    private static final String TAG_ENCODING = "encoding";
    private static final String TAG_FEATURES = "features";
    private static final String TAG_GREETING = "greeting";
    private static final String TAG_LOCALIZE = "localize";
    private static final String TAG_NUMBER = "number";
    private static final String TAG_OK = "ok";
    private static final String TAG_PROFILE = "profile";
    private static final String TAG_START = "start";
    private static final String TAG_SERVER_NAME = "serverName";
    private static final String TAG_URI = "uri";
    private static final String TAG_XML_LANG = "xml:lang";
    private int state = 0;
    private long messageNumber;
    private long nextChannelNumber = 0L;
    private Channel zero;
    private ChannelZeroListener zeroListener;
    private Hashtable channels = null;
    private Hashtable properties = null;
    private Hashtable eventTable = null;
    private ProfileRegistry profileRegistry = null;
    private SessionCredential localCredential;
    private SessionCredential peerCredential;
    private SessionTuningProperties tuningProperties = null;
    private Collection peerSupportedProfiles;
    private boolean overflow;
    private boolean allowChannelWindowUpdates = true;
    private DocumentBuilder builder;

    protected Session(ProfileRegistry profileRegistry, int n, SessionCredential sessionCredential, SessionCredential sessionCredential2, SessionTuningProperties sessionTuningProperties) throws BEEPException {
        this.localCredential = sessionCredential;
        this.peerCredential = sessionCredential2;
        this.nextChannelNumber = n;
        this.overflow = false;
        this.profileRegistry = profileRegistry;
        this.channels = new Hashtable(4);
        this.eventTable = new Hashtable(4);
        this.properties = new Hashtable(4);
        this.tuningProperties = sessionTuningProperties;
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BEEPException("Invalid parser configuration");
        }
        this.changeState(1);
    }

    protected void init() throws BEEPException {
        this.peerSupportedProfiles = null;
        GreetingListener greetingListener = new GreetingListener();
        this.zero = new Channel(this, CHANNEL_ZERO, greetingListener);
        this.zeroListener = new ChannelZeroListener();
        this.zero.setDataListener(this.zeroListener);
        this.channels.put(CHANNEL_ZERO, this.zero);
        this.sendGreeting();
        this.changeState(2);
        this.enableIO();
        int n = 0;
        while (this.state < 7 && n < 60000) {
            try {
                GreetingListener greetingListener2 = greetingListener;
                synchronized (greetingListener2) {
                    greetingListener.wait(0L);
                    n += 100;
                }
            }
            catch (InterruptedException interruptedException) {
                n += 100;
            }
        }
        if (this.zero.getState() == 5) {
            throw new BEEPException(ERR_GREETING_FAILED);
        }
    }

    protected void tuningInit() throws BEEPException {
        Log.logEntry(7, CORE, "Session.tuningInit");
        this.peerSupportedProfiles = null;
        GreetingListener greetingListener = new GreetingListener();
        this.zeroListener = new ChannelZeroListener();
        this.zero = new Channel(this, CHANNEL_ZERO, greetingListener);
        this.zero.setDataListener(this.zeroListener);
        this.channels.put(CHANNEL_ZERO, this.zero);
        this.sendGreeting();
        this.changeState(2);
        this.enableIO();
    }

    public void close() throws BEEPException {
        Log.logEntry(7, "Closing Session with " + this.channels.size() + " channels");
        Iterator iterator = this.channels.values().iterator();
        while (iterator.hasNext()) {
            StartChannelListener startChannelListener;
            Channel channel = (Channel)iterator.next();
            if (channel.getNumber() == 0 || (startChannelListener = this.profileRegistry.getStartChannelListener(this.tuningProperties, channel.getProfile())) == null) continue;
            try {
                startChannelListener.closeChannel(channel);
            }
            catch (CloseChannelException closeChannelException) {
                throw new BEEPException("Close Session rejected by local channel " + channel.getProfile());
            }
        }
        this.zero.close();
        this.shutdown();
    }

    public SessionCredential getLocalCredential() {
        return this.localCredential;
    }

    public SessionCredential getPeerCredential() {
        return this.peerCredential;
    }

    public Collection getPeerSupportedProfiles() {
        return this.peerSupportedProfiles;
    }

    public ProfileRegistry getProfileRegistry() {
        return this.profileRegistry;
    }

    public int getState() {
        return this.state;
    }

    public boolean isInitiator() {
        return this.nextChannelNumber % 2L == 1L;
    }

    public void registerForEvent(SessionEventListener sessionEventListener, int n) {
        Integer n2 = new Integer(n);
        LinkedList<SessionEventListener> linkedList = (LinkedList<SessionEventListener>)this.eventTable.get(n2);
        if (linkedList == null) {
            linkedList = new LinkedList<SessionEventListener>();
        }
        linkedList.add(sessionEventListener);
        this.eventTable.put(n2, linkedList);
    }

    public Channel startChannel(String string) throws BEEPException, BEEPError {
        return this.startChannel(string, null);
    }

    public Channel startChannel(String string, DataListener dataListener) throws BEEPException, BEEPError {
        StartChannelProfile startChannelProfile = new StartChannelProfile(string);
        LinkedList<StartChannelProfile> linkedList = new LinkedList<StartChannelProfile>();
        linkedList.add(startChannelProfile);
        return this.startChannel(linkedList, dataListener, false);
    }

    public Channel startChannel(String string, boolean bl, String string2, DataListener dataListener) throws BEEPException, BEEPError {
        StartChannelProfile startChannelProfile = new StartChannelProfile(string, bl, string2);
        LinkedList<StartChannelProfile> linkedList = new LinkedList<StartChannelProfile>();
        linkedList.add(startChannelProfile);
        return this.startChannel(linkedList, dataListener, false);
    }

    public Channel startChannel(Collection collection, DataListener dataListener) throws BEEPException, BEEPError {
        return this.startChannel(collection, dataListener, false);
    }

    Channel startChannel(Collection collection, DataListener dataListener, boolean bl) throws BEEPException, BEEPError {
        Object object;
        String string = this.getNextFreeChannelNumber();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FRAGMENT_START_PREFIX);
        stringBuffer.append(FRAGMENT_NUMBER_PREFIX);
        stringBuffer.append(string);
        stringBuffer.append(FRAGMENT_QUOTE_ANGLE_SUFFIX);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (StartChannelProfile)iterator.next();
            stringBuffer.append(FRAGMENT_PROFILE_PREFIX);
            stringBuffer.append(FRAGMENT_URI_PREFIX);
            stringBuffer.append(((StartChannelProfile)object).uri);
            stringBuffer.append(FRAGMENT_QUOTE_SUFFIX);
            if (((StartChannelProfile)object).data == null) {
                stringBuffer.append(FRAGMENT_SLASH_ANGLE_SUFFIX);
                continue;
            }
            if (((StartChannelProfile)object).base64Encoding) {
                stringBuffer.append("encoding='base64' ");
            }
            stringBuffer.append(FRAGMENT_ANGLE_SUFFIX);
            stringBuffer.append(FRAGMENT_CDATA_PREFIX);
            stringBuffer.append(((StartChannelProfile)object).data);
            stringBuffer.append(FRAGMENT_CDATA_SUFFIX);
            stringBuffer.append(FRAGMENT_PROFILE_SUFFIX);
        }
        stringBuffer.append(FRAGMENT_START_SUFFIX);
        object = new Channel(null, string, dataListener, this);
        StringDataStream stringDataStream = null;
        stringDataStream = new StringDataStream("application/beep+xml", stringBuffer.toString());
        this.zero.sendMSG((DataStream)stringDataStream, new StartReplyListener((Channel)object, bl));
        this.waitForResult((Channel)object, 1);
        return object;
    }

    public void terminate(String string) {
        Log.logEntry(3, string);
        try {
            this.changeState(16);
            this.shutdown();
        }
        catch (BEEPException bEEPException) {
            // empty catch block
        }
    }

    protected synchronized boolean changeState(int n) throws BEEPException {
        if (this.state == 0 && n != 1 && n != 8) {
            throw new BEEPException(ERR_STATE_CHANGE);
        }
        if (this.state == 1 && n != 2 && n != 4 && n != 8) {
            throw new BEEPException(ERR_STATE_CHANGE);
        }
        if (this.state == 7 && n != 8 && n != 16 && n != 15) {
            throw new BEEPException(ERR_STATE_CHANGE);
        }
        this.state |= n;
        Log.logEntry(7, CORE, "State changed to " + this.state);
        return true;
    }

    protected Frame createFrame(byte[] byArray, int n) throws BEEPException {
        Frame frame = Frame.parseHeader(this, byArray, n);
        if (frame.getSize() > frame.getChannel().getAvailableWindow()) {
            throw new BEEPException("Payload size is greater than channel window size");
        }
        return frame;
    }

    protected abstract void disableIO();

    protected abstract void enableIO();

    protected void fireEvent(int n, Object object) {
        Integer n2 = new Integer(n);
        LinkedList linkedList = (LinkedList)this.eventTable.get(n2);
        if (linkedList == null) {
            return;
        }
        SessionEvent sessionEvent = new SessionEvent(n, object);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ((SessionEventListener)iterator.next()).receiveEvent(sessionEvent);
        }
    }

    protected int getChannelAvailableWindow(int n) throws BEEPException {
        Channel channel = (Channel)this.channels.get(Integer.toString(n));
        if (channel == null) {
            throw new BEEPException(ERR_NONEXISTENT_CHANNEL);
        }
        return channel.getAvailableWindow();
    }

    protected String getChannelNumberAsString(Channel channel) {
        return channel.getNumberAsString();
    }

    protected abstract int getMaxFrameSize() throws BEEPException;

    protected void postFrame(Frame frame) throws BEEPException {
        block8: {
            try {
                if (this.state == 7) {
                    frame.getChannel().postFrame(frame);
                    break block8;
                }
                if (this.state < 7) {
                    Session session = this;
                    synchronized (session) {
                        frame.getChannel().postFrame(frame);
                        break block8;
                    }
                }
                Log.logEntry(7, "Dropping a frame because the Session state is no longer active.");
            }
            catch (BEEPException bEEPException) {
                this.terminate(bEEPException.getMessage());
                return;
            }
            catch (Throwable throwable) {
                Log.logEntry(3, throwable);
                this.terminate("Uncaught exception, terminating session");
                return;
            }
        }
    }

    protected void prohibitChannelWindowUpdates() {
        this.allowChannelWindowUpdates = false;
    }

    protected abstract Session reset(SessionCredential var1, SessionCredential var2, SessionTuningProperties var3, ProfileRegistry var4, Object var5) throws BEEPException;

    protected abstract void sendFrame(Frame var1) throws BEEPException;

    protected void setLocalCredential(SessionCredential sessionCredential) {
        this.localCredential = sessionCredential;
    }

    protected void setPeerCredential(SessionCredential sessionCredential) {
        this.peerCredential = sessionCredential;
    }

    protected void setTuningProperties(SessionTuningProperties sessionTuningProperties) {
        this.tuningProperties = sessionTuningProperties;
    }

    public SessionTuningProperties getTuningProperties() {
        return this.tuningProperties;
    }

    protected abstract boolean updateMyReceiveBufferSize(Channel var1, long var2, long var4, int var6, int var7, int var8) throws BEEPException;

    protected void updatePeerReceiveBufferSize(int n, long l, int n2) throws BEEPException {
        Channel channel = this.getValidChannel(n);
        channel.updatePeerReceiveBufferSize(l, n2);
    }

    void closeChannel(Channel channel, int n, String string) throws BEEPException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FRAGMENT_CLOSE_PREFIX);
        stringBuffer.append(FRAGMENT_NUMBER_PREFIX);
        stringBuffer.append(channel.getNumberAsString());
        stringBuffer.append(FRAGMENT_QUOTE_SUFFIX);
        stringBuffer.append(FRAGMENT_CODE_PREFIX);
        stringBuffer.append(n);
        if (string != null) {
            stringBuffer.append(FRAGMENT_QUOTE_SUFFIX);
            stringBuffer.append(FRAGMENT_XML_LANG_PREFIX);
            stringBuffer.append(string);
        }
        stringBuffer.append(FRAGMENT_QUOTE_SLASH_ANGLE_SUFFIX);
        StringDataStream stringDataStream = new StringDataStream("application/beep+xml", stringBuffer.toString());
        this.zero.sendMSG((DataStream)stringDataStream, new CloseReplyListener(channel));
        this.waitForResult(channel, 2);
    }

    Channel getValidChannel(int n) throws BEEPException {
        Channel channel = (Channel)this.channels.get(Integer.toString(n));
        if (channel == null) {
            throw new BEEPException(ERR_NONEXISTENT_CHANNEL);
        }
        return channel;
    }

    void sendProfile(String string, String string2, Channel channel) throws BEEPException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FRAGMENT_PROFILE_PREFIX);
        stringBuffer.append(FRAGMENT_URI_PREFIX);
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(FRAGMENT_QUOTE_ANGLE_SUFFIX);
            stringBuffer.append(FRAGMENT_CDATA_PREFIX);
            stringBuffer.append(string2);
            stringBuffer.append(FRAGMENT_CDATA_SUFFIX);
            stringBuffer.append(FRAGMENT_PROFILE_SUFFIX);
        } else {
            stringBuffer.append(FRAGMENT_QUOTE_SLASH_ANGLE_SUFFIX);
        }
        StringDataStream stringDataStream = new StringDataStream("application/beep+xml", stringBuffer.toString());
        channel.setState(2);
        this.channels.put(channel.getNumberAsString(), channel);
        ((Message)this.zero.getAppData()).sendRPY(stringDataStream);
    }

    private void receiveCloseChannel(String string, String string2, String string3, String string4) throws BEEPError {
        Object object;
        if (string.equals(CHANNEL_ZERO)) {
            this.receiveCloseChannelZero();
            return;
        }
        Channel channel = (Channel)this.channels.get(string);
        if (channel == null) {
            throw new BEEPError(553, "Close requested for nonexistent channel");
        }
        try {
            object = this.profileRegistry.getStartChannelListener(this.tuningProperties, channel.getProfile());
            object.closeChannel(channel);
            channel.setState(3);
        }
        catch (BEEPError bEEPError) {
            channel.setState(3);
            throw bEEPError;
        }
        object = new StringDataStream("application/beep+xml", FRAGMENT_OK);
        try {
            ((Message)this.zero.getAppData()).sendRPY((DataStream)object);
        }
        catch (BEEPException bEEPException) {
            this.terminate("Error sending RPY for <close>");
            return;
        }
        channel.setState(4);
        this.channels.remove(channel.getNumberAsString());
    }

    private void receiveCloseChannelZero() throws BEEPError {
        Object object;
        Log.logEntry(7, "Closing Session with " + this.channels.size() + " channels");
        Iterator iterator = this.channels.values().iterator();
        while (iterator.hasNext()) {
            object = (Channel)iterator.next();
            if (((Channel)object).getNumber() == 0) continue;
            StartChannelListener startChannelListener = this.profileRegistry.getStartChannelListener(this.tuningProperties, ((Channel)object).getProfile());
            try {
                startChannelListener.closeChannel((Channel)object);
                iterator.remove();
            }
            catch (CloseChannelException closeChannelException) {
                try {
                    this.changeState(7);
                    throw closeChannelException;
                }
                catch (BEEPException bEEPException) {
                    this.terminate("Error changing Session state from closing to active");
                    return;
                }
            }
        }
        object = new StringDataStream("application/beep+xml", FRAGMENT_OK);
        try {
            ((Message)this.zero.getAppData()).sendRPY((DataStream)object);
        }
        catch (BEEPException bEEPException) {
            this.terminate("Error sending RPY for <close> for channel 0");
            return;
        }
        this.disableIO();
        try {
            this.changeState(8);
        }
        catch (BEEPException bEEPException) {
            Log.logEntry(3, bEEPException);
        }
        this.fireEvent(5, this);
    }

    private void receiveStartChannelResultOk(Channel channel, String string) throws BEEPException {
        channel.setState(2);
        this.channels.put(channel.getNumberAsString(), channel);
        Channel channel2 = channel;
        synchronized (channel2) {
            channel.notify();
        }
        if (TuningProfile.isTuningProfile(channel.getProfile())) {
            Log.logEntry(7, CORE, "Disabling this I/O thread");
            this.disableIO();
        }
    }

    private void receiveCloseChannelResultOk(Channel channel) throws BEEPException {
        channel.setState(3);
        this.channels.remove(channel.getNumberAsString());
        channel.setState(4);
        Channel channel2 = channel;
        synchronized (channel2) {
            channel.notify();
        }
    }

    private synchronized String getNextFreeChannelNumber() {
        long l;
        Session session = this;
        synchronized (session) {
            l = this.nextChannelNumber;
            this.nextChannelNumber += 2L;
        }
        String string = Long.toString(l);
        if (this.overflow && this.channels.get(string) != null) {
            return this.getNextFreeChannelNumber();
        }
        if (this.nextChannelNumber > Integer.MAX_VALUE) {
            this.nextChannelNumber %= Integer.MAX_VALUE;
            this.overflow = true;
        }
        return string;
    }

    private boolean processStartChannel(String string, Collection collection) throws BEEPError {
        Channel channel = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            StartChannelProfile startChannelProfile = (StartChannelProfile)iterator.next();
            StartChannelListener startChannelListener = this.profileRegistry.getStartChannelListener(this.tuningProperties, startChannelProfile.uri);
            if (startChannelListener == null) continue;
            channel = new Channel(startChannelProfile.uri, string, null, this);
            try {
                String string2 = startChannelProfile.base64Encoding ? "base64" : "none";
                startChannelListener.startChannel(channel, string2, startChannelProfile.data);
            }
            catch (TuningResetException tuningResetException) {
                Log.logEntry(7, CORE, "Leaving profile response to Tuning Profile CCL");
                return true;
            }
            catch (StartChannelException startChannelException) {
                try {
                    ((Message)this.zero.getAppData()).sendERR(startChannelException);
                }
                catch (BEEPException bEEPException) {
                    this.terminate("Error sending ERR response to start channel");
                }
                return false;
            }
            try {
                this.sendProfile(startChannelProfile.uri, channel.getStartData(), channel);
            }
            catch (BEEPException bEEPException) {
                this.terminate("Error sending profile. " + bEEPException.getMessage());
                return false;
            }
            return true;
        }
        try {
            ((Message)this.zero.getAppData()).sendERR(550, ERR_PROFILES_UNAVAILABLE);
        }
        catch (Exception exception) {
            this.terminate("Error sending error. " + exception.getMessage());
        }
        return false;
    }

    private void shutdown() throws BEEPException {
        this.disableIO();
        this.channels.clear();
        this.zeroListener = null;
        this.zero = null;
        this.changeState(8);
        this.fireEvent(6, this);
    }

    private void waitForResult(Channel channel, int n) throws BEEPException, BEEPError {
        Object object;
        int n2 = 0;
        while (channel.getState() == n && n2 < 60000) {
            try {
                object = channel;
                synchronized (object) {
                    channel.wait(100L);
                    n2 += 100;
                }
            }
            catch (InterruptedException interruptedException) {
                n2 += 100;
            }
        }
        if (n2 == 60000) {
            Log.logEntry(7, CORE, "Wait for result timed out");
        }
        if (channel.getState() == 2) {
            return;
        }
        if (channel.getState() == 5) {
            object = channel.getErrorMessage();
            ((Throwable)object).fillInStackTrace();
            throw object;
        }
        if (channel.getState() == 1) {
            throw new BEEPException(ERR_BEEP_START_CHANNEL_TIMEOUT);
        }
    }

    private Element processMessage(Message message) throws BEEPException {
        if (!message.getDataStream().getContentType().equals("application/beep+xml")) {
            throw new BEEPException("Invalid content type for this message");
        }
        Document document = null;
        try {
            document = this.builder.parse(message.getDataStream().getInputStream());
        }
        catch (SAXException sAXException) {
            throw new BEEPException(ERR_MALFORMED_XML_MSG);
        }
        catch (IOException iOException) {
            throw new BEEPException(ERR_MALFORMED_XML_MSG);
        }
        if (document == null) {
            throw new BEEPException(ERR_MALFORMED_XML_MSG);
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new BEEPException(ERR_MALFORMED_XML_MSG);
        }
        return element;
    }

    private void sendGreeting() throws BEEPException {
        Log.logEntry(7, CORE, "sendGreeting");
        byte[] byArray = this.getProfileRegistry().getGreeting(this);
        ByteDataStream byteDataStream = new ByteDataStream("application/beep+xml", byArray);
        MessageMSG messageMSG = new MessageMSG(this.zero, 0, null);
        ((Message)messageMSG).sendRPY(byteDataStream);
    }

    private class CloseReplyListener
    implements ReplyListener {
        Channel channel;

        CloseReplyListener(Channel channel) {
            this.channel = channel;
        }

        public void receiveRPY(Message message) {
            try {
                Element element = Session.this.processMessage(message);
                String string = element.getTagName();
                if (string == null) {
                    throw new BEEPException(Session.ERR_MALFORMED_XML_MSG);
                }
                if (!string.equals(Session.TAG_OK)) {
                    throw new BEEPException(Session.ERR_UNKNOWN_OPERATION_ELEMENT_MSG);
                }
                Log.logEntry(7, Session.CORE, "Received an OK for channel close");
                this.channel.setErrorMessage(null);
                Session.this.receiveCloseChannelResultOk(this.channel);
            }
            catch (BEEPException bEEPException) {
                Session.this.terminate("Problem with RPY: " + bEEPException.getMessage());
            }
        }

        public void receiveERR(Message message) {
            BEEPError bEEPError;
            try {
                bEEPError = BEEPError.convertMessageERRToException(message);
            }
            catch (BEEPException bEEPException) {
                Session.this.terminate(bEEPException.getMessage());
                return;
            }
            Log.logEntry(7, Session.CORE, "Received an error in response to a close. code=" + bEEPError.getCode() + " diagnostic=" + bEEPError.getDiagnostic());
            this.channel.setErrorMessage(bEEPError);
            this.channel.setState(5);
            Session.this.channels.remove(this.channel.getNumberAsString());
            Channel channel = this.channel;
            synchronized (channel) {
                this.channel.notify();
            }
        }

        public void receiveANS(Message message) {
            Session.this.terminate("Received an unexpected ANS");
        }

        public void receiveNUL(Message message) {
            Session.this.terminate("Received an unexpected NUL");
        }
    }

    private class StartReplyListener
    implements ReplyListener {
        Channel channel;
        boolean disableIO;

        StartReplyListener(Channel channel, boolean bl) {
            this.channel = channel;
            this.disableIO = bl;
        }

        public void receiveRPY(Message message) {
            block10: {
                try {
                    Element element;
                    String string;
                    if (this.disableIO) {
                        Session.this.disableIO();
                    }
                    if ((string = (element = Session.this.processMessage(message)).getTagName()) == null) {
                        throw new BEEPException(Session.ERR_MALFORMED_XML_MSG);
                    }
                    if (string.equals(Session.TAG_PROFILE)) {
                        try {
                            String string2 = element.getAttribute(Session.TAG_URI);
                            if (string2 == null) {
                                throw new BEEPException(Session.ERR_MALFORMED_PROFILE_MSG);
                            }
                            String string3 = element.getAttribute(Session.TAG_ENCODING);
                            if (string3 == null) {
                                string3 = "none";
                            }
                            Node node = element.getFirstChild();
                            String string4 = null;
                            if (node != null && (string4 = node.getNodeValue()).length() > 4096) {
                                throw new BEEPException(Session.ERR_PCDATA_TOO_BIG_MSG);
                            }
                            this.channel.setEncoding(string3);
                            this.channel.setProfile(string2);
                            this.channel.setStartData(string4);
                            this.channel.setErrorMessage(null);
                            Session.this.receiveStartChannelResultOk(this.channel, string4);
                            break block10;
                        }
                        catch (Exception exception) {
                            throw new BEEPException(exception.getMessage());
                        }
                    }
                    throw new BEEPException(Session.ERR_UNKNOWN_OPERATION_ELEMENT_MSG);
                }
                catch (BEEPException bEEPException) {
                    Session.this.terminate("Problem with RPY: " + bEEPException.getMessage());
                }
            }
        }

        public void receiveERR(Message message) {
            BEEPError bEEPError;
            try {
                bEEPError = BEEPError.convertMessageERRToException(message);
            }
            catch (BEEPException bEEPException) {
                Session.this.terminate(bEEPException.getMessage());
                return;
            }
            Log.logEntry(3, Session.CORE, "Received an error in response to a start. code=" + bEEPError.getCode() + " diagnostic=" + bEEPError.getDiagnostic());
            this.channel.setErrorMessage(bEEPError);
            this.channel.setState(5);
            Session.this.channels.remove(this.channel.getNumberAsString());
            Channel channel = this.channel;
            synchronized (channel) {
                this.channel.notify();
            }
        }

        public void receiveANS(Message message) {
            Session.this.terminate("Received an unexpected ANS");
        }

        public void receiveNUL(Message message) {
            Session.this.terminate("Received an unexpected NUL");
        }
    }

    private class GreetingListener
    implements ReplyListener {
        private GreetingListener() {
        }

        public void receiveRPY(Message message) {
            try {
                Object object;
                NodeList nodeList;
                Element element = Session.this.processMessage(message);
                String string = element.getTagName();
                if (string == null) {
                    throw new BEEPException(Session.ERR_MALFORMED_XML_MSG);
                }
                if (!string.equals(Session.TAG_GREETING)) {
                    throw new BEEPException(Session.ERR_UNKNOWN_OPERATION_ELEMENT_MSG);
                }
                Log.logEntry(7, Session.CORE, "Received a greeting");
                String string2 = element.getAttribute(Session.TAG_FEATURES);
                String string3 = element.getAttribute(Session.TAG_LOCALIZE);
                if (string3 == null) {
                    string3 = "i-default";
                }
                if ((nodeList = element.getElementsByTagName(Session.TAG_PROFILE)).getLength() > 0) {
                    object = new LinkedList();
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        Element element2 = (Element)nodeList.item(n);
                        String string4 = element2.getAttribute(Session.TAG_URI);
                        if (string4 == null) {
                            throw new BEEPException(Session.ERR_MALFORMED_PROFILE_MSG);
                        }
                        String string5 = element2.getAttribute(Session.TAG_ENCODING);
                        if (string5 != null) {
                            // empty if block
                        }
                        ((LinkedList)object).add(n, element2);
                        ++n;
                    }
                    Session.this.peerSupportedProfiles = (Collection)object;
                }
                Session.this.changeState(4);
                object = this;
                synchronized (object) {
                    this.notifyAll();
                }
            }
            catch (BEEPException bEEPException) {
                Session.this.terminate("Problem with RPY: " + bEEPException.getMessage());
            }
        }

        public void receiveERR(Message message) {
            Session.this.terminate("Received an unexpected ERR");
        }

        public void receiveANS(Message message) {
            Session.this.terminate("Received an unexpected ANS");
        }

        public void receiveNUL(Message message) {
            Session.this.terminate("Received an unexpected NUL");
        }
    }

    private class ChannelZeroListener
    implements MessageListener {
        private ChannelZeroListener() {
        }

        public void receiveMSG(Message message) throws BEEPError, AbortChannelException {
            Element element;
            try {
                element = Session.this.processMessage(message);
            }
            catch (BEEPException bEEPException) {
                throw new BEEPError(500, Session.ERR_MALFORMED_XML_MSG);
            }
            String string = element.getTagName();
            if (string == null) {
                throw new BEEPError(501, Session.ERR_MALFORMED_XML_MSG);
            }
            if (string.equals(Session.TAG_START)) {
                Log.logEntry(7, Session.CORE, "Received a start channel request");
                String string2 = element.getAttribute(Session.TAG_NUMBER);
                if (string2 == null) {
                    throw new BEEPError(501, "Malformed <start>: no channel number");
                }
                String string3 = element.getAttribute(Session.TAG_SERVER_NAME);
                NodeList nodeList = element.getElementsByTagName(Session.TAG_PROFILE);
                if (nodeList == null) {
                    throw new BEEPError(501, "Malformed <start>: no profiles");
                }
                LinkedList<StartChannelProfile> linkedList = new LinkedList<StartChannelProfile>();
                int n = 0;
                while (n < nodeList.getLength()) {
                    boolean bl;
                    Element element2 = (Element)nodeList.item(n);
                    String string4 = element2.getAttribute(Session.TAG_URI);
                    if (string4 == null) {
                        throw new BEEPError(501, "no profiles in start");
                    }
                    String string5 = element2.getAttribute(Session.TAG_ENCODING);
                    if (string5 == null || string5.equals("")) {
                        bl = false;
                    } else if (string5.equalsIgnoreCase("base64")) {
                        bl = true;
                    } else if (string5.equalsIgnoreCase("none")) {
                        bl = false;
                    } else {
                        throw new BEEPError(501, "unkown encoding in start");
                    }
                    String string6 = null;
                    Node node = element2.getFirstChild();
                    if (node != null && (string6 = node.getNodeValue()).length() > 4096) {
                        throw new BEEPError(501, Session.ERR_PCDATA_TOO_BIG_MSG);
                    }
                    linkedList.add(new StartChannelProfile(string4, bl, string6));
                    ++n;
                }
                Session.this.zero.setAppData(message);
                Session.this.processStartChannel(string2, linkedList);
            } else if (string.equals(Session.TAG_CLOSE)) {
                Log.logEntry(7, Session.CORE, "Received a channel close request");
                String string7 = element.getAttribute(Session.TAG_NUMBER);
                if (string7 == null) {
                    throw new BEEPError(501, "Malformed <close>: no channel number");
                }
                String string8 = element.getAttribute(Session.TAG_CODE);
                if (string8 == null) {
                    throw new BEEPError(501, "Malformed <close>: no code attribute");
                }
                String string9 = element.getAttribute(Session.TAG_XML_LANG);
                String string10 = null;
                Node node = element.getFirstChild();
                if (node != null && (string10 = node.getNodeValue()).length() > 4096) {
                    throw new BEEPError(501, Session.ERR_PCDATA_TOO_BIG_MSG);
                }
                Session.this.zero.setAppData(message);
                Session.this.receiveCloseChannel(string7, string8, string9, string10);
            } else {
                throw new BEEPError(501, Session.ERR_UNKNOWN_OPERATION_ELEMENT_MSG);
            }
        }
    }
}

