/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.core;

import java.util.HashSet;
import java.util.LinkedList;
import org.beepcore.beep.core.BEEPError;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.DataListener;
import org.beepcore.beep.core.ProfileRegistry;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.SessionCredential;
import org.beepcore.beep.core.SessionTuningProperties;
import org.beepcore.beep.core.StartChannelProfile;
import org.beepcore.beep.util.Log;

public abstract class TuningProfile {
    private static final String TLS_URI = "http://iana.org/beep/TLS";
    private HashSet tuningChannels = new HashSet();

    public void abort(BEEPError bEEPError, Channel channel) throws BEEPException {
        this.tuningChannels.remove(channel);
        Log.logEntry(7, "TuningProfile.abort");
    }

    public void begin(Channel channel, String string, String string2) throws BEEPException {
        Log.logEntry(7, "TuningProfile.begin");
        Session session = channel.getSession();
        try {
            this.tuningChannels.add(channel);
            session.sendProfile(string, string2, channel);
            session.disableIO();
        }
        catch (Exception exception) {
            BEEPError bEEPError = new BEEPError(451, "UnknownError" + exception.getMessage());
            session.sendProfile(string, bEEPError.createErrorMessage(), channel);
            this.abort(bEEPError, channel);
        }
    }

    public void complete(Channel channel, SessionCredential sessionCredential, SessionCredential sessionCredential2, SessionTuningProperties sessionTuningProperties, ProfileRegistry profileRegistry, Object object) throws BEEPException {
        try {
            Log.logEntry(7, "TuningProfile.complete");
            Session session = channel.getSession();
            session.reset(sessionCredential, sessionCredential2, sessionTuningProperties, profileRegistry, object);
            this.tuningChannels.remove(channel);
        }
        catch (Exception exception) {
            this.abort(new BEEPError(451, "TuningProfile.complete failure\n" + exception.getMessage()), channel);
        }
    }

    protected static void disableIO(Session session) {
        session.disableIO();
    }

    protected static void enableIO(Session session) {
        session.enableIO();
    }

    protected static void setLocalCredential(Session session, SessionCredential sessionCredential) {
        session.setLocalCredential(sessionCredential);
    }

    protected static void setPeerCredential(Session session, SessionCredential sessionCredential) {
        session.setPeerCredential(sessionCredential);
    }

    protected static Session reset(Session session, SessionCredential sessionCredential, SessionCredential sessionCredential2, SessionTuningProperties sessionTuningProperties, ProfileRegistry profileRegistry, Object object) throws BEEPException {
        return session.reset(sessionCredential, sessionCredential2, sessionTuningProperties, profileRegistry, object);
    }

    protected static void sendProfile(Session session, String string, String string2, Channel channel) throws BEEPException {
        session.sendProfile(string, string2, channel);
    }

    public static boolean isTuningProfile(String string) {
        return string.equals(TLS_URI);
    }

    public Channel startChannel(Session session, String string, boolean bl, String string2, DataListener dataListener) throws BEEPException, BEEPError {
        StartChannelProfile startChannelProfile = new StartChannelProfile(string, bl, string2);
        LinkedList<StartChannelProfile> linkedList = new LinkedList<StartChannelProfile>();
        linkedList.add(startChannelProfile);
        return session.startChannel(linkedList, dataListener, true);
    }
}

