/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.lib;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.DataListener;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.lib.SharedChannel;
import org.beepcore.beep.util.Log;

public class ChannelPool {
    private static final long DEFAULT_TIME_TO_LIVE = 120000L;
    private long timeToLive = 120000L;
    Session session;
    LinkedList availableChannels;

    public ChannelPool(Session session) {
        this.session = session;
        this.availableChannels = new LinkedList();
    }

    public ChannelPool(Session session, long l) {
        this.session = session;
        this.timeToLive = l;
        this.availableChannels = new LinkedList();
    }

    public SharedChannel getSharedChannel(String string) throws BEEPException {
        SharedChannel sharedChannel = null;
        boolean bl = false;
        LinkedList linkedList = this.availableChannels;
        synchronized (linkedList) {
            Iterator iterator = this.availableChannels.iterator();
            while (iterator.hasNext()) {
                sharedChannel = (SharedChannel)iterator.next();
                if (!sharedChannel.getProfile().equals(string)) continue;
                Log.logEntry(8, "Found an available channel for sharing");
                iterator.remove();
                bl = true;
                break;
            }
        }
        if (!bl) {
            sharedChannel = new SharedChannel(this.session.startChannel(string, null), this);
        }
        this.garbageCollect();
        Log.logEntry(8, "Sharing channel number:" + sharedChannel.getNumber());
        return sharedChannel;
    }

    public synchronized SharedChannel getSharedChannel(String string, DataListener dataListener) throws BEEPException {
        SharedChannel sharedChannel = null;
        boolean bl = false;
        LinkedList linkedList = this.availableChannels;
        synchronized (linkedList) {
            Iterator iterator = this.availableChannels.iterator();
            while (iterator.hasNext()) {
                sharedChannel = (SharedChannel)iterator.next();
                if (!sharedChannel.getProfile().equals(string)) continue;
                Log.logEntry(8, "Found an available channel for sharing");
                iterator.remove();
                bl = true;
                break;
            }
        }
        if (!bl) {
            sharedChannel = new SharedChannel(this.session.startChannel(string, dataListener), this);
        }
        this.garbageCollect();
        Log.logEntry(8, "Sharing channel number:" + sharedChannel.getNumber());
        return sharedChannel;
    }

    void releaseSharedChannel(SharedChannel sharedChannel) {
        LinkedList linkedList = this.availableChannels;
        synchronized (linkedList) {
            this.availableChannels.add(sharedChannel);
        }
        this.garbageCollect();
    }

    public void setSharedChannelTTL(long l) {
        this.timeToLive = l;
    }

    public void close() {
        try {
            this.session.close();
        }
        catch (BEEPException bEEPException) {
            bEEPException.printStackTrace();
        }
    }

    private void garbageCollect() {
        Log.logEntry(8, "garbage collecting");
        if (this.availableChannels.size() != 0) {
            Date date = new Date();
            long l = date.getTime() - this.timeToLive;
            LinkedList linkedList = this.availableChannels;
            synchronized (linkedList) {
                while (this.availableChannels.size() > 0) {
                    if (l <= ((SharedChannel)this.availableChannels.get(0)).getTTL()) break;
                    SharedChannel sharedChannel = (SharedChannel)this.availableChannels.remove(0);
                    try {
                        Log.logEntry(8, "garbage collected channel number:" + sharedChannel.getNumber());
                        sharedChannel.close();
                    }
                    catch (BEEPException bEEPException) {
                        Log.logEntry(1, "unable to close channel number:" + sharedChannel.getNumber());
                    }
                    sharedChannel = null;
                }
            }
        }
    }
}

