/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.lib;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.beepcore.beep.core.BEEPInterruptedException;
import org.beepcore.beep.core.Message;
import org.beepcore.beep.core.ReplyListener;

public class Reply
implements ReplyListener {
    private static final int DEFAULT_ARRAY_LIST_SIZE = 4;
    private boolean complete = false;
    private LinkedList replies = new LinkedList();

    public synchronized Message getNextReply() throws BEEPInterruptedException {
        Message message;
        if (this.complete) {
            throw new NoSuchElementException();
        }
        if (this.replies.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new BEEPInterruptedException(interruptedException.getMessage());
            }
        }
        if ((message = (Message)this.replies.removeFirst()).getMessageType() != 4) {
            this.complete = true;
        }
        return message;
    }

    public synchronized boolean hasNext() throws BEEPInterruptedException {
        if (this.replies.size() != 0) {
            return true;
        }
        if (this.complete) {
            return false;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            throw new BEEPInterruptedException(interruptedException.getMessage());
        }
        return !this.complete;
    }

    private synchronized void setMessage(Message message) {
        this.replies.add(message);
        this.notify();
    }

    public void receiveRPY(Message message) {
        this.setMessage(message);
    }

    public void receiveERR(Message message) {
        this.setMessage(message);
    }

    public void receiveANS(Message message) {
        this.setMessage(message);
    }

    public synchronized void receiveNUL(Message message) {
        this.complete = true;
        this.notify();
    }
}

