/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.lib;

import java.util.Date;
import org.beepcore.beep.core.BEEPError;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.DataListener;
import org.beepcore.beep.core.DataStream;
import org.beepcore.beep.core.MessageStatus;
import org.beepcore.beep.core.ReplyListener;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.lib.ChannelPool;
import org.beepcore.beep.lib.Reply;

public class SharedChannel
extends Channel {
    private Channel channel = null;
    private ChannelPool pool = null;
    private long timeStamp = -1L;

    SharedChannel(Channel channel, ChannelPool channelPool) {
        super(channel.getProfile(), String.valueOf(channel.getNumber()), channel.getDataListener(), channel.getSession());
        this.channel = channel;
        this.pool = channelPool;
    }

    public void release() {
        Date date = new Date();
        this.timeStamp = date.getTime();
        this.pool.releaseSharedChannel(this);
    }

    long getTTL() {
        return this.timeStamp;
    }

    public MessageStatus sendANS(DataStream dataStream) throws BEEPException {
        return this.channel.sendANS(dataStream);
    }

    public MessageStatus sendMSG(DataStream dataStream, ReplyListener replyListener) throws BEEPException {
        return this.channel.sendMSG(dataStream, replyListener);
    }

    public MessageStatus sendNUL() throws BEEPException {
        return this.channel.sendNUL();
    }

    public MessageStatus sendRPY(DataStream dataStream) throws BEEPException {
        return this.channel.sendRPY(dataStream);
    }

    public MessageStatus sendERR(BEEPError bEEPError) throws BEEPException {
        return this.channel.sendERR(bEEPError);
    }

    public MessageStatus sendERR(int n, String string) throws BEEPException {
        return this.channel.sendERR(n, string);
    }

    public MessageStatus sendERR(int n, String string, String string2) throws BEEPException {
        return this.channel.sendERR(n, string, string2);
    }

    public void setDataListener(DataListener dataListener) {
        this.channel.setDataListener(dataListener);
    }

    public void setReceiveBufferSize(int n) throws BEEPException {
        this.channel.setReceiveBufferSize(n);
    }

    public int getBufferSize() {
        return this.channel.getBufferSize();
    }

    public int getBufferUsed() {
        return this.channel.getBufferUsed();
    }

    public DataListener getDataListener() {
        return this.channel.getDataListener();
    }

    public boolean getNotifyMessageListenerOnFirstFrame() {
        return this.channel.getNotifyMessageListenerOnFirstFrame();
    }

    public int getNumber() {
        return this.channel.getNumber();
    }

    public Session getSession() {
        return this.channel.getSession();
    }

    public void setNotifyMessageListenerOnFirstFrame(boolean bl) {
        this.channel.setNotifyMessageListenerOnFirstFrame(bl);
    }

    public String getProfile() {
        return this.channel.getProfile();
    }

    public void close() throws BEEPException {
        this.channel.close();
    }

    public Reply sendRequest(DataStream dataStream) throws BEEPException {
        Reply reply = new Reply();
        this.channel.sendMSG(dataStream, reply);
        return reply;
    }
}

