/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.echo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.beepcore.beep.core.BEEPError;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.ByteDataStream;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.CloseChannelException;
import org.beepcore.beep.core.DataStream;
import org.beepcore.beep.core.Message;
import org.beepcore.beep.core.MessageListener;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.StartChannelException;
import org.beepcore.beep.core.StartChannelListener;
import org.beepcore.beep.lib.MessageQueue;
import org.beepcore.beep.profile.Profile;
import org.beepcore.beep.profile.ProfileConfiguration;
import org.beepcore.beep.util.Log;

public class EchoProfile
implements Profile,
StartChannelListener,
MessageListener {
    public static final String ECHO_URI = "http://xml.resource.org/profiles/NULL/ECHO";
    private MessageQueue messages = new MessageQueue();

    public StartChannelListener init(String string, ProfileConfiguration profileConfiguration) throws BEEPException {
        return this;
    }

    public void startChannel(Channel channel, String string, String string2) throws StartChannelException {
        Log.logEntry(7, "EchoCCL StartChannel Callback");
        channel.setDataListener(this);
    }

    public void closeChannel(Channel channel) throws CloseChannelException {
        Log.logEntry(7, "EchoCCL CloseChannel Callback");
        channel.setDataListener(null);
        channel.setAppData(null);
    }

    public boolean advertiseProfile(Session session) {
        return true;
    }

    public void receiveMSG(Message message) throws BEEPError {
        new ReplyThread(message).start();
    }

    private class ReplyThread
    extends Thread {
        private Message message;

        ReplyThread(Message message) {
            this.message = message;
        }

        public void run() {
            byte[] byArray = new byte[4096];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataStream dataStream = this.message.getDataStream();
            InputStream inputStream = dataStream.getInputStream();
            try {
                int n;
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                this.message.getChannel().getSession().terminate(iOException.getMessage());
                return;
            }
            try {
                this.message.sendRPY(new ByteDataStream(byteArrayOutputStream.toByteArray()));
            }
            catch (BEEPException bEEPException) {
                try {
                    this.message.sendERR(451, "Error sending RPY");
                }
                catch (BEEPException bEEPException2) {
                    this.message.getChannel().getSession().terminate(bEEPException2.getMessage());
                }
                return;
            }
        }
    }
}

