/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.tls;

import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.StartChannelListener;
import org.beepcore.beep.core.TuningProfile;
import org.beepcore.beep.profile.Profile;
import org.beepcore.beep.profile.ProfileConfiguration;
import org.beepcore.beep.transport.tcp.TCPSession;

public abstract class TLSProfile
extends TuningProfile
implements Profile {
    public static final String URI = "http://iana.org/beep/TLS";
    public static final String[] providers = new String[]{"TLSProfilePureTLS", "TLSProfileJSSE"};

    public abstract StartChannelListener init(String var1, ProfileConfiguration var2) throws BEEPException;

    public abstract TCPSession startTLS(TCPSession var1) throws BEEPException;

    public static TLSProfile getDefaultInstance() throws BEEPException {
        return TLSProfile.getInstance("org.beepcore.beep.profile.tls.ptls.TLSProfilePureTLS");
    }

    public static TLSProfile getInstance(String string) throws BEEPException {
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Class<?> clazz = classLoader.loadClass(string);
            return (TLSProfile)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BEEPException("Provider '" + string + "' not found.");
        }
        catch (Exception exception) {
            throw new BEEPException(exception.getMessage());
        }
    }
}

