/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.transport.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.ProfileRegistry;
import org.beepcore.beep.transport.tcp.TCPSession;
import org.beepcore.beep.transport.tcp.TCPSessionCreator;

public class AutomatedTCPSessionCreator {
    public static final int DEFAULT_TABLE_SIZE = 4;
    public static final int DEFAULT_BACKLOG_SIZE = 100;
    private static final String ERR_TCP_SOCKET_FAILURE = "Unable to create a TCP socket";
    private static final String ERR_BIND_FAILURE = "Bind Failed";
    private static final String ERR_CONNECT_FAILURE = "Connect Failed";
    private static final String ERR_LISTEN_FAILURE = "Accept Failed";
    protected static Hashtable listenerSockets = null;

    public static TCPSession initiate(InetAddress inetAddress, int n, ProfileRegistry profileRegistry) throws BEEPException {
        Socket socket;
        try {
            socket = new Socket(inetAddress, n);
        }
        catch (IOException iOException) {
            throw new BEEPException(iOException.getMessage());
        }
        if (socket == null) {
            throw new BEEPException(ERR_TCP_SOCKET_FAILURE);
        }
        TCPSession tCPSession = TCPSessionCreator.initiate(socket, profileRegistry);
        return tCPSession;
    }

    public static TCPSession initiate(String string, int n, ProfileRegistry profileRegistry) throws BEEPException {
        try {
            return AutomatedTCPSessionCreator.initiate(InetAddress.getByName(string), n, profileRegistry);
        }
        catch (UnknownHostException unknownHostException) {
            throw new BEEPException("Unable to connect, unkown host");
        }
    }

    public static TCPSession listen(int n, ProfileRegistry profileRegistry) throws BEEPException {
        InetAddress inetAddress = null;
        return AutomatedTCPSessionCreator.listen(inetAddress, n, profileRegistry);
    }

    public static TCPSession listen(InetAddress inetAddress, int n, ProfileRegistry profileRegistry) throws BEEPException {
        ServerSocket serverSocket = null;
        Socket socket = null;
        if (listenerSockets == null) {
            listenerSockets = new Hashtable(4);
        }
        if ((serverSocket = (ServerSocket)listenerSockets.get(Integer.toString(n))) == null) {
            try {
                serverSocket = inetAddress == null ? new ServerSocket(n, 100) : new ServerSocket(n, 100, inetAddress);
                listenerSockets.put(Integer.toString(n), serverSocket);
            }
            catch (Exception exception) {
                throw new BEEPException(exception.getMessage());
            }
        }
        try {
            socket = serverSocket.accept();
            return TCPSessionCreator.listen(socket, profileRegistry);
        }
        catch (Exception exception) {
            throw new BEEPException(exception.getMessage());
        }
    }

    public static TCPSession listen(String string, int n, ProfileRegistry profileRegistry) throws BEEPException {
        try {
            TCPSession tCPSession = null;
            InetAddress inetAddress = null;
            if (string != null) {
                inetAddress = InetAddress.getByName(string);
            }
            tCPSession = AutomatedTCPSessionCreator.listen(inetAddress, n, profileRegistry);
            return tCPSession;
        }
        catch (UnknownHostException unknownHostException) {
            throw new BEEPException(unknownHostException.getMessage());
        }
    }
}

