/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.transport.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.Frame;
import org.beepcore.beep.core.ProfileRegistry;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.SessionCredential;
import org.beepcore.beep.core.SessionTuningProperties;
import org.beepcore.beep.transport.tcp.TCPSessionCreator;
import org.beepcore.beep.util.Log;

public class TCPSession
extends Session {
    private static final String ERR_SEND_FRAME_FAILED = "Unable to send a frame";
    private static final String ERR_TCP_BUFFER_TOO_LARGE = "";
    private static final String SEQ_PREFIX = "SEQ ";
    private static final char NEWLINE_CHAR = '\n';
    private static final int DEFAULT_PROPERTIES_SIZE = 4;
    private static final int DEFAULT_RECEIVE_BUFFER_SIZE = 4096;
    private static final int MAX_RECEIVE_BUFFER_SIZE = 65536;
    private static final int MIN_RECEIVE_BUFFER_SIZE = 4096;
    private static final int SEQ_LENGTH = "SEQ ".length();
    private static final String TCP_MAPPING = "TCP Mapping";
    private static final String CRLF = "\r\n";
    private byte[] headerBuffer = new byte[62];
    private Object writerLock;
    private Socket socket;
    private boolean running;
    private static int THREAD_COUNT = 0;
    private static final String THREAD_NAME = "TCPSession Thread #";
    private Thread thread;

    TCPSession(Socket socket, ProfileRegistry profileRegistry, int n, SessionCredential sessionCredential, SessionCredential sessionCredential2, SessionTuningProperties sessionTuningProperties) throws BEEPException {
        super(profileRegistry, n, sessionCredential, sessionCredential2, sessionTuningProperties);
        this.socket = socket;
        this.writerLock = new Object();
        if (sessionCredential2 != null || sessionCredential != null || sessionTuningProperties != null) {
            this.tuningInit();
        } else {
            this.init();
        }
        try {
            this.socket.setReceiveBufferSize(65536);
        }
        catch (Exception exception) {
            Log.logEntry(3, "Socket doesn't support setting receive buffer size");
        }
    }

    public synchronized void close() throws BEEPException {
        super.close();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void terminate(String string) {
        super.terminate(string);
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    protected void disableIO() {
        this.running = false;
    }

    protected void enableIO() {
        this.running = false;
        this.thread = null;
        if (this.thread == null) {
            String string;
            String string2 = THREAD_NAME;
            synchronized (string2) {
                string = new String(THREAD_NAME + THREAD_COUNT++);
            }
            this.thread = new Thread((Runnable)new SessionThread(), string);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    protected int getMaxFrameSize() {
        return 1400;
    }

    protected void sendFrame(Frame frame) throws BEEPException {
        try {
            OutputStream outputStream = this.socket.getOutputStream();
            Object var3_4 = null;
            Object object = this.writerLock;
            synchronized (object) {
                if (Log.isLogged(8)) {
                    Log.logEntry(8, TCP_MAPPING, "Wrote the following\n");
                }
                Iterator iterator = frame.getBytes();
                while (iterator.hasNext()) {
                    Frame.BufferSegment bufferSegment = (Frame.BufferSegment)iterator.next();
                    outputStream.write(bufferSegment.data, bufferSegment.offset, bufferSegment.length);
                    if (!Log.isLogged(8)) continue;
                    Log.logEntry(8, TCP_MAPPING, new String(bufferSegment.data, bufferSegment.offset, bufferSegment.length));
                }
                outputStream.flush();
            }
        }
        catch (IOException iOException) {
            throw new BEEPException(iOException.toString());
        }
        catch (Exception exception) {
            throw new BEEPException(exception.toString());
        }
    }

    protected Session reset(SessionCredential sessionCredential, SessionCredential sessionCredential2, SessionTuningProperties sessionTuningProperties, ProfileRegistry profileRegistry, Object object) throws BEEPException {
        Log.logEntry(7, TCP_MAPPING, "Reset as " + (this.isInitiator() ? "INITIATOR" : "LISTENER"));
        Socket socket = null;
        try {
            socket = (Socket)object;
        }
        catch (ClassCastException classCastException) {
            socket = this.socket;
        }
        if (profileRegistry == null) {
            profileRegistry = this.getProfileRegistry();
        }
        if (this.isInitiator()) {
            return TCPSessionCreator.initiate(socket, profileRegistry, sessionCredential, sessionCredential2, sessionTuningProperties);
        }
        return TCPSessionCreator.listen(socket, profileRegistry, sessionCredential, sessionCredential2, sessionTuningProperties);
    }

    protected boolean updateMyReceiveBufferSize(Channel channel, long l, long l2, int n, int n2, int n3) throws BEEPException {
        if (Log.isLogged(7)) {
            Log.logEntry(7, TCP_MAPPING, "update SEQ channel=" + channel.getNumber() + " prevSeq=" + l + " curSeq=" + l2 + " prevUsed=" + n + " curUsed=" + n2 + " bufSize=" + n3);
        }
        if (l2 > 0L && (l2 - l < (long)(n3 / 2) || n2 > n3 / 2)) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(62);
        stringBuffer.append(SEQ_PREFIX);
        stringBuffer.append(this.getChannelNumberAsString(channel));
        stringBuffer.append(' ');
        stringBuffer.append(Long.toString(l2));
        stringBuffer.append(' ');
        stringBuffer.append(Integer.toString(n3 - n2));
        stringBuffer.append(CRLF);
        try {
            if (Log.isLogged(7)) {
                Log.logEntry(7, TCP_MAPPING, "Wrote: " + stringBuffer.toString());
            }
            OutputStream outputStream = this.socket.getOutputStream();
            Object object = this.writerLock;
            synchronized (object) {
                outputStream.write(stringBuffer.toString().getBytes("UTF-8"));
                outputStream.flush();
            }
        }
        catch (IOException iOException) {
            throw new BEEPException("Unable to send SEQ" + iOException.getMessage());
        }
        return true;
    }

    private boolean modState(int n) throws BEEPException {
        return super.changeState(n);
    }

    private void processNextFrame() throws BEEPException, IOException, SessionAbortedException {
        InputStream inputStream;
        int n;
        block17: {
            if (Log.isLogged(8)) {
                Log.logEntry(8, TCP_MAPPING, "Processing next frame");
            }
            n = 0;
            inputStream = this.socket.getInputStream();
            this.headerBuffer[TCPSession.SEQ_LENGTH] = 0;
            do {
                try {
                    int n2 = inputStream.read();
                    if (n2 == -1) {
                        throw new SessionAbortedException();
                    }
                    this.headerBuffer[n] = (byte)n2;
                }
                catch (SocketException socketException) {
                    if (this.getState() == 7) {
                        throw socketException;
                    }
                    return;
                }
                if (this.headerBuffer[n] != 10) continue;
                if (n == 0 || this.headerBuffer[n - 1] != 13) {
                    throw new BEEPException("Malformed BEEP header");
                }
                break block17;
            } while (++n != 62);
            throw new BEEPException("Malformed BEEP header, no CRLF");
        }
        if (Log.isLogged(7)) {
            Log.logEntry(7, TCP_MAPPING, "Processing: " + new String(this.headerBuffer, 0, n));
        }
        if (this.headerBuffer[0] != (byte)SEQ_PREFIX.charAt(0)) {
            int n3;
            Frame frame = super.createFrame(this.headerBuffer, n);
            byte[] byArray = new byte[frame.getSize()];
            int n4 = 0;
            while (n4 < byArray.length) {
                n3 = inputStream.read(byArray, n4, byArray.length - n4);
                if (n3 == -1) {
                    throw new SessionAbortedException();
                }
                n4 += n3;
            }
            if (Log.isLogged(8)) {
                Log.logEntry(8, TCP_MAPPING, new String(byArray));
            }
            n3 = 0;
            while (n3 < "END\r\n".length()) {
                int n5 = inputStream.read();
                if (n5 == -1) {
                    throw new SessionAbortedException();
                }
                if ((byte)n5 != (byte)"END\r\n".charAt(n3)) {
                    throw new BEEPException("Malformed BEEP frame, invalid trailer");
                }
                ++n3;
            }
            frame.addPayload(new Frame.BufferSegment(byArray));
            super.postFrame(frame);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(new String(this.headerBuffer, 0, n));
        if (stringTokenizer.countTokens() != 4) {
            Log.logEntry(3, TCP_MAPPING, "Malformed BEEP header");
            throw new BEEPException("Malformed BEEP header");
        }
        if (!stringTokenizer.nextToken().equals("SEQ")) {
            throw new BEEPException("Malformed BEEP header");
        }
        int n6 = Integer.parseInt(stringTokenizer.nextToken());
        long l = Long.parseLong(stringTokenizer.nextToken());
        int n7 = Integer.parseInt(stringTokenizer.nextToken());
        this.updatePeerReceiveBufferSize(n6, l, n7);
    }

    private static class SessionAbortedException
    extends Exception {
        private SessionAbortedException() {
        }
    }

    private class SessionThread
    implements Runnable {
        private SessionThread() {
        }

        public void run() {
            try {
                TCPSession.this.running = true;
                while (TCPSession.this.getState() != 7 && TCPSession.this.running) {
                    TCPSession.this.processNextFrame();
                }
                while (TCPSession.this.getState() == 7 && TCPSession.this.running) {
                    TCPSession.this.processNextFrame();
                }
            }
            catch (IOException iOException) {
                Log.logEntry(3, TCPSession.TCP_MAPPING, iOException);
                TCPSession.this.socket = null;
                TCPSession.this.terminate(iOException.getMessage());
            }
            catch (SessionAbortedException sessionAbortedException) {
                TCPSession.this.terminate("Session aborted by remote peer.");
            }
            catch (Throwable throwable) {
                Log.logEntry(3, TCPSession.TCP_MAPPING, throwable);
                TCPSession.this.terminate(throwable.getMessage());
            }
            Log.logEntry(7, TCPSession.TCP_MAPPING, "Session listener thread exiting.  State = " + TCPSession.this.getState());
        }
    }
}

