/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.beepcore.beep.util.LogService;

public class Log {
    public static final int SEV_EMERGENCY = 0;
    public static final int SEV_ALERT = 1;
    public static final int SEV_CRITICAL = 2;
    public static final int SEV_ERROR = 3;
    public static final int SEV_WARNING = 4;
    public static final int SEV_NOTICE = 5;
    public static final int SEV_INFORMATIONAL = 6;
    public static final int SEV_DEBUG = 7;
    public static final int SEV_DEBUG_VERBOSE = 8;
    private static LogService log = new NullLog();

    public static boolean isLogged(int n) {
        return log.isLogged(n);
    }

    public static void logEntry(int n, String string) {
        if (!log.isLogged(n)) {
            return;
        }
        log.logEntry(n, Log.getClassName(), string);
    }

    public static void logEntry(int n, Throwable throwable) {
        if (!log.isLogged(n)) {
            return;
        }
        log.logEntry(n, Log.getClassName(), throwable);
    }

    public static void logEntry(int n, String string, String string2) {
        if (!log.isLogged(n)) {
            return;
        }
        log.logEntry(n, string, string2);
    }

    public static void logEntry(int n, String string, Throwable throwable) {
        if (!log.isLogged(n)) {
            return;
        }
        log.logEntry(n, string, throwable);
    }

    public static void setLogService(LogService logService) {
        log = logService;
    }

    private static String parse(String string) {
        int n = string.indexOf("logEntry");
        if (n != -1) {
            n = string.indexOf("at", n);
            String string2 = string.substring(n + 3, string.indexOf("(", n + 3));
            return string2;
        }
        return "";
    }

    private static String getClassName() {
        Exception exception = new Exception();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        exception.printStackTrace(printWriter);
        return Log.parse(byteArrayOutputStream.toString());
    }

    private static class NullLog
    implements LogService {
        private NullLog() {
        }

        public void logEntry(int n, String string, String string2) {
        }

        public void logEntry(int n, String string, Throwable throwable) {
        }

        public boolean isLogged(int n) {
            return false;
        }
    }
}

