/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.key;

import cryptix.util.core.ArrayUtil;
import java.security.Key;

public class RawKey
implements Key {
    private static final String FORMAT = "RAW";
    private String algorithm;
    private byte[] data;

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.data.length) {
            n ^= this.data[n2];
            n2 += 4;
        }
        n <<= 8;
        n2 = 1;
        while (n2 < this.data.length) {
            n ^= this.data[n2];
            n2 += 4;
        }
        n <<= 8;
        n2 = 2;
        while (n2 < this.data.length) {
            n ^= this.data[n2];
            n2 += 4;
        }
        n <<= 8;
        n2 = 3;
        while (n2 < this.data.length) {
            n ^= this.data[n2];
            n2 += 4;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof RawKey) {
            return ArrayUtil.areEqual(this.data, ((RawKey)object).data);
        }
        return false;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return FORMAT;
    }

    public byte[] getEncoded() {
        return (byte[])this.data.clone();
    }

    public RawKey(String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.algorithm = string;
        this.data = (byte[])byArray.clone();
    }

    public RawKey(String string, byte[] byArray, int n, int n2) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.algorithm = string;
        this.data = new byte[n2];
        System.arraycopy(byArray, n, this.data, 0, n2);
    }
}

