/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.test;

import cryptix.util.test.TestException;
import cryptix.util.test.TestGUI;
import java.applet.Applet;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class BaseTest
extends Applet {
    private static final String SEPARATOR = "\n===========================================================================";
    private static PrintWriter defaultOutput = new PrintWriter(System.out, true);
    protected PrintWriter status;
    protected PrintWriter out;
    private String name = this.getClass().getName();
    private StringWriter sw;
    private int failures;
    private int errors;
    private int passes;
    private int skipped;
    private int expectedPasses;
    private boolean overallPass;
    private boolean verbose;
    private boolean commandLine;
    private TestGUI gui;

    public synchronized void init() {
        this.initGui();
        try {
            this.test();
        }
        catch (TestException testException) {
            testException.printStackTrace(this.status);
        }
    }

    private void initGui() {
        this.gui = new TestGUI(this);
        this.add(this.gui);
        this.setOutput(this.gui.getOutput());
    }

    public synchronized void setGuiEnabled(boolean bl) {
        if (bl && this.gui == null) {
            this.initGui();
            if (this.commandLine) {
                this.gui.useAppFrame(true);
            }
        } else if (!bl && this.gui != null) {
            if (this.commandLine) {
                this.gui.useAppFrame(false);
            }
            this.setOutput(defaultOutput);
            this.gui = null;
        }
    }

    public boolean isGuiEnabled() {
        return this.gui != null;
    }

    public synchronized void waitForExit() {
        if (this.gui != null) {
            this.gui.waitForExit();
        }
    }

    protected void commandline(String[] stringArray) {
        this.commandline(stringArray, 0);
    }

    protected void commandline(String[] stringArray, int n) {
        this.commandLine = true;
        try {
            this.parseOptions(stringArray, n);
            this.test();
            this.waitForExit();
            System.exit(10);
        }
        catch (TestException testException) {
            this.status.println(testException.getMessage());
            this.waitForExit();
            System.exit(testException.getErrorCode());
        }
    }

    protected void parseOption(String string) throws TestException {
        if (string.equalsIgnoreCase("-verbose")) {
            this.setVerbose(true);
        } else if (string.equalsIgnoreCase("-gui")) {
            this.setGuiEnabled(true);
        } else {
            System.err.println(this.describeUsage());
            throw new TestException("Unrecognised option: '" + string + "'", 2);
        }
    }

    public void parseOptions(String[] stringArray, int n) throws TestException {
        int n2 = n;
        while (n2 < stringArray.length) {
            this.parseOption(stringArray[n2]);
            ++n2;
        }
    }

    public String describeUsage() {
        return "Usage:\n" + "    java " + this.getClass().getName() + " [options...]\n" + this.describeOptions();
    }

    public String describeOptions() {
        return "Options:\n" + "    -verbose: print output even if all tests pass.\n";
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setOutput(PrintWriter printWriter) {
        this.status = printWriter;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test() throws TestException {
        String string;
        if (this.verbose) {
            this.sw = null;
            this.out = this.status;
        } else {
            this.sw = new StringWriter();
            this.out = new PrintWriter(this.sw);
        }
        try {
            try {
                this.expectedPasses = 0;
                this.skipped = 0;
                this.passes = 0;
                this.errors = 0;
                this.failures = 0;
                this.overallPass = false;
                this.status.print("Running tests for " + this.getName());
                if (this.verbose) {
                    this.status.println();
                } else {
                    this.status.flush();
                }
                this.engineTest();
            }
            catch (Throwable throwable) {
                String string5;
                this.error(throwable);
                Object var2_2 = null;
                String string2 = string5 = this.skipped > 0 ? " and skipped tests" : "";
                if (this.passes + this.skipped < this.expectedPasses) {
                    this.error("Number of passes" + string5 + " is less than expected");
                } else if (this.passes < 1) {
                    this.error("At least one pass is required");
                } else if (this.expectedPasses > 0 && this.expectedPasses < this.passes + this.skipped) {
                    this.error("Number of passes" + string5 + " is more than expected\n" + "(therefore the expected number is wrong)");
                }
                this.report();
                if (this.failures <= 0 && this.errors <= 0) {
                    this.overallPass = true;
                    return;
                }
                if (this.passes != 0) throw new TestException(this.getName() + " failed partially", 4);
                throw new TestException(this.getName() + " failed completely", 1);
            }
            Object var2_1 = null;
            string = this.skipped > 0 ? " and skipped tests" : "";
        }
        catch (Throwable throwable) {
            String string3;
            Object var2_3 = null;
            String string4 = string3 = this.skipped > 0 ? " and skipped tests" : "";
            if (this.passes + this.skipped < this.expectedPasses) {
                this.error("Number of passes" + string3 + " is less than expected");
            } else if (this.passes < 1) {
                this.error("At least one pass is required");
            } else if (this.expectedPasses > 0 && this.expectedPasses < this.passes + this.skipped) {
                this.error("Number of passes" + string3 + " is more than expected\n" + "(therefore the expected number is wrong)");
            }
            this.report();
            if (this.failures <= 0 && this.errors <= 0) {
                this.overallPass = true;
                throw throwable;
            }
            if (this.passes != 0) throw new TestException(this.getName() + " failed partially", 4);
            throw new TestException(this.getName() + " failed completely", 1);
        }
        String string5 = string;
        if (this.passes + this.skipped < this.expectedPasses) {
            this.error("Number of passes" + string5 + " is less than expected");
        } else if (this.passes < 1) {
            this.error("At least one pass is required");
        } else if (this.expectedPasses > 0 && this.expectedPasses < this.passes + this.skipped) {
            this.error("Number of passes" + string5 + " is more than expected\n" + "(therefore the expected number is wrong)");
        }
        this.report();
        if (this.failures > 0 || this.errors > 0) {
            if (this.passes != 0) throw new TestException(this.getName() + " failed partially", 4);
            throw new TestException(this.getName() + " failed completely", 1);
        }
        this.overallPass = true;
    }

    protected void fail(String string) {
        ++this.failures;
        this.out.println("\nFailed: " + string);
        if (this.sw != null) {
            this.switchStream();
        }
    }

    protected void error(String string) {
        ++this.errors;
        this.out.println("\nError: " + string);
        if (this.sw != null) {
            this.switchStream();
        }
    }

    protected void skip(String string) {
        ++this.skipped;
        this.out.println("\nTest skipped: " + string);
        if (this.sw != null) {
            this.switchStream();
        }
    }

    private void switchStream() {
        this.out.flush();
        this.out = this.status;
        this.out.println();
        this.out.print(this.sw.getBuffer());
        this.out.flush();
        this.sw = null;
    }

    protected void error(Exception exception) {
        this.error("Exception Unexpected " + exception.getClass().getName());
        exception.printStackTrace(this.out);
    }

    protected void error(Throwable throwable) {
        this.error("Throwable Unexpected " + throwable.getClass().getName());
        throwable.printStackTrace(this.out);
    }

    protected void pass(String string) {
        ++this.passes;
        this.out.println("\nPassed: " + string);
        if (this.sw != null) {
            this.status.print(".");
            this.status.flush();
        }
    }

    protected void passIf(boolean bl, String string) {
        if (bl) {
            this.pass(string);
        } else {
            this.fail(string);
        }
    }

    protected void setExpectedPasses(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        this.expectedPasses = n;
    }

    protected void report() {
        this.status.println(SEPARATOR);
        this.status.println("Number of passes:        " + this.passes);
        this.status.println("Number of failures:      " + this.failures);
        if (this.errors > 0) {
            this.status.println("Number of errors:        " + this.errors);
        }
        if (this.skipped > 0) {
            this.status.println("Number of skipped tests: " + this.skipped);
        }
        this.status.println("Expected passes:         " + (this.expectedPasses > 0 ? Integer.toString(this.expectedPasses) : "unknown"));
    }

    public int getFailures() {
        return this.failures;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getPasses() {
        return this.passes;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public int getExpectedPasses() {
        return this.expectedPasses;
    }

    public boolean isOverallPass() {
        return this.overallPass;
    }

    protected abstract void engineTest() throws Exception;

    protected BaseTest() {
        this.status = defaultOutput;
    }
}

