/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.DERUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class EAYDHParams {
    private BigInteger g;
    private BigInteger p;

    public EAYDHParams(BigInteger bigInteger, BigInteger bigInteger2) {
        this.p = bigInteger2;
        this.g = bigInteger;
    }

    public EAYDHParams(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray2 = DERUtils.decodeSequence(byteArrayInputStream);
        byteArrayInputStream = new ByteArrayInputStream(byArray2);
        this.p = DERUtils.decodeInteger(byteArrayInputStream);
        this.g = DERUtils.decodeInteger(byteArrayInputStream);
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getP() {
        return this.p;
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            DERUtils.encodeInteger(this.p, byteArrayOutputStream);
            DERUtils.encodeInteger(this.g, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            DERUtils.encodeSequence(byArray, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }
}

