/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.ptls.SSLDebug;
import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ParserVisitor;
import cryptix.provider.rsa.BaseRSAPrivateKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

class X509RSAPrivateKey
extends BaseRSAPrivateKey {
    private byte[] encoding;

    public X509RSAPrivateKey(String string, byte[] byArray, byte[] byArray2) throws IOException {
        SSLDebug.debug(8, "RSA Private key encoding", byArray2);
        CoderOperations coderOperations = BaseCoder.getInstance((String)"DER");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        coderOperations.init((InputStream)byteArrayInputStream);
        ASNObject aSNObject = CertContext.getSpec().getComponent("RSAPrivateKey");
        aSNObject.accept((ParserVisitor)coderOperations, null);
        BigInteger bigInteger = (BigInteger)aSNObject.getComponent("RSAPrivateKey.privateExponent").getValue();
        BigInteger bigInteger2 = (BigInteger)aSNObject.getComponent("RSAPrivateKey.prime1").getValue();
        BigInteger bigInteger3 = (BigInteger)aSNObject.getComponent("RSAPrivateKey.prime2").getValue();
        BigInteger bigInteger4 = (BigInteger)aSNObject.getComponent("RSAPrivateKey.coefficient").getValue();
        this.setRsaParams(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public byte[] getEncoded() {
        return this.encoding;
    }

    public String getFormat() {
        return "X509";
    }
}

