/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.cert.DERUtils;
import COM.claymoresystems.cert.X509DSAPublicKey;
import COM.claymoresystems.cert.X509RSAPublicKey;
import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ParserVisitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.Hashtable;

public class X509SubjectPublicKeyInfo {
    static Hashtable algorithmMap = new Hashtable();

    public static PublicKey createPublicKey(byte[] byArray) throws IOException {
        CoderOperations coderOperations = BaseCoder.getInstance((String)"DER");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        coderOperations.init((InputStream)byteArrayInputStream);
        ASNObject aSNObject = CertContext.getSpec().getComponent("SubjectPublicKeyInfo");
        aSNObject.accept((ParserVisitor)coderOperations, null);
        ASNObject aSNObject2 = aSNObject.getComponent("SubjectPublicKeyInfo.algorithm");
        ASNObject aSNObject3 = aSNObject2.getComponent("AlgorithmIdentifier.parameters");
        aSNObject2 = aSNObject2.getComponent("AlgorithmIdentifier.algorithm");
        String string = (String)aSNObject2.getValue();
        byte[] byArray2 = (byte[])aSNObject3.getValue();
        aSNObject2 = aSNObject.getComponent("SubjectPublicKeyInfo.subjectPublicKey");
        byte[] byArray3 = (byte[])aSNObject2.getValue();
        if (string.equals("1.2.840.113549.1.1.1")) {
            return new X509RSAPublicKey(string, byArray2, byArray3);
        }
        if (string.equals("1.2.840.10040.4.1")) {
            return new X509DSAPublicKey(string, byArray2, byArray3);
        }
        throw new IOException("Unrecognized OID for key" + string);
    }

    public static byte[] encodePublicKey(byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERUtils.encodeOID(byArray, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray2);
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray4, byteArrayOutputStream);
        DERUtils.encodeBitString(byArray3, byteArrayOutputStream);
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray5, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

