/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.crypto;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import xjava.security.Parameterized;

public class HMACOutputStream
extends OutputStream {
    private OutputStream sub;
    private MessageDigest md;

    protected void _HMACOutputStream(String string, byte[] byArray, OutputStream outputStream) {
        this.sub = outputStream;
        try {
            this.md = MessageDigest.getInstance("HMAC-" + string);
            ((Parameterized)this.md).setParameter("key", (Object)byArray);
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
    }

    public HMACOutputStream(String string, byte[] byArray, OutputStream outputStream) {
        this._HMACOutputStream(string, byArray, outputStream);
    }

    public HMACOutputStream(String string, String string2, OutputStream outputStream) {
        try {
            this.md = MessageDigest.getInstance(string);
            this._HMACOutputStream(string, this.md.digest(string2.getBytes()), outputStream);
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
    }

    public void write(int n) throws IOException {
        this.md.update((byte)(0xFF & n));
        this.sub.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.md.update(byArray);
        this.sub.write(byArray);
    }

    public byte[] digest() {
        return this.md.digest();
    }
}

