/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.crypto;

import COM.claymoresystems.ptls.SSLDebug;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import xjava.security.IllegalBlockSizeException;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class PKCS1Pad {
    public static final int ENCRYPT = 1;
    public static final int SIGN = 2;
    public static final int DECRYPT = 1;
    public static final int VERIFY = 2;

    public static byte[] pkcs1PadBuf(SecureRandom secureRandom, byte[] byArray, PublicKey publicKey) {
        BigInteger bigInteger = ((CryptixRSAPublicKey)publicKey).getModulus();
        return PKCS1Pad.pkcs1PadBuf(secureRandom, byArray, bigInteger, 1);
    }

    public static byte[] pkcs1PadBuf(byte[] byArray, PrivateKey privateKey) {
        BigInteger bigInteger = ((CryptixRSAPrivateKey)privateKey).getModulus();
        return PKCS1Pad.pkcs1PadBuf(byArray, bigInteger, 2);
    }

    public static byte[] pkcs1PadBuf(byte[] byArray, BigInteger bigInteger, int n) {
        SecureRandom secureRandom = null;
        if (n == 1) {
            secureRandom = new SecureRandom();
        }
        return PKCS1Pad.pkcs1PadBuf(secureRandom, byArray, bigInteger, n);
    }

    public static byte[] pkcs1PadBuf(SecureRandom secureRandom, byte[] byArray, BigInteger bigInteger, int n) {
        SSLDebug.debug(8, "PKCS1 pad input", byArray);
        int n2 = bigInteger.bitLength() / 8;
        n2 += bigInteger.bitLength() % 8 > 0 ? 1 : 0;
        int n3 = n == 1 ? --n2 - (2 + byArray.length) : n2 - (3 + byArray.length);
        byte[] byArray2 = new byte[n2];
        if (n3 < 8) {
            throw new InternalError("Input too long");
        }
        int n4 = 0;
        if (n == 1) {
            byArray2[n4++] = 2;
            byte[] byArray3 = new byte[1];
            int n5 = 0;
            while (n5 < n3) {
                do {
                    secureRandom.nextBytes(byArray3);
                } while (byArray3[0] == 0);
                byArray2[n4++] = byArray3[0];
                ++n5;
            }
        } else {
            byArray2[n4++] = 0;
            byArray2[n4++] = 1;
            int n6 = 0;
            while (n6 < n3) {
                byArray2[n4++] = -1;
                ++n6;
            }
        }
        byArray2[n4++] = 0;
        System.arraycopy(byArray, 0, byArray2, n4, byArray.length);
        SSLDebug.debug(8, "PKCS1 padded output", byArray2);
        return byArray2;
    }

    public static byte[] pkcs1UnpadBuf(byte[] byArray, int n) {
        SSLDebug.debug(8, "PKCS1 padded input", byArray);
        if (n == 1 ? byArray[0] != 2 : byArray[0] != 1) {
            throw new IllegalBlockSizeException("Bad RSA padding");
        }
        int n2 = 1;
        while (n2 < byArray.length) {
            if (byArray[n2] == 0) {
                byte[] byArray2 = new byte[byArray.length - (n2 + 1)];
                System.arraycopy(byArray, n2 + 1, byArray2, 0, byArray2.length);
                SSLDebug.debug(8, "PKCS1 unpadded output", byArray2);
                return byArray2;
            }
            ++n2;
        }
        throw new IllegalBlockSizeException("Bad RSA padding");
    }
}

