/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.provider;

import COM.claymoresystems.crypto.PKCS1Pad;
import cryptix.provider.rsa.RSAAlgorithm;
import cryptix.util.core.ArrayUtil;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;
import xjava.security.interfaces.RSAFactors;

public class RSASignature
extends Signature {
    private byte[] data = null;
    private BigInteger n;
    private BigInteger exp;
    private BigInteger p;
    private BigInteger q;
    private BigInteger u;

    public RSASignature() {
        super("RawRSAPKCS#1");
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof CryptixRSAPublicKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a RSA Public Key");
        }
        CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)publicKey;
        this.n = cryptixRSAPublicKey.getModulus();
        this.exp = cryptixRSAPublicKey.getExponent();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof CryptixRSAPrivateKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a RSA Private Key");
        }
        CryptixRSAPrivateKey cryptixRSAPrivateKey = (CryptixRSAPrivateKey)privateKey;
        this.n = cryptixRSAPrivateKey.getModulus();
        this.exp = cryptixRSAPrivateKey.getExponent();
        if (privateKey instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)privateKey;
            this.p = rSAFactors.getP();
            this.q = rSAFactors.getQ();
            this.u = rSAFactors.getInverseOfQModP();
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        throw new SignatureException(this.getAlgorithm() + ": Must be called with a complete input");
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.data != null) {
            throw new SignatureException(this.getAlgorithm() + ": Raw RSA may only be updated once");
        }
        this.data = new byte[n2];
        System.arraycopy(byArray, n, this.data, 0, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.data == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply input");
        }
        byte[] byArray = PKCS1Pad.pkcs1PadBuf(this.data, this.n, 2);
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = RSAAlgorithm.rsa((BigInteger)bigInteger, (BigInteger)this.n, (BigInteger)this.exp, (BigInteger)this.p, (BigInteger)this.q, (BigInteger)this.u);
        byte[] byArray2 = this.toBytes(bigInteger2);
        return byArray2;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.data == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply input");
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        byte[] byArray2 = RSAAlgorithm.rsa((BigInteger)bigInteger, (BigInteger)this.n, (BigInteger)this.exp, (BigInteger)this.p, (BigInteger)this.q, (BigInteger)this.u).toByteArray();
        byte[] byArray3 = PKCS1Pad.pkcs1UnpadBuf(byArray2, 2);
        return ArrayUtil.areEqual((byte[])byArray3, (byte[])this.data);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    protected byte[] toBytes(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return byArray2;
        }
        return byArray;
    }
}

