/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.cert.CertificateDecodeException;
import COM.claymoresystems.cert.CertificateVerifyException;
import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.crypto.DHPrivateKey;
import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLCertificate;
import COM.claymoresystems.ptls.SSLCipherState;
import COM.claymoresystems.ptls.SSLCipherSuite;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLFinished;
import COM.claymoresystems.ptls.SSLHandshakeHashes;
import COM.claymoresystems.ptls.SSLHandshakeHdr;
import COM.claymoresystems.ptls.SSLOutputStream;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLPRF;
import COM.claymoresystems.ptls.SSLRecord;
import COM.claymoresystems.ptls.SSLSessionData;
import COM.claymoresystems.ptls.SSLopaque;
import COM.claymoresystems.sslg.SSLPolicyInt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Vector;
import xjava.security.interfaces.CryptixRSAPrivateKey;

abstract class SSLHandshake {
    public static final int SSL_HT_HELLO_REQUEST = 0;
    public static final int SSL_HT_CLIENT_HELLO = 1;
    public static final int SSL_HT_SERVER_HELLO = 2;
    public static final int SSL_HT_CERTIFICATE = 11;
    public static final int SSL_HT_SERVER_KEY_EXCHANGE = 12;
    public static final int SSL_HT_CERTIFICATE_REQUEST = 13;
    public static final int SSL_HT_SERVER_HELLO_DONE = 14;
    public static final int SSL_HT_CERTIFICATE_VERIFY = 15;
    public static final int SSL_HT_CLIENT_KEY_EXCHANGE = 16;
    public static final int SSL_HT_FINISHED = 20;
    public static final int SSL_HT_V2_CLIENT_HELLO = 255;
    public final int SSL_HS_WAIT_FOR_CHANGE_CIPHER_SPECS = 20;
    public final int SSL_HS_WAIT_FOR_FINISHED = 21;
    public static final int SSL_HANDSHAKE_FINISHED = 255;
    public static final int SSL_V3_VERSION = 768;
    public static final int TLS_V1_VERSION = 769;
    public static final int MASTER_SECRET_SIZE = 48;
    public static byte[] pad_1 = new byte[]{54};
    public static byte[] pad_2 = new byte[]{92};
    ByteArrayOutputStream os = new ByteArrayOutputStream();
    int state;
    SSLConn _conn;
    byte[] session_id;
    boolean client;
    CertContext cert_ctx;
    Vector cipher_suites;
    SecureRandom rng;
    byte[] client_random = new byte[32];
    byte[] server_random = new byte[32];
    SSLHandshakeHashes hashes;
    SSLHandshakeHashes save_hashes;
    SSLCipherSuite cipher_suite;
    byte[] pre_master_secret;
    byte[] master_secret;
    PublicKey peerSignatureKey;
    PublicKey peerEncryptionKey;
    DHPrivateKey dhEphemeral;
    CryptixRSAPrivateKey rsaEphemeral = null;

    public SSLHandshake(SSLConn sSLConn) {
        this._conn = sSLConn;
        this.hashes = new SSLHandshakeHashes();
        this.cert_ctx = new CertContext(sSLConn.ctx.getRootList());
        this.rng = new SecureRandom(sSLConn.ctx.getSeedBytes());
        this.filterCipherSuites(sSLConn.ctx.getPrivateKey(), sSLConn.getPolicy());
    }

    public void handshake() throws IOException {
        while (this.state != 255) {
            this.handshakeContinue();
        }
        this._conn.sock_out_external = new SSLOutputStream(this._conn);
        SSLDebug.debug(4, "Handshake completed");
    }

    public abstract void handshakeContinue() throws IOException;

    public void sendHandshakeMsg(SSLConn sSLConn, int n, SSLPDU sSLPDU) throws IOException {
        this.sendHandshakeMsg(sSLConn, n, sSLPDU, true);
    }

    public void sendHandshakeMsg(SSLConn sSLConn, int n, SSLPDU sSLPDU, boolean bl) throws IOException, Error {
        sSLPDU.encode(sSLConn, this.os);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.os.size() + 10);
        SSLHandshakeHdr sSLHandshakeHdr = new SSLHandshakeHdr(n, this.os.size());
        sSLHandshakeHdr.encode(sSLConn, byteArrayOutputStream);
        this.os.writeTo(byteArrayOutputStream);
        this.os.reset();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (bl) {
            this.hashes.update(byArray);
        }
        SSLRecord sSLRecord = new SSLRecord(sSLConn, 22, byArray);
        sSLRecord.send(sSLConn);
    }

    public InputStream recvHandshakeMsg(SSLConn sSLConn, SSLHandshakeHdr sSLHandshakeHdr) throws IOException {
        sSLHandshakeHdr.decode(sSLConn, sSLConn.sock_in_hp);
        switch (sSLHandshakeHdr.ct.value) {
            case 15: 
            case 20: {
                try {
                    this.save_hashes = (SSLHandshakeHashes)this.hashes.clone();
                    break;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new Error("Internal error");
                }
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sSLHandshakeHdr.encode(sSLConn, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.hashes.update(byArray);
        byte[] byArray2 = new byte[sSLHandshakeHdr.length.value];
        int n = 0;
        while (n < byArray2.length) {
            n = sSLConn.sock_in_hp.read(byArray2, n, byArray2.length - n);
        }
        this.hashes.update(byArray2);
        return new ByteArrayInputStream(byArray2);
    }

    public boolean finishedP() {
        return this.state == 255;
    }

    public void stateChange(int n) {
        this.state = n;
        SSLDebug.debug(4, "New handshake state " + n);
    }

    public void stateAssert(int n) throws IOException {
        if (this.state == n) {
            return;
        }
        this._conn.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
    }

    public void stateAssert(int n, int n2) throws IOException {
        if (this.state == n) {
            return;
        }
        if (this.state == n2) {
            return;
        }
        this._conn.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
    }

    public void stateAssert(int n, int n2, int n3) throws IOException {
        if (this.state == n) {
            return;
        }
        if (this.state == n2) {
            return;
        }
        if (this.state == n3) {
            return;
        }
        this._conn.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
    }

    public void sendCertificate() throws IOException {
        Vector vector = this._conn.ctx.getCertificateChain();
        SSLCertificate sSLCertificate = new SSLCertificate();
        if (vector == null) {
            this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE, true);
            throw new IOException("Client authentication requested but no certificate available");
        }
        int n = 1;
        while (n <= vector.size()) {
            SSLopaque sSLopaque = new SSLopaque(-16777215);
            sSLopaque.value = (byte[])vector.elementAt(vector.size() - n);
            sSLCertificate.certificate_list.value.addElement(sSLopaque);
            ++n;
        }
        this.sendHandshakeMsg(this._conn, 11, sSLCertificate);
    }

    public void recvCertificate(InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        SSLCertificate sSLCertificate = new SSLCertificate();
        Vector<X509Cert> vector = new Vector<X509Cert>();
        Vector vector2 = null;
        sSLCertificate.decode(this._conn, inputStream);
        if (sSLCertificate.certificate_list.value.size() == 0) {
            this._conn.alert(SSLAlertX.TLS_ALERT_ILLEGAL_PARAMETER);
        }
        int n = 1;
        while (n <= sSLCertificate.certificate_list.value.size()) {
            object2 = (SSLopaque)sSLCertificate.certificate_list.value.elementAt(sSLCertificate.certificate_list.value.size() - n);
            object = ((SSLopaque)object2).value;
            vector.addElement(new X509Cert((byte[])object));
            ++n;
        }
        try {
            vector2 = X509Cert.verifyCertChain(this.cert_ctx, vector, this._conn.getPolicy().checkCertificateDatesP());
        }
        catch (CertificateDecodeException certificateDecodeException) {
            this._conn.alert(SSLAlertX.TLS_ALERT_BAD_CERTIFICATE);
        }
        catch (CertificateVerifyException certificateVerifyException) {
            if (SSLDebug.getDebug(32)) {
                certificateVerifyException.printStackTrace();
            }
            this._conn.alert(SSLAlertX.TLS_ALERT_BAD_CERTIFICATE);
        }
        if (vector2 == null && !this._conn.getPolicy().acceptUnverifiableCertificatesP()) {
            this._conn.alert(SSLAlertX.TLS_ALERT_UNKNOWN_CA);
        }
        object2 = (X509Cert)vector.elementAt(vector.size() - 1);
        object = ((X509Cert)object2).getPublicKey();
        this.peerSignatureKey = object;
        this._conn.peerCertificateChain = vector2;
    }

    public void computeMasterSecret() {
        SSLPRF sSLPRF = SSLPRF.getPRFInstance(this._conn.ssl_version);
        SSLDebug.debug(8, "Pre master secret", this.pre_master_secret);
        this.master_secret = new byte[48];
        sSLPRF.PRF(this.pre_master_secret, 1, this.client_random, this.server_random, this.master_secret);
        SSLDebug.debug(8, "Master secret", this.master_secret);
    }

    public void computeNextCipherStates() {
        this._conn.next_write_cipher_state = new SSLCipherState();
        this._conn.next_read_cipher_state = new SSLCipherState();
        try {
            SSLCipherState.computeSSLCipherState(this, this._conn.next_write_cipher_state, this._conn.next_read_cipher_state);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException.toString());
        }
        catch (KeyException keyException) {
            keyException.printStackTrace();
            throw new Error(keyException.toString());
        }
    }

    public void sendChangeCipherSpec() throws IOException {
        byte[] byArray = new byte[]{1};
        SSLRecord sSLRecord = new SSLRecord(this._conn, 20, byArray);
        sSLRecord.send(this._conn);
        this._conn.write_cipher_state = this._conn.next_write_cipher_state;
        this._conn.write_sequence_num = 0L;
    }

    public void recvFinished(InputStream inputStream) throws IOException {
        SSLFinished sSLFinished = new SSLFinished(this._conn, this, false);
        sSLFinished.decode(this._conn, inputStream);
    }

    public void sendFinished() throws IOException {
        SSLFinished sSLFinished = new SSLFinished(this._conn, this, true);
        this.sendHandshakeMsg(this._conn, 20, sSLFinished);
        this._conn.sock_out.flush();
    }

    public void recvChangeCipherSpecs() throws IOException {
        this.stateAssert(20);
        this._conn.read_cipher_state = this._conn.next_read_cipher_state;
        this._conn.read_sequence_num = 0L;
        this.stateChange(21);
    }

    protected void storeSession(String string) {
        SSLSessionData sSLSessionData = new SSLSessionData(this, string);
        this._conn.ctx.storeSession(string, sSLSessionData);
    }

    protected SSLSessionData findSession(String string) {
        SSLDebug.debug(4, "Trying to recover session using key" + string);
        SSLSessionData sSLSessionData = this._conn.ctx.findSession(string);
        if (sSLSessionData != null && sSLSessionData.getExpiryTime() < System.currentTimeMillis()) {
            this._conn.ctx.destroySession(sSLSessionData.getLookupKey());
            return null;
        }
        return sSLSessionData;
    }

    protected void restoreSession(SSLSessionData sSLSessionData) {
        sSLSessionData.restoreSession(this);
    }

    protected void filterCipherSuites(PrivateKey privateKey, SSLPolicyInt sSLPolicyInt) {
        String string = privateKey.getAlgorithm();
        this.cipher_suites = new Vector();
        short[] sArray = this._conn.getPolicy().getCipherSuites();
        int n = 0;
        while (n < sArray.length) {
            SSLCipherSuite sSLCipherSuite = SSLCipherSuite.findCipherSuite(sArray[n]);
            if (sSLCipherSuite == null) {
                SSLDebug.debug(16, "Rejecting unrecognized cipher suite" + sArray[n]);
            } else if (!sSLCipherSuite.getSignatureAlgBase().equals(string)) {
                SSLDebug.debug(16, "Rejecting cipher suite: " + sSLCipherSuite.getName() + " -- incompatible with signature algorithm " + string);
            } else {
                SSLDebug.debug(16, "Accepting cipher suite: " + sSLCipherSuite.getName());
                this.cipher_suites.addElement(sSLCipherSuite);
            }
            ++n;
        }
    }
}

