/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLCertificateVerify;
import COM.claymoresystems.ptls.SSLCipherSuite;
import COM.claymoresystems.ptls.SSLClientHello;
import COM.claymoresystems.ptls.SSLClientKeyExchange;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLHandshake;
import COM.claymoresystems.ptls.SSLHandshakeHdr;
import COM.claymoresystems.ptls.SSLServerHello;
import COM.claymoresystems.ptls.SSLServerKeyExchange;
import COM.claymoresystems.ptls.SSLSessionData;
import COM.claymoresystems.ptls.SSLuint16;
import COM.claymoresystems.ptls.SSLuint8;
import COM.claymoresystems.ptls.SSLvector;
import COM.claymoresystems.sslg.SSLPolicyInt;
import cryptix.util.core.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.Vector;

class SSLHandshakeClient
extends SSLHandshake {
    public final int SSL_HS_HANDSHAKE_START = 0;
    public final int SSL_HS_SENT_CLIENT_HELLO = 1;
    public final int SSL_HS_RECEIVED_SERVER_HELLO = 2;
    public final int SSL_HS_RECEIVED_CERTIFICATE = 3;
    public final int SSL_HS_RECEIVED_SERVER_KEY_EXCHANGE = 4;
    public final int SSL_HS_RECEIVED_CERTIFICATE_REQUEST = 5;
    public final int SSL_HS_RECEIVED_SERVER_HELLO_DONE = 6;
    boolean resume = false;
    SSLSessionData possibleResume;
    boolean clientAuth = false;

    public SSLHandshakeClient(SSLConn sSLConn) {
        super(sSLConn);
        this.client = true;
    }

    protected void filterCipherSuites(PrivateKey privateKey, SSLPolicyInt sSLPolicyInt) {
        this.cipher_suites = new Vector();
        short[] sArray = this._conn.getPolicy().getCipherSuites();
        int n = 0;
        while (n < sArray.length) {
            SSLCipherSuite sSLCipherSuite = SSLCipherSuite.findCipherSuite(sArray[n]);
            if (sSLCipherSuite == null) {
                SSLDebug.debug(16, "Rejecting unrecognized cipher suite" + sArray[n]);
            } else {
                SSLDebug.debug(16, "Accepting cipher suite: " + sSLCipherSuite.getName());
                this.cipher_suites.addElement(sSLCipherSuite);
            }
            ++n;
        }
    }

    public void handshakeContinue() throws IOException {
        InputStream inputStream = null;
        int n = -1;
        if (this.state == 0) {
            this.sendClientHello();
            this.state = 1;
        }
        SSLHandshakeHdr sSLHandshakeHdr = new SSLHandshakeHdr();
        inputStream = this.recvHandshakeMsg(this._conn, sSLHandshakeHdr);
        n = sSLHandshakeHdr.ct.value;
        SSLConn.debug(4, "Processing handshake message of type " + n);
        switch (n) {
            case 2: {
                this.stateAssert(1);
                this.recvServerHello(inputStream);
                if (!this.resume) {
                    this.stateChange(2);
                    break;
                }
                this.stateChange(20);
                break;
            }
            case 11: {
                this.stateAssert(2);
                this.recvCertificate(inputStream);
                this.stateChange(3);
                break;
            }
            case 12: {
                this.stateAssert(3);
                this.recvServerKeyExchange(inputStream);
                this.stateChange(4);
                break;
            }
            case 13: {
                this.stateAssert(4, 3);
                this.recvCertificateRequest(inputStream);
                this.stateChange(5);
                break;
            }
            case 14: {
                this.stateAssert(3, 4, 5);
                if (this.clientAuth) {
                    this.sendCertificate();
                }
                this.sendClientKeyExchange();
                if (this.clientAuth) {
                    this.sendCertificateVerify();
                }
                this.sendChangeCipherSpec();
                this.sendFinished();
                this.stateChange(20);
                break;
            }
            case 20: {
                this.stateAssert(21);
                this.recvFinished(inputStream);
                if (this.resume) {
                    this.sendChangeCipherSpec();
                    this.sendFinished();
                }
                this.storeSession(this.sessionLookupKey());
                this.stateChange(255);
                break;
            }
            default: {
                this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
            }
        }
    }

    private void sendClientHello() throws IOException {
        Object object;
        SSLClientHello sSLClientHello = new SSLClientHello();
        byte[] byArray = new byte[]{};
        this.possibleResume = this.findSession(this.sessionLookupKey());
        sSLClientHello.client_version.value = this._conn.ssl_version;
        this.rng.nextBytes(this.client_random);
        sSLClientHello.random.value = this.client_random;
        sSLClientHello.session_id.value = this.possibleResume == null ? byArray : this.possibleResume.getSessionID();
        Vector<SSLuint16> vector = new Vector<SSLuint16>();
        int n = 0;
        while (n < this.cipher_suites.size()) {
            object = (SSLCipherSuite)this.cipher_suites.elementAt(n);
            vector.addElement(new SSLuint16(((SSLCipherSuite)object).getValue()));
            ++n;
        }
        sSLClientHello.cipher_suites = new SSLvector(-65535, vector);
        object = new Vector();
        ((Vector)object).addElement(new SSLuint8(0));
        sSLClientHello.compression_methods = new SSLvector(-255, (Vector)object);
        this.sendHandshakeMsg(this._conn, 1, sSLClientHello);
        this._conn.sock_out.flush();
    }

    private void recvServerHello(InputStream inputStream) throws IOException {
        SSLServerHello sSLServerHello = new SSLServerHello();
        sSLServerHello.decode(this._conn, inputStream);
        if (sSLServerHello.server_version.value < 768 || sSLServerHello.server_version.value > this._conn.ssl_version) {
            this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
        }
        this._conn.ssl_version = sSLServerHello.server_version.value;
        System.arraycopy(sSLServerHello.random.value, 0, this.server_random, 0, 32);
        this.session_id = sSLServerHello.session_id.value;
        SSLDebug.debug(2, "Received Session ID", this.session_id);
        if (this.session_id.length != 0 && this.possibleResume != null && ArrayUtil.areEqual((byte[])this.session_id, (byte[])this.possibleResume.getSessionID())) {
            this.restoreSession(this.possibleResume);
            if (sSLServerHello.cipher_suite.value != this.cipher_suite.getValue()) {
                this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
            }
            this.resume = true;
            this.computeNextCipherStates();
            SSLDebug.debug(4, "Resuming...");
            return;
        }
        this.cipher_suite = null;
        int n = 0;
        while (n < this.cipher_suites.size()) {
            SSLCipherSuite sSLCipherSuite = (SSLCipherSuite)this.cipher_suites.elementAt(n);
            if (sSLCipherSuite.getValue() == sSLServerHello.cipher_suite.value) {
                this.cipher_suite = sSLCipherSuite;
                break;
            }
            ++n;
        }
        if (this.cipher_suite == null) {
            this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
        }
        SSLDebug.debug(64, "Server chose cipher" + this.cipher_suite.getName());
        if (sSLServerHello.compression_method.value != 0) {
            this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
        }
    }

    private void recvServerKeyExchange(InputStream inputStream) throws IOException {
        SSLServerKeyExchange sSLServerKeyExchange = new SSLServerKeyExchange();
        sSLServerKeyExchange.decode(this._conn, inputStream);
    }

    private void recvCertificateRequest(InputStream inputStream) throws IOException {
        this.clientAuth = true;
    }

    private void sendCertificateVerify() throws IOException {
        SSLCertificateVerify sSLCertificateVerify = new SSLCertificateVerify(this._conn, this, true);
        this.sendHandshakeMsg(this._conn, 15, sSLCertificateVerify);
    }

    private void sendClientKeyExchange() throws IOException {
        SSLClientKeyExchange sSLClientKeyExchange = new SSLClientKeyExchange();
        this.sendHandshakeMsg(this._conn, 16, sSLClientKeyExchange);
        this.computeMasterSecret();
        this.computeNextCipherStates();
    }

    private String sessionLookupKey() {
        String string = this._conn.s.remote_host + ":" + this._conn.s.remote_port;
        return string;
    }
}

