/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLDebug;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class SSLHandshakeHashes {
    private MessageDigest md5;
    private MessageDigest sha;

    public SSLHandshakeHashes() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
            this.sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("Inconsistency. Shouldn't be missing MD5 or SHA");
        }
    }

    public void update(byte[] byArray) {
        SSLDebug.debug(8, "Handshake hash update", byArray);
        this.md5.update(byArray);
        this.sha.update(byArray);
    }

    public MessageDigest getMD5Digest() {
        try {
            return (MessageDigest)this.md5.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Hey, this should be cloneable");
        }
    }

    public MessageDigest getSHADigest() {
        try {
            return (MessageDigest)this.sha.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Hey, this should be cloneable");
        }
    }

    public byte[] getMD5Value() {
        return this.getMD5Value(new byte[0]);
    }

    public byte[] getSHAValue() {
        return this.getSHAValue(new byte[0]);
    }

    public byte[] getMD5Value(byte[] byArray) {
        try {
            MessageDigest messageDigest = (MessageDigest)this.md5.clone();
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Hey, this should be cloneable");
        }
    }

    public byte[] getSHAValue(byte[] byArray) {
        try {
            MessageDigest messageDigest = (MessageDigest)this.sha.clone();
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Hey, this should be cloneable");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SSLHandshakeHashes sSLHandshakeHashes = new SSLHandshakeHashes();
        sSLHandshakeHashes.md5 = this.getMD5Digest();
        sSLHandshakeHashes.sha = this.getSHADigest();
        return sSLHandshakeHashes;
    }

    public void reset() {
        this.md5.reset();
        this.sha.reset();
    }
}

