/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLAlertException;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.sslg.SSLPolicyInt;
import COM.claymoresystems.sslg.SSLSocketXInt;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class SSLSocket
extends Socket
implements SSLSocketXInt {
    SSLConn conn;
    String remote_host;
    int remote_port;

    public SSLSocket(SSLContext sSLContext, String string, Integer n) throws UnknownHostException, IOException {
        this(sSLContext, string, (int)n);
    }

    public SSLSocket(SSLContext sSLContext, String string, int n) throws UnknownHostException, IOException {
        super(string, n);
        this.remote_host = this.remote_host;
        this.remote_port = n;
        this.internalSocket(sSLContext);
    }

    public SSLSocket(SSLContext sSLContext, InetAddress inetAddress, int n) throws IOException {
        super(inetAddress, n);
        this.remote_host = inetAddress.toString();
        this.remote_port = n;
        this.internalSocket(sSLContext);
    }

    public SSLSocket(SSLContext sSLContext, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        super(inetAddress, n, inetAddress2, n2);
        this.remote_host = inetAddress.toString();
        this.remote_port = n;
        this.internalSocket(sSLContext);
    }

    public SSLSocket(SSLContext sSLContext, String string, int n, InetAddress inetAddress, int n2) throws IOException {
        super(string, n, inetAddress, n2);
        this.remote_host = string;
        this.remote_port = n;
        this.internalSocket(sSLContext);
    }

    public SSLSocket(SSLContext sSLContext, InputStream inputStream, OutputStream outputStream, String string, int n, int n2) throws IllegalArgumentException, IOException {
        this();
        int n3;
        switch (n2) {
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("how value" + n2 + " not supported");
            }
        }
        this.conn = new SSLConn(this, inputStream, outputStream, sSLContext, n3);
        this.remote_host = string;
        this.remote_port = n;
        this.conn.handshake();
    }

    public SSLSocket() {
    }

    void internalSocket(SSLContext sSLContext) throws IOException {
        this.setTcpNoDelay(true);
        this.conn = new SSLConn(this, super.getInputStream(), super.getOutputStream(), sSLContext, 1);
        this.conn.handshake();
    }

    void serverHandshake(SSLContext sSLContext) throws IOException {
        this.conn = new SSLConn(this, super.getInputStream(), super.getOutputStream(), sSLContext, 2);
        this.conn.handshake();
    }

    public void hardClose() throws IOException {
        if (this.conn.s != null) {
            super.close();
        }
    }

    public void close() throws IOException {
        this.conn.close();
        this.hardClose();
    }

    public InputStream getInputStream() {
        return this.conn.getInStream();
    }

    public OutputStream getOutputStream() {
        return this.conn.getOutStream();
    }

    public String toString() {
        return "SSL: " + super.toString();
    }

    public int getCipherSuite() throws IOException {
        return this.conn.getCipherSuite();
    }

    public Vector getCertificateChain() throws IOException {
        return this.conn.getCertificateChain();
    }

    public SSLPolicyInt getPolicy() {
        return this.conn.getPolicy();
    }

    public int getVersion() throws IOException {
        return this.conn.getVersion();
    }

    public void renegotiate(SSLPolicyInt sSLPolicyInt) throws IOException {
        this.conn.renegotiate(sSLPolicyInt);
    }

    public void renegotiate() throws IOException {
        this.conn.renegotiate(this.conn.getPolicy());
    }

    public void sendClose() throws IOException {
        this.conn.sendClose();
    }

    public void waitForClose(boolean bl) throws IOException {
        this.conn.recvClose(bl);
    }

    private static void testConn(SSLContext sSLContext, String string, String string2) throws IOException, UnknownHostException {
        try {
            String string3;
            Object object;
            SSLSocket sSLSocket = new SSLSocket(sSLContext, string, Integer.parseInt(string2));
            Vector vector = sSLSocket.getCertificateChain();
            if (vector != null) {
                System.out.println("Cert chain");
                int n = 0;
                while (n < vector.size()) {
                    object = (X509Cert)vector.elementAt(n);
                    System.out.println("Issuer " + ((X509Cert)object).getIssuerName().getNameString());
                    System.out.println("Subject " + ((X509Cert)object).getSubjectName().getNameString());
                    System.out.println("Serial " + ((X509Cert)object).getSerial());
                    System.out.println("Validity " + ((X509Cert)object).getValidityNotBefore() + "-" + ((X509Cert)object).getValidityNotAfter());
                    ++n;
                }
            }
            byte[] byArray = new byte[4096];
            object = new InputStreamReader(sSLSocket.getInputStream());
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(sSLSocket.getOutputStream());
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write("Test string", 0, 11);
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.flush();
            while ((string3 = bufferedReader.readLine()) != null) {
                System.out.println(string3);
            }
            sSLSocket.close();
        }
        catch (SSLAlertException sSLAlertException) {
            throw new Error(sSLAlertException.toString());
        }
    }

    public void _stompOutputStream(OutputStream outputStream) {
        this.conn._sock_out = outputStream;
        this.conn.sock_out = new BufferedOutputStream(outputStream);
    }

    public static void main(String[] stringArray) throws UnknownHostException, IOException {
        String string = "localhost";
        String string2 = "4433";
        if (stringArray.length == 2) {
            string = stringArray[0];
            string2 = stringArray[1];
        }
        SSLContext sSLContext = new SSLContext();
        sSLContext.loadRootCertificates("root.b64");
        sSLContext.loadEAYKeyFile("bookdsa.pem", "password");
        System.out.println("Trying 1");
        SSLSocket.testConn(sSLContext, string, string2);
        System.out.println("Trying 2");
        SSLSocket.testConn(sSLContext, string, string2);
    }
}

