/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLuintX;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

class SSLopaque
extends SSLPDU {
    int length;
    byte[] value;

    public SSLopaque(int n) {
        this.length = n;
    }

    public SSLopaque(int n, byte[] byArray) {
        this.length = n;
        this.value = byArray;
    }

    public int encode(SSLConn sSLConn, OutputStream outputStream) throws Error, IOException {
        int n = 0;
        if (this.length < 0) {
            SSLuintX sSLuintX = new SSLuintX(-this.length, this.value.length);
            SSLDebug.debug(1, "Opaque <" + -1 * this.length + ">" + "length" + this.value.length);
            n = sSLuintX.encode(sSLConn, outputStream);
        } else {
            SSLDebug.debug(1, "Opaque [" + this.length + "]");
            if (this.length != this.value.length) {
                throw new Error("Array length doesn't match opaque size");
            }
        }
        outputStream.write(this.value);
        return n += this.value.length;
    }

    public int decode(SSLConn sSLConn, InputStream inputStream) throws IOException {
        int n = 0;
        if (this.length < 0) {
            SSLuintX sSLuintX = new SSLuintX(-this.length);
            n = sSLuintX.decode(sSLConn, inputStream);
            this.value = new byte[sSLuintX.value];
        } else {
            this.value = new byte[this.length];
        }
        int n2 = 0;
        int n3 = this.value.length;
        while (n3 > 0) {
            int n4 = inputStream.read(this.value, n2, n3);
            if (n4 < 0) {
                throw new IOException("Short read");
            }
            n2 += n4;
            n3 -= n4;
        }
        return n + this.value.length;
    }

    public void print(SSLConn sSLConn, PrintWriter printWriter) {
        printWriter.print("Opaque ");
        if (this.length < 0) {
            printWriter.print("max (" + -1 * this.length + ")");
        }
        printWriter.println("length " + this.value.length);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

