/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.i18n;

import java.util.Locale;

public class BundleInfo {
    private String name;
    private Locale locale;
    private String ext;

    public String getName() {
        return this.name;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getExtensionParameter() {
        return this.ext;
    }

    public String toString() {
        return "BundleInfo(" + this.name + "," + this.locale + "," + this.ext + ")";
    }

    public BundleInfo getParent() {
        if (this.locale != null && !this.locale.getLanguage().equals("")) {
            return new BundleInfo(this.name, this.getParentLocale(), this.ext);
        }
        return null;
    }

    protected Locale getParentLocale() {
        Locale newloc;
        if (this.locale.getVariant().equals("")) {
            Locale locale = this.locale.getCountry().equals("") ? new Locale("", "", "") : new Locale(this.locale.getLanguage(), "", "");
        } else {
            newloc = new Locale(this.locale.getLanguage(), this.locale.getCountry(), "");
        }
        return newloc;
    }

    public boolean matches(BundleInfo info) {
        return this.match(this.name, info.getName()) && this.match(this.locale, info.getLocale()) && this.match(this.ext, info.getExtensionParameter());
    }

    protected boolean match(String str, String reference) {
        if (str == null) {
            return true;
        }
        if (reference == null) {
            return false;
        }
        return str.equals(reference);
    }

    protected boolean match(Locale locale, Locale reference) {
        if (locale == null) {
            return true;
        }
        if (reference == null) {
            return false;
        }
        return this.match(locale.getLanguage(), reference.getLanguage()) && this.match(locale.getCountry(), reference.getCountry()) && this.match(locale.getVariant(), reference.getVariant());
    }

    public BundleInfo(String name, Locale locale, String ext) {
        this.name = name;
        this.locale = locale;
        this.ext = ext;
    }

    public BundleInfo(String name, Locale locale) {
        this(name, locale, null);
    }

    public BundleInfo(Locale locale) {
        this(null, locale);
    }
}

