/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;

public final class StackIntrospector {
    private static CallStack c_callStack;

    private static synchronized Class[] getCallStackAsClassArray() throws SecurityException {
        if (c_callStack == null) {
            c_callStack = new CallStack();
        }
        return c_callStack.get();
    }

    public static final Class getCallerClass(int index) throws SecurityException {
        Class[] stack = StackIntrospector.getCallStackAsClassArray();
        if (index < stack.length) {
            return stack[index];
        }
        return null;
    }

    public static final Class getCallerClass(Class clazz) throws SecurityException {
        Class[] stack = StackIntrospector.getCallStackAsClassArray();
        int i = stack.length - 1;
        while (i >= 0) {
            if (clazz.isAssignableFrom(stack[i])) {
                return stack[i + 1];
            }
            --i;
        }
        return null;
    }

    public static final String getCallerMethod(int index) {
        int actualIndex = index + 1;
        String[] callStack = StackIntrospector.getCallStackAsStringArray();
        if (actualIndex < callStack.length) {
            return callStack[actualIndex];
        }
        return null;
    }

    public static final String getCallerMethod(Class clazz) {
        String[] callStack = StackIntrospector.getCallStackAsStringArray();
        int index = StackIntrospector.getCallerIndex(clazz.getName(), callStack);
        if (-1 == index) {
            return null;
        }
        return callStack[index];
    }

    public static final String[] getCallerStack(Class clazz, int count) {
        String[] callStack = StackIntrospector.getCallStackAsStringArray();
        int start = StackIntrospector.getCallerIndex(clazz.getName(), callStack);
        if (-1 == start) {
            return null;
        }
        int size = Math.min(count, callStack.length - start);
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            result[i] = callStack[start + i];
            ++i;
        }
        return result;
    }

    public static final String[] getCallStackAsStringArray() {
        StringWriter sw = new StringWriter();
        Throwable throwable = new Throwable();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        StringBuffer buffer = sw.getBuffer();
        ArrayList<String> stack = new ArrayList<String>();
        StringBuffer line = new StringBuffer();
        int length = buffer.length();
        boolean found = false;
        int state = 0;
        int i = 0;
        while (i < length) {
            char ch = buffer.charAt(i);
            switch (state) {
                case 0: {
                    if ('\n' != ch) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if ('t' != ch) break;
                    state = 2;
                    break;
                }
                case 2: {
                    line.setLength(0);
                    state = 3;
                    break;
                }
                case 3: {
                    if ('\n' != ch) {
                        line.append(ch);
                        break;
                    }
                    String method = line.toString();
                    stack.add(method);
                    state = 1;
                }
            }
            ++i;
        }
        return stack.toArray(new String[0]);
    }

    private static int getCallerIndex(String prefix, String[] callStack) {
        boolean found = false;
        int i = 0;
        while (i < callStack.length) {
            boolean match = callStack[i].startsWith(prefix);
            if (match) {
                if (!found) {
                    found = true;
                } else {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private StackIntrospector() {
    }

    private static final class CallStack
    extends SecurityManager {
        public Class[] get() {
            return this.getClassContext();
        }

        CallStack() {
        }
    }
}

