/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.AttributeInfo;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.AttributeInfoList;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.LineNumberTable;

public class Code
extends AttributeInfo {
    protected int length;
    protected int max_stack;
    protected int max_locals;
    protected byte[] code;
    protected ExceptionInfo[] exceptions;
    protected LineNumberTable lineNumberTable;

    public Code(int attr_index, ConstantPool pool) {
        super(attr_index, pool);
    }

    public void read(DataInputStream dis) throws IOException {
        this.length = dis.readInt();
        this.max_stack = dis.readShort();
        this.max_locals = dis.readShort();
        int bytecode_len = dis.readInt();
        dis.skip(bytecode_len);
        int exception_count = dis.readShort();
        this.exceptions = new ExceptionInfo[exception_count];
        int i = 0;
        while (i < exception_count) {
            this.exceptions[i] = new ExceptionInfo(this.constantPool);
            this.exceptions[i].read(dis);
            ++i;
        }
        AttributeInfoList attributes = new AttributeInfoList(this.constantPool);
        attributes.read(dis);
        this.lineNumberTable = (LineNumberTable)attributes.getAttribute("LineNumberTable");
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public byte[] getCode() {
        return this.code;
    }

    public ExceptionInfo[] getExceptions() {
        return this.exceptions;
    }

    public LineNumberTable getLineNumberTable() {
        return this.lineNumberTable;
    }

    public static class ExceptionInfo {
        protected ConstantPool constantPool;
        protected int startPC;
        protected int endPC;
        protected int handlerPC;
        protected int catchType;

        public ExceptionInfo(ConstantPool pool) {
            this.constantPool = pool;
        }

        public void read(DataInputStream dis) throws IOException {
            this.startPC = dis.readShort();
            this.endPC = dis.readShort();
            this.handlerPC = dis.readShort();
            this.catchType = dis.readShort();
        }

        public int getStartPC() {
            return this.startPC;
        }

        public int getEndPC() {
            return this.endPC;
        }

        public int getHandlerPC() {
            return this.handlerPC;
        }

        public int getCatchType() {
            return this.catchType;
        }
    }
}

