/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.Serializable;

public final class Namespace
implements Serializable {
    private static final boolean VALIDATE_PREFIX = true;
    private static final boolean IGNORE_PREFIX = false;
    private static volatile boolean m_policy = true;
    private final String m_prefix;
    private final String m_uri;
    private final boolean m_validate_prefix;

    public final String getPrefix() {
        return this.m_prefix;
    }

    public final String getURI() {
        return this.m_uri;
    }

    public final boolean equals(Object check) {
        boolean isEqual = false;
        if (check instanceof Namespace) {
            Namespace other = (Namespace)check;
            if (this.m_validate_prefix) {
                isEqual = this.getPrefix().equals(other.getPrefix());
                if (isEqual) {
                    isEqual = this.getURI().equals(other.getURI());
                }
            } else {
                isEqual = this.getURI().equals(other.getURI());
            }
        } else if (check instanceof String) {
            isEqual = this.toString().equals(check);
        }
        return isEqual;
    }

    public final String toString() {
        StringBuffer xmlns = new StringBuffer("xmlns");
        if (!"".equals(this.getPrefix())) {
            xmlns.append(":").append(this.getPrefix());
        }
        xmlns.append("=\"").append(this.getURI()).append("\"");
        return xmlns.toString();
    }

    private static final String prefix(String xmlns) {
        if (xmlns == null) {
            return "";
        }
        if (!xmlns.startsWith("xmlns")) {
            throw new IllegalStateException("The namespace is not in the proper format");
        }
        String prefix = "";
        String sub = xmlns.substring("xmlns".length());
        int uristart = sub.indexOf("=\"");
        if (sub.charAt(0) == ':') {
            if (uristart > 1) {
                prefix = sub.substring(1, uristart);
            } else {
                throw new IllegalStateException("The namespace is not in the proper format");
            }
        }
        return prefix;
    }

    private static final String uri(String xmlns) {
        if (xmlns == null) {
            return "";
        }
        return xmlns.substring(xmlns.indexOf("\""), xmlns.lastIndexOf("\""));
    }

    public static final Namespace getNamespace(String xmlns) {
        return Namespace.getNamespace(Namespace.prefix(xmlns), Namespace.uri(xmlns));
    }

    public static final synchronized Namespace getNamespace(String prefix, String uri) {
        String pre = prefix;
        String loc = uri;
        if (prefix == null) {
            pre = "";
        }
        if (uri == null) {
            loc = "";
        }
        return new Namespace(pre, loc, true);
    }

    public static final synchronized void setPolicy(boolean prefixValidating) {
        m_policy = prefixValidating;
    }

    public static final synchronized boolean getPolicy() {
        return m_policy;
    }

    private Namespace() {
        this("", "", true);
    }

    private Namespace(String prefix, String uri, boolean validatePrefix) {
        this.m_prefix = prefix;
        this.m_uri = uri;
        this.m_validate_prefix = validatePrefix;
    }
}

