/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

public class ArrayClassLoader
extends ClassLoader {
    byte[][] classBytes;
    int size;
    Class[] loadedClasses;
    String[] classNames;

    public ArrayClassLoader(String[] classNames, byte[][] classBytes) {
        this.classBytes = classBytes;
        this.size = classBytes.length;
        this.loadedClasses = new Class[this.size];
        this.classNames = classNames;
    }

    public ArrayClassLoader(byte[][] classBytes) {
        this.classBytes = classBytes;
        this.size = classBytes.length;
        this.loadedClasses = new Class[this.size];
        this.classNames = new String[this.size];
        int i = 0;
        while (i < this.size) {
            this.classNames[i] = "lambda" + i;
            ++i;
        }
    }

    public void addClass(String name, byte[] bytes) {
        this.reserve(1);
        this.classNames[this.size] = name == null ? "lambda" + this.size : name;
        this.classBytes[this.size] = bytes;
        ++this.size;
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clas;
        int index = 0;
        while (true) {
            if (index >= this.size) {
                clas = this.findSystemClass(name);
                break;
            }
            if (name.equals(this.classNames[index])) {
                clas = this.loadedClasses[index];
                if (clas != null) break;
                byte[] bytes = this.classBytes[index];
                this.loadedClasses[index] = clas = this.defineClass(name, bytes, 0, bytes.length);
                this.classBytes[index] = null;
                break;
            }
            ++index;
        }
        if (resolve) {
            this.resolveClass(clas);
        }
        return clas;
    }

    private void reserve(int count) {
        int newLength;
        if (count <= 0) {
            return;
        }
        int n = newLength = this.size < count ? this.size + count : 2 * this.size;
        if (this.loadedClasses == null) {
            this.loadedClasses = new Class[newLength];
        } else if (this.size + count > this.loadedClasses.length) {
            Class[] loadedClassesNew = new Class[newLength];
            System.arraycopy(this.loadedClasses, 0, loadedClassesNew, 0, this.size);
            this.loadedClasses = loadedClassesNew;
        }
        if (this.classBytes == null) {
            this.classBytes = new byte[newLength][];
        } else if (this.size + count > this.classBytes.length) {
            byte[][] classBytesNew = new byte[newLength][];
            System.arraycopy(this.classBytes, 0, classBytesNew, 0, this.size);
            this.classBytes = classBytesNew;
        }
        if (this.classNames == null) {
            this.classNames = new String[newLength];
        } else if (this.size + count > this.classNames.length) {
            String[] classNamesNew = new String[newLength];
            System.arraycopy(this.classNames, 0, classNamesNew, 0, this.size);
            this.classNames = classNamesNew;
        }
    }
}

