/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.ConstantValueAttr;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.Location;
import java.io.DataOutputStream;
import java.io.IOException;

public class Field
extends Location
implements AttrContainer {
    public int flags;
    Field next;
    Attribute attributes;
    ClassType owner;
    String sourceName;
    java.lang.reflect.Field rfield;

    public Field(ClassType ctype) {
        if (ctype.last_field == null) {
            ctype.fields = this;
        } else {
            ctype.last_field.next = this;
        }
        ctype.last_field = this;
        ++ctype.fields_count;
        this.owner = ctype;
    }

    void assign_constants(ClassType classfile) {
        ConstantPool constants = classfile.constants;
        if (this.name_index == 0 && this.name != null) {
            this.name_index = constants.addUtf8((String)this.name).index;
        }
        if (this.signature_index == 0 && this.type != null) {
            this.signature_index = constants.addUtf8((String)this.type.signature).index;
        }
        Attribute.assignConstants(this, classfile);
    }

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final ClassType getDeclaringClass() {
        return this.owner;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final int getModifiers() {
        return this.flags;
    }

    public final Field getNext() {
        return this.next;
    }

    public java.lang.reflect.Field getReflectField() throws NoSuchFieldException {
        if (this.rfield == null) {
            this.rfield = this.owner.getReflectClass().getDeclaredField(this.getName());
        }
        return this.rfield;
    }

    public String getSourceName() {
        if (this.sourceName == null) {
            this.sourceName = this.getName().intern();
        }
        return this.sourceName;
    }

    public final boolean getStaticFlag() {
        return (this.flags & 8) != 0;
    }

    public static Field searchField(Field fields, String name) {
        while (fields != null) {
            if (fields.getSourceName() == name) {
                return fields;
            }
            fields = fields.next;
        }
        return null;
    }

    public final void setAttributes(Attribute attributes) {
        this.attributes = attributes;
    }

    public final void setConstantValue(Object value, ClassType ctype) {
        CpoolEntry entry;
        ConstantPool cpool = ctype.getConstants();
        char sig1 = this.getType().getSignature().charAt(0);
        switch (sig1) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                entry = cpool.addInt(((Number)value).intValue());
                break;
            }
            case 'J': {
                entry = cpool.addLong(((Number)value).longValue());
                break;
            }
            case 'F': {
                entry = cpool.addFloat(((Number)value).floatValue());
                break;
            }
            case 'D': {
                entry = cpool.addDouble(((Number)value).doubleValue());
                break;
            }
            default: {
                entry = cpool.addString(value.toString());
            }
        }
        ConstantValueAttr attr = new ConstantValueAttr(entry.getIndex());
        attr.addToFrontOf(this);
    }

    public void setSourceName(String name) {
        this.sourceName = name;
    }

    public final void setStaticFlag(boolean is_static) {
        this.flags = is_static ? (this.flags |= 8) : (this.flags ^= 0xFFFFFFF7);
    }

    void write(DataOutputStream dstr, ClassType classfile) throws IOException {
        dstr.writeShort(this.flags);
        dstr.writeShort(this.name_index);
        dstr.writeShort(this.signature_index);
        Attribute.writeAll(this, dstr);
    }
}

