/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.Type;

public class SwitchState {
    int minValue;
    int maxValue;
    int numCases;
    int[] values;
    Label[] labels;
    Label defaultLabel;
    Label switch_label;
    Type[] typeState;

    public SwitchState(CodeAttr code) {
        this.switch_label = new Label(code);
        code.popType();
        this.typeState = code.saveStackTypeState(false);
        code.emitGoto(this.switch_label);
        this.numCases = 0;
    }

    public boolean addCase(int value, CodeAttr code) {
        Label label = new Label(code);
        boolean ok = this.addCase(value, label, code);
        label.define(code);
        code.restoreStackTypeState(this.typeState);
        return ok;
    }

    public boolean addCase(int value, Label label, CodeAttr code) {
        int copyBefore;
        if (this.values == null) {
            this.values = new int[10];
            this.labels = new Label[10];
            this.numCases = 1;
            this.minValue = this.maxValue = value;
            this.values[0] = value;
            this.labels[0] = label;
            return true;
        }
        int[] old_values = this.values;
        Label[] old_labels = this.labels;
        if (this.numCases >= this.values.length) {
            this.values = new int[2 * this.numCases];
            this.labels = new Label[2 * this.numCases];
        }
        if (value < this.minValue) {
            copyBefore = 0;
            this.minValue = value;
        } else if (value > this.maxValue) {
            copyBefore = this.numCases;
            this.maxValue = value;
        } else {
            int low = 0;
            int hi = this.numCases - 1;
            copyBefore = 0;
            while (low <= hi) {
                copyBefore = low + hi >> 1;
                if (old_values[copyBefore] >= value) {
                    hi = copyBefore - 1;
                    continue;
                }
                low = ++copyBefore;
            }
            if (value == old_values[copyBefore]) {
                return false;
            }
        }
        int copyAfter = this.numCases - copyBefore;
        System.arraycopy(old_values, copyBefore, this.values, copyBefore + 1, copyAfter);
        System.arraycopy(old_values, 0, this.values, 0, copyBefore);
        this.values[copyBefore] = value;
        System.arraycopy(old_labels, copyBefore, this.labels, copyBefore + 1, copyAfter);
        System.arraycopy(old_labels, 0, this.labels, 0, copyBefore);
        this.labels[copyBefore] = label;
        ++this.numCases;
        return true;
    }

    public void addDefault(CodeAttr code) {
        Label label = new Label(code);
        label.define(code);
        this.addDefault(label, code);
    }

    public void addDefault(Label label, CodeAttr code) {
        this.defaultLabel = label;
        code.restoreStackTypeState(this.typeState);
    }

    public void finish(CodeAttr code) {
        if (this.defaultLabel == null) {
            this.defaultLabel = new Label(code);
            this.defaultLabel.define(code);
            ClassType ex = ClassType.make("java.lang.RuntimeException");
            code.emitNew(ex);
            code.emitDup(ex);
            code.emitPushString("bad case value!");
            Type[] args = new Type[]{Type.string_type};
            Method con = ex.addMethod("<init>", 1, args, Type.void_type);
            code.emitInvokeSpecial(con);
            code.emitThrow();
        }
        this.switch_label.define(code);
        if (this.numCases <= 1) {
            code.pushType(Type.int_type);
            if (this.numCases == 1) {
                code.emitPushInt(this.minValue);
                code.emitGotoIfEq(this.labels[0]);
            } else {
                code.emitPop(1);
            }
            code.emitGoto(this.defaultLabel);
            return;
        }
        int start = code.PC;
        int pad = 3 - start & 3;
        if (2 * this.numCases >= this.maxValue - this.minValue) {
            code.reserve(13 + pad + 4 * (this.maxValue - this.minValue + 1));
            code.put1(170);
            while (--pad >= 0) {
                code.put1(0);
            }
            this.defaultLabel.emit_wide(code, start);
            code.put4(this.minValue);
            code.put4(this.maxValue);
            int index = 0;
            int i = this.minValue;
            while (i <= this.maxValue) {
                Label lab = this.values[index] == i ? this.labels[index++] : this.defaultLabel;
                lab.emit_wide(code, start);
                ++i;
            }
        } else {
            code.reserve(9 + pad + 8 * this.numCases);
            code.put1(171);
            while (--pad >= 0) {
                code.put1(0);
            }
            this.defaultLabel.emit_wide(code, start);
            code.put4(this.numCases);
            int index = 0;
            while (index < this.numCases) {
                code.put4(this.values[index]);
                this.labels[index].emit_wide(code, start);
                ++index;
            }
        }
    }

    public int getMaxValue() {
        return this.maxValue;
    }
}

