/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.tls.ptls;

import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.PureTLSPackageBridge;
import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.ptls.SSLThrewAlertException;
import COM.claymoresystems.sslg.SSLPolicyInt;
import java.io.IOException;
import java.net.Socket;
import java.security.PrivateKey;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.beepcore.beep.core.BEEPError;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.CloseChannelException;
import org.beepcore.beep.core.ProfileRegistry;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.SessionCredential;
import org.beepcore.beep.core.SessionTuningProperties;
import org.beepcore.beep.core.StartChannelException;
import org.beepcore.beep.core.StartChannelListener;
import org.beepcore.beep.core.TuningProfile;
import org.beepcore.beep.core.TuningResetException;
import org.beepcore.beep.profile.ProfileConfiguration;
import org.beepcore.beep.profile.tls.TLSProfile;
import org.beepcore.beep.profile.tls.ptls.TLSProfilePureTLSHandshakeCompletedListener;
import org.beepcore.beep.transport.tcp.TCPSession;
import org.beepcore.beep.util.Log;

public class TLSProfilePureTLS
extends TLSProfile
implements StartChannelListener {
    public static final String PROCEED1 = "<proceed/>";
    public static final String PROCEED2 = "<proceed />";
    public static final String READY1 = "<ready/>";
    public static final String READY2 = "<ready />";
    public static final String URI = "http://iana.org/beep/TLS";
    static final int MAX_CIPHERS = 103;
    static final String ERR_SERVER_MUST_HAVE_KEY = "Listener must be anonymous if no keys are specified.";
    static final String ERR_EXPECTED_PROCEED = "Error receiving <proceed />";
    static final String ERR_ILLEGAL_KEY_STORE = "Illegal Key Store Type property value";
    static final String ERR_ILLEGAL_TRUST_STORE = "Illegal Trust Store Type property value";
    static final String ERR_TLS_NOT_SUPPORTED_BY_SESSION = "TLS not supported by this session";
    static final String ERR_TLS_SOCKET = "TLS not supported by this session";
    static final String ERR_TLS_HANDSHAKE_WAIT = "Error waiting for TLS handshake to complete";
    static final String ERR_TLS_NO_AUTHENTICATION = "Authentication failed for this TLS negotiation";
    public static final String PROPERTY_CLIENT_AUTH_REQUIRED = "Client Authenticaton Required";
    public static final String PROPERTY_CIPHER_SUITE = "Cipher Suite";
    public static final String PROPERTY_CERTIFICATES = "Certificates";
    public static final String PROPERTY_PRIVATE_KEY = "Private Key";
    public static final String PROPERTY_TRUSTED_CERTS = "Trusted Certificates";
    public static final String PROPERTY_PRIVATE_KEY_ALGORITHM = "Private Key Type";
    boolean needPeerAuth = true;
    short[] cipherSuite = new short[103];
    String uri = "http://iana.org/beep/TLS";
    SSLPolicyInt policy = null;
    SSLContext context = new SSLContext();
    boolean abortSession = false;
    private TLSProfilePureTLSHandshakeCompletedListener handshakeListener = null;
    private static String defaultPrivateKey = "-----BEGIN RSA PRIVATE KEY-----\nProc-Type: 4,ENCRYPTED\nDEK-Info: DES-EDE3-CBC,376827D42B068D3C\n\nFAyWxidmVeHJBv9IWjp3NLtmnsLML92XJfVOT134C5IFez/PxHrkieuzHYv79m0u\nQAuySeIccNgdSQA/zcHLFUJjzxx7NjFtj3+80zredcXW5SyGd8F8Y9EpWV6rd6sa\nh3BJ2BnYNr3hTBoIlj/xnaSvfW0LrjcI6vaPw4sZ1gcNjfNzOVTUCgqNf6O+AIlI\nuMXNF+Lurp/aK6CV1LABhbsc5/CqmfOlWRvydiQiUFyGhJ5ub3yjgH0EejTUQpjC\nt2dPyKS97+2RJZE650VZDP37DVKOEdnf4OF1jmsoGQzxv33J8DoSGqNb1u4z4uXn\nicbhDI6ZxM53xUW6Oseu290+rKPUUIeZrWYWk8+SrMeV3KZq01K+paKAjA7CqfmW\nB7sO1mhiwRefIyj89NbXFZKMxMl95Th8A3aiONP0NtY=\n-----END RSA PRIVATE KEY-----\n";
    private static String defaultPassphrase = "stupid";
    private static String defaultCertificate = "-----BEGIN CERTIFICATE-----\nMIIDJDCCAs6gAwIBAgIBATANBgkqhkiG9w0BAQQFADCBkzELMAkGA1UEBhMCVVMx\nCzAJBgNVBAgTAlVUMRYwFAYDVQQHEw1BbWVyaWNhbiBGb3JrMRkwFwYDVQQKExBJ\nbnZpc2libGUgV29ybGRzMQ0wCwYDVQQLEwRVdGFoMREwDwYDVQQDEwhKYXkgS2lu\ndDEiMCAGCSqGSIb3DQEJARYTamtpbnRAaW52aXNpYmxlLm5ldDAeFw0wMTA1MjIy\nMjI2MzBaFw0wMjA1MjIyMjI2MzBaMH4xCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJV\nVDEZMBcGA1UEChMQSW52aXNpYmxlIFdvcmxkczENMAsGA1UECxMEVXRhaDETMBEG\nA1UEAxMKRXJpYyBEaXhvbjEjMCEGCSqGSIb3DQEJARYUZWRpeG9uQGludmlzaWJs\nZS5uZXQwXDANBgkqhkiG9w0BAQEFAANLADBIAkEAvlFYMlFSrVwYtQqClXow5Fln\nywGiddbtuKDmOYXVmkhMijiz5FJEE9Og+4hMHqkpY7ls2pgHAp2ojVk2mUc4MQID\nAQABo4IBHzCCARswCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBH\nZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFAsXsSPS9ygE+KOzXcDJhWWq\nl+Q1MIHABgNVHSMEgbgwgbWAFDpO2dz71wbN86ypUTtDVJ16LvXooYGZpIGWMIGT\nMQswCQYDVQQGEwJVUzELMAkGA1UECBMCVVQxFjAUBgNVBAcTDUFtZXJpY2FuIEZv\ncmsxGTAXBgNVBAoTEEludmlzaWJsZSBXb3JsZHMxDTALBgNVBAsTBFV0YWgxETAP\nBgNVBAMTCEpheSBLaW50MSIwIAYJKoZIhvcNAQkBFhNqa2ludEBpbnZpc2libGUu\nbmV0ggEAMA0GCSqGSIb3DQEBBAUAA0EAWysxYjfYZK3QMTAaI/sKIZaPtwUaWhHp\nKoWUMF6WZxe2iFwts0AoyLo6F7oMjvxNc2yNn4gi/WrPfZWkHncU3g==\n-----END CERTIFICATE-----\n";
    private static String defaultRootCertificate = "-----BEGIN CERTIFICATE-----\nMIIDDTCCAregAwIBAgIBADANBgkqhkiG9w0BAQQFADCBkzELMAkGA1UEBhMCVVMx\nCzAJBgNVBAgTAlVUMRYwFAYDVQQHEw1BbWVyaWNhbiBGb3JrMRkwFwYDVQQKExBJ\nbnZpc2libGUgV29ybGRzMQ0wCwYDVQQLEwRVdGFoMREwDwYDVQQDEwhKYXkgS2lu\ndDEiMCAGCSqGSIb3DQEJARYTamtpbnRAaW52aXNpYmxlLm5ldDAeFw0wMTA1MjIy\nMjIzMTZaFw0wMTA2MjEyMjIzMTZaMIGTMQswCQYDVQQGEwJVUzELMAkGA1UECBMC\nVVQxFjAUBgNVBAcTDUFtZXJpY2FuIEZvcmsxGTAXBgNVBAoTEEludmlzaWJsZSBX\nb3JsZHMxDTALBgNVBAsTBFV0YWgxETAPBgNVBAMTCEpheSBLaW50MSIwIAYJKoZI\nhvcNAQkBFhNqa2ludEBpbnZpc2libGUubmV0MFwwDQYJKoZIhvcNAQEBBQADSwAw\nSAJBANvFvkyq94iwrEvA4AprtJyfpznGfE2ibG5OrzeGWgZ1FqPsfhkU4qt0xbRL\nFdgb438SZCJ0bFWdK//P7Z1flI8CAwEAAaOB8zCB8DAdBgNVHQ4EFgQUOk7Z3PvX\nBs3zrKlRO0NUnXou9egwgcAGA1UdIwSBuDCBtYAUOk7Z3PvXBs3zrKlRO0NUnXou\n9eihgZmkgZYwgZMxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJVVDEWMBQGA1UEBxMN\nQW1lcmljYW4gRm9yazEZMBcGA1UEChMQSW52aXNpYmxlIFdvcmxkczENMAsGA1UE\nCxMEVXRhaDERMA8GA1UEAxMISmF5IEtpbnQxIjAgBgkqhkiG9w0BCQEWE2praW50\nQGludmlzaWJsZS5uZXSCAQAwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQQFAANB\nAMmJY0I24Qx9RNi6GdF75hblGsmt+W4oBnlWv4WI7qDcSzeSO8M2xGom95mE1+Hu\nczaRiitRTKis54e1d3h2HVs=\n-----END CERTIFICATE-----\n";

    public TLSProfilePureTLS() {
        this.policy = new SSLPolicyInt();
    }

    public boolean advertiseProfile(Session session, SessionTuningProperties sessionTuningProperties) throws BEEPException {
        return true;
    }

    public StartChannelListener init(String string, ProfileConfiguration profileConfiguration) throws BEEPException {
        Object object;
        Object object2;
        boolean bl = false;
        this.uri = string;
        this.policy = new SSLPolicyInt();
        this.context = new SSLContext();
        this.policy.negotiateTLS(true);
        if (profileConfiguration.get(PROPERTY_CLIENT_AUTH_REQUIRED) instanceof String && !Boolean.valueOf((String)profileConfiguration.get(PROPERTY_CLIENT_AUTH_REQUIRED)).booleanValue()) {
            this.policy.acceptUnverifiableCertificates(true);
            this.policy.checkCertificateDates(false);
            this.policy.requireClientAuth(false);
            this.needPeerAuth = false;
        } else {
            this.policy.acceptUnverifiableCertificates(false);
            this.policy.checkCertificateDates(true);
            this.policy.requireClientAuth(true);
            this.needPeerAuth = true;
        }
        this.context.setPolicy(this.policy);
        if (profileConfiguration.get(PROPERTY_CIPHER_SUITE) != null) {
            try {
                object2 = (short[])profileConfiguration.get(PROPERTY_CIPHER_SUITE);
                this.policy.setCipherSuites(object2);
            }
            catch (Exception exception) {
                throw new BEEPException(exception.getMessage());
            }
        }
        if (profileConfiguration.get(PROPERTY_PRIVATE_KEY) == null || profileConfiguration.get(PROPERTY_PRIVATE_KEY_ALGORITHM) == null || profileConfiguration.get(PROPERTY_CERTIFICATES) == null || profileConfiguration.get(PROPERTY_TRUSTED_CERTS) == null) {
            throw new BEEPException("Must have a private key and certificates with root certificates that match the key's algorithm");
        }
        object2 = (PrivateKey)profileConfiguration.get(PROPERTY_PRIVATE_KEY);
        PureTLSPackageBridge.setPrivateKey(this.context, (PrivateKey)object2);
        if (!(profileConfiguration.get(PROPERTY_CERTIFICATES) instanceof List)) {
            throw new BEEPException("X.509 Certificates should be in a List or subclass");
        }
        List list = (List)profileConfiguration.get(PROPERTY_CERTIFICATES);
        Iterator iterator = list.iterator();
        PureTLSPackageBridge.initCertificates(this.context);
        try {
            while (iterator.hasNext()) {
                object = (byte[])iterator.next();
                if (object == null) continue;
                PureTLSPackageBridge.addCertificate(this.context, object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BEEPException(exception.getMessage());
        }
        if (!(profileConfiguration.get(PROPERTY_TRUSTED_CERTS) instanceof List)) {
            throw new BEEPException("Must have trusted root certificates.");
        }
        object = (List)profileConfiguration.get(PROPERTY_TRUSTED_CERTS);
        iterator = object.iterator();
        PureTLSPackageBridge.initRootCertificates(this.context);
        try {
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                PureTLSPackageBridge.addRootCertificate(this.context, byArray);
            }
        }
        catch (Exception exception) {
            throw new BEEPException("Trusted (root) certificates must be in DRE format contained in byte[]");
        }
        return this;
    }

    public void startChannel(Channel channel, String string, String string2) throws StartChannelException {
        Object object;
        TCPSession tCPSession = (TCPSession)channel.getSession();
        if (string2 != null && (string2.equals(READY1) || string2.equals(READY2))) {
            string2 = PROCEED2;
        }
        SSLSocket sSLSocket = null;
        SessionCredential sessionCredential = null;
        try {
            this.begin(channel, URI, string2);
            this.context.setPolicy(this.policy);
            object = tCPSession.getSocket();
            sSLSocket = new SSLSocket(this.context, ((Socket)object).getInputStream(), ((Socket)object).getOutputStream(), ((Socket)object).getInetAddress().getHostName(), ((Socket)object).getPort(), 2);
        }
        catch (BEEPException bEEPException) {
            Log.logEntry((int)3, (String)bEEPException.getMessage());
            bEEPException.printStackTrace();
            tCPSession.terminate(bEEPException.getMessage());
        }
        catch (SSLThrewAlertException sSLThrewAlertException) {
            Log.logEntry((int)3, (String)sSLThrewAlertException.getMessage());
            sSLThrewAlertException.printStackTrace();
            tCPSession.terminate(sSLThrewAlertException.getMessage());
        }
        catch (IOException iOException) {
            Log.logEntry((int)3, (String)iOException.getMessage());
            iOException.printStackTrace();
            tCPSession.terminate(iOException.getMessage());
        }
        try {
            Object object2;
            String string3;
            X509Cert x509Cert;
            object = null;
            if (this.needPeerAuth) {
                object = sSLSocket.getCertificateChain();
                if (object == null) {
                    Log.logEntry((int)8, (String)"No certificate chain when there should be one. ");
                    throw new StartChannelException(550, "No certificate chain when there should be one. ");
                }
                Enumeration enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    x509Cert = (X509Cert)enumeration.nextElement();
                    string3 = x509Cert.getSubjectName().getNameString();
                    object2 = x509Cert.getIssuerName().getNameString();
                    Log.logEntry((int)8, (String)("Name = " + string3 + " issued by " + (String)object2));
                }
            } else {
                Log.logEntry((int)8, (String)"No peer authentication needed");
            }
            int n = sSLSocket.getCipherSuite();
            if (this.handshakeListener != null) {
                this.handshakeListener.handshakeCompleted((Session)tCPSession, (Vector)object, n);
            }
            x509Cert = new Hashtable();
            x509Cert.put("AUTHENTICATOR", URI);
            x509Cert.put("ALGORITHM", SSLPolicyInt.getCipherSuiteName((int)n));
            x509Cert.put("AUTHENTICATOR_TYPE", "TLS");
            if (object != null) {
                x509Cert.put("REMOTE_CERTIFICATE", ((Vector)object).elementAt(0));
            }
            sessionCredential = new SessionCredential((Hashtable)x509Cert);
            string3 = tCPSession.getProfileRegistry();
            string3.removeStartChannelListener(URI);
            if (this.abortSession) {
                this.abort(new BEEPError(451, ERR_TLS_NO_AUTHENTICATION), channel);
            } else {
                object2 = new Hashtable();
                ((Hashtable)object2).put("ENCRYPTION", "true");
                SessionTuningProperties sessionTuningProperties = new SessionTuningProperties((Hashtable)object2);
                this.complete(channel, TLSProfilePureTLS.generateCredential(), sessionCredential, sessionTuningProperties, (ProfileRegistry)string3, sSLSocket);
            }
        }
        catch (Exception exception) {
            Log.logEntry((int)3, (String)exception.getMessage());
            exception.printStackTrace();
            throw new StartChannelException(450, exception.getMessage());
        }
        throw new TuningResetException(URI);
    }

    public void closeChannel(Channel channel) throws CloseChannelException {
        Log.logEntry((int)7, (String)"Closing TLS channel.");
    }

    public boolean advertiseProfile(Session session) throws BEEPException {
        return true;
    }

    public TCPSession startTLS(TCPSession tCPSession) throws BEEPException {
        Cloneable cloneable;
        Channel channel = this.startChannel((Session)tCPSession, URI, false, READY2, null);
        String string = channel.getStartData();
        if (string == null || !string.equals(PROCEED1) && !string.equals(PROCEED2)) {
            throw new BEEPException(ERR_EXPECTED_PROCEED);
        }
        Log.logEntry((int)7, (String)"Staring TLS channel.");
        Socket socket = tCPSession.getSocket();
        SSLSocket sSLSocket = null;
        SessionCredential sessionCredential = null;
        try {
            this.context.setPolicy(this.policy);
            sSLSocket = new SSLSocket(this.context, socket.getInputStream(), socket.getOutputStream(), socket.getInetAddress().getHostName(), socket.getPort(), 1);
        }
        catch (SSLThrewAlertException sSLThrewAlertException) {
            tCPSession.terminate(sSLThrewAlertException.getMessage());
            throw new BEEPException(sSLThrewAlertException.getMessage());
        }
        catch (IOException iOException) {
            tCPSession.terminate(iOException.getMessage());
            throw new BEEPException(iOException.getMessage());
        }
        try {
            try {
                X509Cert x509Cert;
                cloneable = null;
                if (this.needPeerAuth) {
                    cloneable = sSLSocket.getCertificateChain();
                    if (cloneable == null) {
                        Log.logEntry((int)8, (String)"No certificate chain when there should be one. ");
                        throw new BEEPException("No certificate chain when there should be one. ");
                    }
                    Enumeration enumeration = ((Vector)cloneable).elements();
                    while (enumeration.hasMoreElements()) {
                        x509Cert = (X509Cert)enumeration.nextElement();
                        String string2 = x509Cert.getSubjectName().getNameString();
                        String string3 = x509Cert.getIssuerName().getNameString();
                        Log.logEntry((int)8, (String)("Name = " + string2 + " issued by " + string3));
                    }
                } else {
                    Log.logEntry((int)8, (String)"No peer authentication needed");
                }
                int n = sSLSocket.getCipherSuite();
                if (this.handshakeListener != null) {
                    this.handshakeListener.handshakeCompleted((Session)tCPSession, (Vector)cloneable, n);
                }
                x509Cert = new Hashtable();
                x509Cert.put("AUTHENTICATOR", URI);
                x509Cert.put("ALGORITHM", SSLPolicyInt.getCipherSuiteName((int)n));
                x509Cert.put("AUTHENTICATOR_TYPE", "TLS");
                if (cloneable != null) {
                    x509Cert.put("REMOTE_CERTIFICATE", ((Vector)cloneable).elementAt(0));
                }
                sessionCredential = new SessionCredential((Hashtable)x509Cert);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new BEEPException(exception.getMessage());
            }
            Object var13_17 = null;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            throw throwable;
        }
        if (this.abortSession) {
            tCPSession.close();
            throw new BEEPException(ERR_TLS_NO_AUTHENTICATION);
        }
        cloneable = new Hashtable();
        ((Hashtable)cloneable).put("ENCRYPTION", "true");
        SessionTuningProperties sessionTuningProperties = new SessionTuningProperties((Hashtable)cloneable);
        return (TCPSession)TuningProfile.reset((Session)tCPSession, (SessionCredential)TLSProfilePureTLS.generateCredential(), (SessionCredential)sessionCredential, (SessionTuningProperties)sessionTuningProperties, (ProfileRegistry)tCPSession.getProfileRegistry(), (Object)sSLSocket);
    }

    public static SessionCredential generateCredential() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(4);
        hashtable.put("AUTHENTICATOR", URI);
        return new SessionCredential(hashtable);
    }

    public void setHandshakeCompletedListener(TLSProfilePureTLSHandshakeCompletedListener tLSProfilePureTLSHandshakeCompletedListener) {
        this.handshakeListener = tLSProfilePureTLSHandshakeCompletedListener;
    }

    public int getMaxCiphersKnown() {
        return 103;
    }

    void setPrivateKey(PrivateKey privateKey) throws BEEPException {
        try {
            PureTLSPackageBridge.setPrivateKey(this.context, privateKey);
        }
        catch (Exception exception) {
            throw new BEEPException(exception.getMessage());
        }
    }

    void setCertChain(List list) throws BEEPException {
        if (list != null) {
            Iterator iterator = list.iterator();
            PureTLSPackageBridge.initCertificates(this.context);
            try {
                while (iterator.hasNext()) {
                    byte[] byArray = (byte[])iterator.next();
                    if (byArray == null) continue;
                    PureTLSPackageBridge.addCertificate(this.context, byArray);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new BEEPException(exception.getMessage());
            }
        }
    }

    void setRootCerts(List list) throws BEEPException {
        if (list != null) {
            Iterator iterator = list.iterator();
            PureTLSPackageBridge.initRootCertificates(this.context);
            try {
                while (iterator.hasNext()) {
                    byte[] byArray = (byte[])iterator.next();
                    if (byArray == null) continue;
                    PureTLSPackageBridge.addRootCertificate(this.context, byArray);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new BEEPException(exception.getMessage());
            }
        }
    }

    void setCipherSuite(short[] sArray) throws BEEPException {
        try {
            int n = 0;
            while (n < sArray.length) {
                if (sArray[n] > 103 || sArray[n] < 0) {
                    throw new BEEPException("Invalid cipher at " + n);
                }
                ++n;
            }
            this.policy.setCipherSuites(sArray);
        }
        catch (Exception exception) {
            throw new BEEPException(exception.getMessage());
        }
    }

    void setNeedPeerAuthentication(boolean bl) {
        if (!bl) {
            this.policy.acceptUnverifiableCertificates(true);
            this.policy.checkCertificateDates(false);
            this.policy.requireClientAuth(false);
            this.needPeerAuth = false;
        } else {
            this.policy.acceptUnverifiableCertificates(false);
            this.policy.checkCertificateDates(true);
            this.policy.requireClientAuth(true);
            this.needPeerAuth = true;
        }
    }
}

