/*
 * Decompiled with CFR 0.152.
 */
package org.beepcore.beep.profile.tls.jsse;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.beepcore.beep.core.BEEPError;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.CloseChannelException;
import org.beepcore.beep.core.ProfileRegistry;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.SessionCredential;
import org.beepcore.beep.core.SessionTuningProperties;
import org.beepcore.beep.core.StartChannelException;
import org.beepcore.beep.core.StartChannelListener;
import org.beepcore.beep.core.TuningProfile;
import org.beepcore.beep.core.TuningResetException;
import org.beepcore.beep.profile.Profile;
import org.beepcore.beep.profile.ProfileConfiguration;
import org.beepcore.beep.profile.tls.TLSProfile;
import org.beepcore.beep.profile.tls.jsse.TLSProfileJSSEHandshakeCompletedListener;
import org.beepcore.beep.transport.tcp.TCPSession;
import org.beepcore.beep.util.Log;

public class TLSProfileJSSE
extends TLSProfile
implements Profile,
StartChannelListener {
    public static final String PROCEED1 = "<proceed/>";
    public static final String PROCEED2 = "<proceed />";
    public static final String READY1 = "<ready/>";
    public static final String READY2 = "<ready />";
    static final String ERR_SERVER_MUST_HAVE_KEY = "Listener must be anonymous if no keys are specified.";
    static final String ERR_EXPECTED_PROCEED = "Error receiving <proceed />";
    static final String ERR_ILLEGAL_KEY_STORE = "Illegal Key Store Type property value";
    static final String ERR_ILLEGAL_TRUST_STORE = "Illegal Trust Store Type property value";
    static final String ERR_TLS_NOT_SUPPORTED_BY_SESSION = "TLS not supported by this session";
    static final String ERR_TLS_SOCKET = "TLS not supported by this session";
    static final String ERR_TLS_HANDSHAKE_WAIT = "Error waiting for TLS handshake to complete";
    static final String ERR_TLS_NO_AUTHENTICATION = "Authentication failed for this TLS negotiation";
    static final String PROPERTY_KEY_MANAGER_ALGORITHM = "Key Algorithm";
    static final String PROPERTY_KEY_MANAGER_PROVIDER = "Key Provider";
    static final String PROPERTY_TRUST_MANAGER_ALGORITHM = "Trust Algorithm";
    static final String PROPERTY_TRUST_MANAGER_PROVIDER = "Trust Provider";
    static final String PROPERTY_KEYSTORE_PASSPHRASE = "Key Store Passphrase";
    static final String PROPERTY_KEYSTORE_TYPE = "Key Store Data Type";
    static final String PROPERTY_KEYSTORE_NAME = "Key Store";
    static final String PROPERTY_KEYSTORE_FORMAT = "Key Store Format";
    static final String PROPERTY_KEYSTORE_PROVIDER = "Key Store Provider";
    static final String PROPERTY_TRUSTSTORE_PASSPHRASE = "Trust Store Passphrase";
    static final String PROPERTY_TRUSTSTORE_TYPE = "Trust Store Data Type";
    static final String PROPERTY_TRUSTSTORE_NAME = "Trust Store";
    static final String PROPERTY_TRUSTSTORE_FORMAT = "Trust Store Format";
    static final String PROPERTY_TRUSTSTORE_PROVIDER = "Trust Store Provider";
    static final String PROPERTY_CIPHER_SUITE = "Cipher Suite";
    static final String PROPERTY_CLIENT_AUTHENTICATION = "Initiator Authentication Required";
    static final String PROPERTY_SERVER_ANONYMOUS = "Listener Anonymous";
    static boolean needClientAuth = false;
    static boolean serverAnonymous = true;
    static String keyAlgorithm = null;
    static String keyProvider = null;
    static String trustAlgorithm = null;
    static String trustProvider = null;
    static String keyPassphrase = null;
    static String keyStoreType = null;
    static String keyStoreName = null;
    static String keyStoreFormat = null;
    static String keyStoreProvider = null;
    static String trustPassphrase = null;
    static String trustStoreType = null;
    static String trustStoreName = null;
    static String trustStoreFormat = null;
    static String trustStoreProvider = null;
    static SSLSocketFactory socketFactory = null;
    boolean notifiedHandshake = false;
    boolean waitingForHandshake = false;
    boolean abortSession = false;
    String uri = "http://iana.org/beep/TLS";
    static List handshakeListeners = null;

    public TLSProfileJSSE() {
        try {
            SSLContext sSLContext = SSLContext.getInstance((String)"TLS");
            sSLContext.init(null, null, null);
            socketFactory = sSLContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.logEntry((int)1, (String)"JSSE TLS Profile", (String)noSuchAlgorithmException.getMessage());
        }
        catch (KeyManagementException keyManagementException) {
            Log.logEntry((int)1, (String)"JSSE TLS Profile", (String)keyManagementException.getMessage());
        }
        if (handshakeListeners == null) {
            handshakeListeners = Collections.synchronizedList(new LinkedList());
        }
    }

    public StartChannelListener init(String string, ProfileConfiguration profileConfiguration) throws BEEPException {
        SSLContext sSLContext;
        KeyManagerFactory keyManagerFactory = null;
        KeyManager[] keyManagerArray = null;
        KeyStore keyStore = null;
        TrustManagerFactory trustManagerFactory = null;
        TrustManager[] trustManagerArray = null;
        KeyStore keyStore2 = null;
        this.uri = string;
        try {
            sSLContext = SSLContext.getInstance((String)"TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new BEEPException("TLS Algorithm Not Found. Probable cause is the JSSE provider has not been added to the java.security file.");
        }
        try {
            keyAlgorithm = profileConfiguration.getProperty(PROPERTY_KEY_MANAGER_ALGORITHM, null);
            keyProvider = profileConfiguration.getProperty(PROPERTY_KEY_MANAGER_PROVIDER, null);
            trustAlgorithm = profileConfiguration.getProperty(PROPERTY_TRUST_MANAGER_ALGORITHM, null);
            trustProvider = profileConfiguration.getProperty(PROPERTY_TRUST_MANAGER_PROVIDER, null);
            keyPassphrase = profileConfiguration.getProperty(PROPERTY_KEYSTORE_PASSPHRASE, null);
            keyStoreType = profileConfiguration.getProperty(PROPERTY_KEYSTORE_TYPE, null);
            keyStoreName = profileConfiguration.getProperty(PROPERTY_KEYSTORE_NAME, null);
            keyStoreFormat = profileConfiguration.getProperty(PROPERTY_KEYSTORE_FORMAT, "JKS");
            keyStoreProvider = profileConfiguration.getProperty(PROPERTY_KEYSTORE_PROVIDER, null);
            trustPassphrase = profileConfiguration.getProperty(PROPERTY_TRUSTSTORE_PASSPHRASE, null);
            trustStoreType = profileConfiguration.getProperty(PROPERTY_TRUSTSTORE_TYPE, null);
            trustStoreName = profileConfiguration.getProperty(PROPERTY_TRUSTSTORE_NAME, null);
            trustStoreFormat = profileConfiguration.getProperty(PROPERTY_TRUSTSTORE_FORMAT, "JKS");
            trustStoreProvider = profileConfiguration.getProperty(PROPERTY_TRUSTSTORE_PROVIDER, null);
            needClientAuth = new Boolean(profileConfiguration.getProperty(PROPERTY_CLIENT_AUTHENTICATION, "false"));
            serverAnonymous = new Boolean(profileConfiguration.getProperty(PROPERTY_SERVER_ANONYMOUS, "true"));
            if (keyAlgorithm != null) {
                keyManagerFactory = keyProvider != null ? KeyManagerFactory.getInstance((String)keyAlgorithm, (String)keyProvider) : KeyManagerFactory.getInstance((String)keyAlgorithm);
                keyStore = keyStoreProvider != null ? KeyStore.getInstance(keyStoreFormat, keyStoreProvider) : KeyStore.getInstance(keyStoreFormat);
                if (!keyStoreType.equals("file")) {
                    throw new BEEPException(ERR_ILLEGAL_KEY_STORE);
                }
                keyStore.load(new FileInputStream(keyStoreName), keyPassphrase.toCharArray());
                keyManagerFactory.init(keyStore, keyPassphrase.toCharArray());
                keyManagerArray = keyManagerFactory.getKeyManagers();
            } else {
                keyManagerArray = null;
            }
            if (trustAlgorithm != null) {
                trustManagerFactory = trustProvider != null ? TrustManagerFactory.getInstance((String)trustAlgorithm, (String)trustProvider) : TrustManagerFactory.getInstance((String)trustAlgorithm);
                keyStore2 = trustStoreProvider != null ? KeyStore.getInstance(trustStoreFormat, trustStoreProvider) : KeyStore.getInstance(trustStoreFormat);
                if (!trustStoreType.equals("file")) {
                    throw new BEEPException(ERR_ILLEGAL_TRUST_STORE);
                }
                keyStore2.load(new FileInputStream(trustStoreName), trustPassphrase.toCharArray());
                trustManagerFactory.init(keyStore2);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            } else {
                trustManagerArray = null;
            }
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            socketFactory = sSLContext.getSocketFactory();
            return this;
        }
        catch (Exception exception) {
            Log.logEntry((int)3, (Throwable)exception);
            throw new BEEPException(exception.getMessage());
        }
    }

    public boolean advertiseProfile(Session session, SessionTuningProperties sessionTuningProperties) throws BEEPException {
        return true;
    }

    public void startChannel(Channel channel, String string, String string2) throws StartChannelException {
        try {
            TCPSession tCPSession = (TCPSession)channel.getSession();
            if (string2 != null && (string2.equals(READY1) || string2.equals(READY2))) {
                string2 = PROCEED2;
            }
            this.begin(channel, this.uri, string2);
            Socket socket = tCPSession.getSocket();
            SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
            TLSHandshake tLSHandshake = new TLSHandshake();
            sSLSocket.addHandshakeCompletedListener(tLSHandshake);
            sSLSocket.setUseClientMode(false);
            sSLSocket.setNeedClientAuth(needClientAuth);
            sSLSocket.setEnabledCipherSuites(sSLSocket.getSupportedCipherSuites());
            tLSHandshake.session = channel.getSession();
            sSLSocket.startHandshake();
            TLSHandshake tLSHandshake2 = tLSHandshake;
            synchronized (tLSHandshake2) {
                if (!tLSHandshake.notifiedHandshake) {
                    tLSHandshake.waitingForHandshake = true;
                    tLSHandshake.wait();
                    tLSHandshake.waitingForHandshake = false;
                }
            }
            ProfileRegistry profileRegistry = tCPSession.getProfileRegistry();
            profileRegistry.removeStartChannelListener(this.uri);
            if (this.abortSession) {
                this.abort(new BEEPError(451, ERR_TLS_NO_AUTHENTICATION), channel);
            } else {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("ENCRYPTION", "true");
                SessionTuningProperties sessionTuningProperties = new SessionTuningProperties(hashtable);
                this.complete(channel, TLSProfileJSSE.generateCredential(), tLSHandshake.cred, sessionTuningProperties, profileRegistry, sSLSocket);
            }
        }
        catch (Exception exception) {
            Log.logEntry((int)3, (String)exception.getMessage());
            throw new StartChannelException(450, exception.getMessage());
        }
        throw new TuningResetException(this.uri);
    }

    public void closeChannel(Channel channel) throws CloseChannelException {
        Log.logEntry((int)7, (String)"Closing TLS channel.");
    }

    public boolean advertiseProfile(Session session) throws BEEPException {
        return true;
    }

    public TCPSession startTLS(TCPSession tCPSession) throws BEEPException {
        Object object;
        Channel channel = this.startChannel((Session)tCPSession, this.uri, false, READY2, null);
        String string = channel.getStartData();
        Log.logEntry((int)7, (String)("Got start data of " + string));
        if (string == null || !string.equals(PROCEED1) && !string.equals(PROCEED2)) {
            throw new BEEPException(ERR_EXPECTED_PROCEED);
        }
        Socket socket = tCPSession.getSocket();
        SSLSocket sSLSocket = null;
        TLSHandshake tLSHandshake = new TLSHandshake();
        try {
            sSLSocket = (SSLSocket)socketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
            sSLSocket.addHandshakeCompletedListener(tLSHandshake);
            sSLSocket.setUseClientMode(true);
            sSLSocket.setNeedClientAuth(needClientAuth);
            sSLSocket.setEnabledCipherSuites(sSLSocket.getSupportedCipherSuites());
            tLSHandshake.session = tCPSession;
            sSLSocket.startHandshake();
            object = tLSHandshake;
            synchronized (object) {
                if (!tLSHandshake.notifiedHandshake) {
                    tLSHandshake.waitingForHandshake = true;
                    tLSHandshake.wait();
                    tLSHandshake.waitingForHandshake = false;
                }
            }
        }
        catch (SSLException sSLException) {
            Log.logEntry((int)3, (Throwable)sSLException);
            throw new BEEPException(sSLException.getMessage());
        }
        catch (IOException iOException) {
            Log.logEntry((int)3, (Throwable)iOException);
            throw new BEEPException("TLS not supported by this session");
        }
        catch (InterruptedException interruptedException) {
            Log.logEntry((int)3, (Throwable)interruptedException);
            throw new BEEPException(ERR_TLS_HANDSHAKE_WAIT);
        }
        if (this.abortSession) {
            tCPSession.close();
            throw new BEEPException(ERR_TLS_NO_AUTHENTICATION);
        }
        object = new Hashtable();
        ((Hashtable)object).put("ENCRYPTION", "true");
        SessionTuningProperties sessionTuningProperties = new SessionTuningProperties((Hashtable)object);
        return (TCPSession)TuningProfile.reset((Session)tCPSession, (SessionCredential)TLSProfileJSSE.generateCredential(), (SessionCredential)tLSHandshake.cred, (SessionTuningProperties)sessionTuningProperties, (ProfileRegistry)tCPSession.getProfileRegistry(), (Object)sSLSocket);
    }

    public static SessionCredential generateCredential() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(4);
        hashtable.put("AUTHENTICATOR", "http://iana.org/beep/TLS");
        return new SessionCredential(hashtable);
    }

    public void addHandshakeCompletedListener(TLSProfileJSSEHandshakeCompletedListener tLSProfileJSSEHandshakeCompletedListener) {
        this.removeHandshakeCompletedListener(tLSProfileJSSEHandshakeCompletedListener);
        handshakeListeners.add(tLSProfileJSSEHandshakeCompletedListener);
    }

    public void removeHandshakeCompletedListener(TLSProfileJSSEHandshakeCompletedListener tLSProfileJSSEHandshakeCompletedListener) {
        handshakeListeners.remove(tLSProfileJSSEHandshakeCompletedListener);
    }

    class TLSHandshake
    implements HandshakeCompletedListener {
        Session session;
        SessionCredential cred;
        boolean notifiedHandshake = false;
        boolean waitingForHandshake = false;

        TLSHandshake() {
        }

        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
            Object object;
            Object object2;
            List list = handshakeListeners;
            synchronized (list) {
                object2 = handshakeListeners.iterator();
                while (object2.hasNext()) {
                    object = (TLSProfileJSSEHandshakeCompletedListener)object2.next();
                    if (object.handshakeCompleted(this.session, handshakeCompletedEvent)) continue;
                    TLSProfileJSSE.this.abortSession = true;
                    break;
                }
            }
            object2 = new Hashtable();
            try {
                ((Hashtable)object2).put("AUTHENTICATOR", handshakeCompletedEvent.getPeerCertificateChain()[0].getSubjectDN().getName());
                ((Hashtable)object2).put("REMOTE_CERTIFICATE", handshakeCompletedEvent.getPeerCertificateChain());
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                ((Hashtable)object2).put("AUTHENTICATOR", "");
                ((Hashtable)object2).put("REMOTE_CERTIFICATE", "");
            }
            this.cred = new SessionCredential((Hashtable)object2);
            object = this;
            synchronized (object) {
                if (this.waitingForHandshake) {
                    this.notify();
                }
                this.notifiedHandshake = true;
            }
        }
    }
}

